/*
 * Decompiled with CFR 0.152.
 */
package org.jsoup.parser;

import org.jsoup.helper.Validate;
import org.jsoup.internal.Normalizer;
import org.jsoup.nodes.Attributes;
import org.jsoup.nodes.Range;
import org.jsoup.parser.CharacterReader;
import org.jsoup.parser.ParseSettings;
import org.jsoup.parser.TokenData;
import org.jsoup.parser.TreeBuilder;
import org.jspecify.annotations.Nullable;

abstract class Token {
    static final int UnsetPos = -1;
    final TokenType type;
    int startPos;
    int endPos = -1;

    private Token(TokenType type) {
        this.type = type;
    }

    String tokenType() {
        return this.getClass().getSimpleName();
    }

    Token reset() {
        this.startPos = -1;
        this.endPos = -1;
        return this;
    }

    int startPos() {
        return this.startPos;
    }

    void startPos(int pos) {
        this.startPos = pos;
    }

    int endPos() {
        return this.endPos;
    }

    void endPos(int pos) {
        this.endPos = pos;
    }

    final boolean isDoctype() {
        return this.type == TokenType.Doctype;
    }

    final Doctype asDoctype() {
        return (Doctype)this;
    }

    final boolean isStartTag() {
        return this.type == TokenType.StartTag;
    }

    final StartTag asStartTag() {
        return (StartTag)this;
    }

    final boolean isEndTag() {
        return this.type == TokenType.EndTag;
    }

    final EndTag asEndTag() {
        return (EndTag)this;
    }

    final boolean isComment() {
        return this.type == TokenType.Comment;
    }

    final Comment asComment() {
        return (Comment)this;
    }

    final boolean isCharacter() {
        return this.type == TokenType.Character;
    }

    final boolean isCData() {
        return this instanceof CData;
    }

    final Character asCharacter() {
        return (Character)this;
    }

    final XmlDecl asXmlDecl() {
        return (XmlDecl)this;
    }

    final boolean isEOF() {
        return this.type == TokenType.EOF;
    }

    public static enum TokenType {
        Doctype,
        StartTag,
        EndTag,
        Comment,
        Character,
        XmlDecl,
        EOF;

    }

    static final class Doctype
    extends Token {
        final TokenData name = new TokenData();
        @Nullable String pubSysKey = null;
        final TokenData publicIdentifier = new TokenData();
        final TokenData systemIdentifier = new TokenData();
        boolean forceQuirks = false;

        Doctype() {
            super(TokenType.Doctype);
        }

        @Override
        Token reset() {
            super.reset();
            this.name.reset();
            this.pubSysKey = null;
            this.publicIdentifier.reset();
            this.systemIdentifier.reset();
            this.forceQuirks = false;
            return this;
        }

        String getName() {
            return this.name.value();
        }

        @Nullable String getPubSysKey() {
            return this.pubSysKey;
        }

        String getPublicIdentifier() {
            return this.publicIdentifier.value();
        }

        public String getSystemIdentifier() {
            return this.systemIdentifier.value();
        }

        public boolean isForceQuirks() {
            return this.forceQuirks;
        }

        public String toString() {
            return "<!doctype " + this.getName() + ">";
        }
    }

    static final class StartTag
    extends Tag {
        StartTag(TreeBuilder treeBuilder) {
            super(TokenType.StartTag, treeBuilder);
        }

        @Override
        Tag reset() {
            super.reset();
            this.attributes = null;
            return this;
        }

        StartTag nameAttr(String name, Attributes attributes) {
            this.tagName.set(name);
            this.attributes = attributes;
            this.normalName = ParseSettings.normalName(name);
            return this;
        }

        @Override
        public String toString() {
            String closer;
            String string = closer = this.isSelfClosing() ? "/>" : ">";
            if (this.hasAttributes() && this.attributes.size() > 0) {
                return "<" + this.toStringName() + " " + this.attributes.toString() + closer;
            }
            return "<" + this.toStringName() + closer;
        }
    }

    static final class EndTag
    extends Tag {
        EndTag(TreeBuilder treeBuilder) {
            super(TokenType.EndTag, treeBuilder);
        }

        @Override
        public String toString() {
            return "</" + this.toStringName() + ">";
        }
    }

    static final class Comment
    extends Token {
        private final TokenData data = new TokenData();
        boolean bogus = false;

        @Override
        Token reset() {
            super.reset();
            this.data.reset();
            this.bogus = false;
            return this;
        }

        Comment() {
            super(TokenType.Comment);
        }

        String getData() {
            return this.data.value();
        }

        Comment append(String append) {
            this.data.append(append);
            return this;
        }

        Comment append(char append) {
            this.data.append(append);
            return this;
        }

        public String toString() {
            return "<!--" + this.getData() + "-->";
        }
    }

    static final class CData
    extends Character {
        CData(String data) {
            this.data(data);
        }

        @Override
        public String toString() {
            return "<![CDATA[" + this.getData() + "]]>";
        }
    }

    static class Character
    extends Token {
        final TokenData data = new TokenData();

        Character() {
            super(TokenType.Character);
        }

        Character(Character source) {
            super(TokenType.Character);
            this.startPos = source.startPos;
            this.endPos = source.endPos;
            this.data.set(source.data.value());
        }

        @Override
        Token reset() {
            super.reset();
            this.data.reset();
            return this;
        }

        Character data(String str) {
            this.data.set(str);
            return this;
        }

        Character append(String str) {
            this.data.append(str);
            return this;
        }

        String getData() {
            return this.data.value();
        }

        public String toString() {
            return this.getData();
        }
    }

    static final class XmlDecl
    extends Tag {
        boolean isDeclaration = true;

        public XmlDecl(TreeBuilder treeBuilder) {
            super(TokenType.XmlDecl, treeBuilder);
        }

        @Override
        XmlDecl reset() {
            super.reset();
            this.isDeclaration = true;
            return this;
        }

        @Override
        public String toString() {
            String close;
            String open = this.isDeclaration ? "<!" : "<?";
            String string = close = this.isDeclaration ? ">" : "?>";
            if (this.hasAttributes() && this.attributes.size() > 0) {
                return open + this.toStringName() + " " + this.attributes.toString() + close;
            }
            return open + this.toStringName() + close;
        }
    }

    static final class EOF
    extends Token {
        EOF() {
            super(TokenType.EOF);
        }

        @Override
        Token reset() {
            super.reset();
            return this;
        }

        public String toString() {
            return "";
        }
    }

    static abstract class Tag
    extends Token {
        protected TokenData tagName = new TokenData();
        protected @Nullable String normalName;
        boolean selfClosing = false;
        @Nullable Attributes attributes;
        private final TokenData attrName = new TokenData();
        private final TokenData attrValue = new TokenData();
        private boolean hasEmptyAttrValue = false;
        final TreeBuilder treeBuilder;
        final boolean trackSource;
        int attrNameStart;
        int attrNameEnd;
        int attrValStart;
        int attrValEnd;
        private static final int MaxAttributes = 512;

        Tag(TokenType type, TreeBuilder treeBuilder) {
            super(type);
            this.treeBuilder = treeBuilder;
            this.trackSource = treeBuilder.trackSourceRange;
        }

        @Override
        Tag reset() {
            super.reset();
            this.tagName.reset();
            this.normalName = null;
            this.selfClosing = false;
            this.attributes = null;
            this.resetPendingAttr();
            return this;
        }

        private void resetPendingAttr() {
            this.attrName.reset();
            this.attrValue.reset();
            this.hasEmptyAttrValue = false;
            if (this.trackSource) {
                this.attrValEnd = -1;
                this.attrValStart = -1;
                this.attrNameEnd = -1;
                this.attrNameStart = -1;
            }
        }

        final void newAttribute() {
            if (this.attributes == null) {
                this.attributes = new Attributes();
            }
            if (this.attrName.hasData() && this.attributes.size() < 512) {
                String name = this.attrName.value();
                if (!(name = name.trim()).isEmpty()) {
                    String value = this.attrValue.hasData() ? this.attrValue.value() : (this.hasEmptyAttrValue ? "" : null);
                    this.attributes.add(name, value);
                    this.trackAttributeRange(name);
                }
            }
            this.resetPendingAttr();
        }

        private void trackAttributeRange(String name) {
            if (this.trackSource && this.isStartTag()) {
                StartTag start = this.asStartTag();
                CharacterReader r = start.treeBuilder.reader;
                boolean preserve = start.treeBuilder.settings.preserveAttributeCase();
                assert (this.attributes != null);
                if (!preserve) {
                    name = Normalizer.lowerCase(name);
                }
                if (this.attributes.sourceRange(name).nameRange().isTracked()) {
                    return;
                }
                if (!this.attrValue.hasData()) {
                    this.attrValStart = this.attrValEnd = this.attrNameEnd;
                }
                Range.AttributeRange range = new Range.AttributeRange(new Range(new Range.Position(this.attrNameStart, r.lineNumber(this.attrNameStart), r.columnNumber(this.attrNameStart)), new Range.Position(this.attrNameEnd, r.lineNumber(this.attrNameEnd), r.columnNumber(this.attrNameEnd))), new Range(new Range.Position(this.attrValStart, r.lineNumber(this.attrValStart), r.columnNumber(this.attrValStart)), new Range.Position(this.attrValEnd, r.lineNumber(this.attrValEnd), r.columnNumber(this.attrValEnd))));
                this.attributes.sourceRange(name, range);
            }
        }

        final boolean hasAttributes() {
            return this.attributes != null;
        }

        final boolean hasAttributeIgnoreCase(String key) {
            return this.attributes != null && this.attributes.hasKeyIgnoreCase(key);
        }

        final void finaliseTag() {
            if (this.attrName.hasData()) {
                this.newAttribute();
            }
        }

        final String name() {
            return this.tagName.value();
        }

        final String normalName() {
            Validate.isFalse(this.normalName == null || this.normalName.isEmpty());
            return this.normalName;
        }

        final String toStringName() {
            String name = this.tagName.value();
            return name.isEmpty() ? "[unset]" : name;
        }

        final Tag name(String name) {
            this.tagName.set(name);
            this.normalName = ParseSettings.normalName(this.tagName.value());
            return this;
        }

        final boolean isSelfClosing() {
            return this.selfClosing;
        }

        final void appendTagName(String append) {
            append = append.replace('\u0000', '\ufffd');
            this.tagName.append(append);
            this.normalName = ParseSettings.normalName(this.tagName.value());
        }

        final void appendTagName(char append) {
            this.appendTagName(String.valueOf(append));
        }

        final void appendAttributeName(String append, int startPos, int endPos) {
            append = append.replace('\u0000', '\ufffd');
            this.attrName.append(append);
            this.attrNamePos(startPos, endPos);
        }

        final void appendAttributeName(char append, int startPos, int endPos) {
            this.attrName.append(append);
            this.attrNamePos(startPos, endPos);
        }

        final void appendAttributeValue(String append, int startPos, int endPos) {
            this.attrValue.append(append);
            this.attrValPos(startPos, endPos);
        }

        final void appendAttributeValue(char append, int startPos, int endPos) {
            this.attrValue.append(append);
            this.attrValPos(startPos, endPos);
        }

        final void appendAttributeValue(int[] appendCodepoints, int startPos, int endPos) {
            for (int codepoint : appendCodepoints) {
                this.attrValue.appendCodePoint(codepoint);
            }
            this.attrValPos(startPos, endPos);
        }

        final void setEmptyAttributeValue() {
            this.hasEmptyAttrValue = true;
        }

        private void attrNamePos(int startPos, int endPos) {
            if (this.trackSource) {
                this.attrNameStart = this.attrNameStart > -1 ? this.attrNameStart : startPos;
                this.attrNameEnd = endPos;
            }
        }

        private void attrValPos(int startPos, int endPos) {
            if (this.trackSource) {
                this.attrValStart = this.attrValStart > -1 ? this.attrValStart : startPos;
                this.attrValEnd = endPos;
            }
        }

        public abstract String toString();
    }
}

