/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tsfile.read.common.block.column;

import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.tsfile.block.column.Column;
import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.read.common.block.column.BinaryColumn;
import org.apache.tsfile.read.common.block.column.ColumnEncoder;
import org.apache.tsfile.utils.Binary;

public class BinaryArrayColumnEncoder
implements ColumnEncoder {
    @Override
    public Column readColumn(ByteBuffer input, TSDataType dataType, int positionCount) {
        if (!TSDataType.TEXT.equals((Object)dataType)) {
            throw new IllegalArgumentException("Invalid data type: " + (Object)((Object)dataType));
        }
        boolean[] nullIndicators = ColumnEncoder.deserializeNullIndicators(input, positionCount);
        Binary[] values = new Binary[positionCount];
        if (nullIndicators == null) {
            for (int i = 0; i < positionCount; ++i) {
                int length = input.getInt();
                byte[] value = new byte[length];
                input.get(value);
                values[i] = new Binary(value);
            }
        } else {
            for (int i = 0; i < positionCount; ++i) {
                if (nullIndicators[i]) continue;
                int length = input.getInt();
                byte[] value = new byte[length];
                input.get(value);
                values[i] = new Binary(value);
            }
        }
        return new BinaryColumn(0, positionCount, nullIndicators, values);
    }

    @Override
    public void writeColumn(DataOutputStream output, Column column) throws IOException {
        ColumnEncoder.serializeNullIndicators(output, column);
        TSDataType dataType = column.getDataType();
        int positionCount = column.getPositionCount();
        if (TSDataType.TEXT.equals((Object)dataType)) {
            for (int i = 0; i < positionCount; ++i) {
                if (column.isNull(i)) continue;
                Binary binary = column.getBinary(i);
                output.writeInt(binary.getLength());
                output.write(binary.getValues());
            }
        } else {
            throw new IllegalArgumentException("Invalid data type: " + (Object)((Object)dataType));
        }
    }
}

