/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.consensus.response.pipe.task;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.commons.exception.pipe.PipeRuntimeException;
import org.apache.iotdb.commons.pipe.agent.task.meta.PipeMeta;
import org.apache.iotdb.commons.pipe.agent.task.meta.PipeRuntimeMeta;
import org.apache.iotdb.commons.pipe.agent.task.meta.PipeStaticMeta;
import org.apache.iotdb.commons.pipe.agent.task.meta.PipeStatus;
import org.apache.iotdb.commons.pipe.agent.task.meta.PipeTaskMeta;
import org.apache.iotdb.commons.pipe.agent.task.meta.PipeTemporaryMetaInCoordinator;
import org.apache.iotdb.commons.pipe.config.constant.SystemConstant;
import org.apache.iotdb.confignode.manager.pipe.source.ConfigRegionListeningFilter;
import org.apache.iotdb.confignode.rpc.thrift.TGetAllPipeInfoResp;
import org.apache.iotdb.confignode.rpc.thrift.TShowPipeInfo;
import org.apache.iotdb.confignode.rpc.thrift.TShowPipeResp;
import org.apache.iotdb.confignode.service.ConfigNode;
import org.apache.iotdb.consensus.common.DataSet;
import org.apache.iotdb.db.utils.DateTimeUtils;
import org.apache.iotdb.pipe.api.customizer.parameter.PipeParameters;

public class PipeTableResp
implements DataSet {
    private final TSStatus status;
    private final List<PipeMeta> allPipeMeta;

    public PipeTableResp(TSStatus status, List<PipeMeta> allPipeMeta) {
        this.status = status;
        this.allPipeMeta = allPipeMeta;
    }

    public List<PipeMeta> getAllPipeMeta() {
        return this.allPipeMeta;
    }

    public PipeTableResp filter(Boolean whereClause, String pipeName) {
        if (Objects.isNull(pipeName)) {
            return this;
        }
        if (whereClause == null || !whereClause.booleanValue()) {
            return new PipeTableResp(this.status, this.allPipeMeta.stream().filter(pipeMeta -> pipeMeta.getStaticMeta().getPipeName().equals(pipeName)).collect(Collectors.toList()));
        }
        String sortedConnectorParametersString = this.allPipeMeta.stream().filter(pipeMeta -> pipeMeta.getStaticMeta().getPipeName().equals(pipeName)).findFirst().map(pipeMeta -> pipeMeta.getStaticMeta().getConnectorParameters().toString()).orElse(null);
        return new PipeTableResp(this.status, this.allPipeMeta.stream().filter(pipeMeta -> pipeMeta.getStaticMeta().getConnectorParameters().toString().equals(sortedConnectorParametersString)).collect(Collectors.toList()));
    }

    public PipeTableResp filter(Boolean whereClause, String pipeName, boolean isTableModel) {
        PipeTableResp resp = this.filter(whereClause, pipeName);
        resp.allPipeMeta.removeIf(meta -> !meta.getStaticMeta().visibleUnder(isTableModel));
        return resp;
    }

    public TGetAllPipeInfoResp convertToTGetAllPipeInfoResp() throws IOException {
        ArrayList<ByteBuffer> pipeInformationByteBuffers = new ArrayList<ByteBuffer>();
        for (PipeMeta pipeMeta : this.allPipeMeta) {
            pipeInformationByteBuffers.add(pipeMeta.serialize());
        }
        return new TGetAllPipeInfoResp(this.status, pipeInformationByteBuffers);
    }

    public TShowPipeResp convertToTShowPipeResp() {
        ArrayList<TShowPipeInfo> showPipeInfoList = new ArrayList<TShowPipeInfo>();
        for (PipeMeta pipeMeta : this.allPipeMeta) {
            String exceptionMessage;
            HashMap<String, Set> pipeExceptionMessage2RegionIdsMap = new HashMap<String, Set>();
            HashMap<String, Set> pipeExceptionMessage2NodeIdsMap = new HashMap<String, Set>();
            PipeStaticMeta staticMeta = pipeMeta.getStaticMeta();
            PipeRuntimeMeta runtimeMeta = pipeMeta.getRuntimeMeta();
            StringBuilder exceptionMessageBuilder = new StringBuilder();
            for (Map.Entry entry : runtimeMeta.getNodeId2PipeRuntimeExceptionMap().entrySet()) {
                Integer nodeId = (Integer)entry.getKey();
                PipeRuntimeException pipeRuntimeException = (PipeRuntimeException)entry.getValue();
                exceptionMessage = DateTimeUtils.convertLongToDate((long)pipeRuntimeException.getTimeStamp(), (String)"ms") + ", " + pipeRuntimeException.getMessage();
                pipeExceptionMessage2NodeIdsMap.computeIfAbsent(exceptionMessage, k -> new TreeSet()).add(nodeId);
            }
            for (Map.Entry entry : runtimeMeta.getConsensusGroupId2TaskMetaMap().entrySet()) {
                Integer regionId = (Integer)entry.getKey();
                for (PipeRuntimeException e : ((PipeTaskMeta)entry.getValue()).getExceptionMessages()) {
                    String exceptionMessage2 = DateTimeUtils.convertLongToDate((long)e.getTimeStamp(), (String)"ms") + ", " + e.getMessage();
                    pipeExceptionMessage2RegionIdsMap.computeIfAbsent(exceptionMessage2, k -> new TreeSet()).add(regionId);
                }
            }
            for (Map.Entry entry : pipeExceptionMessage2NodeIdsMap.entrySet()) {
                String exceptionMessage3 = (String)entry.getKey();
                Set set = (Set)entry.getValue();
                exceptionMessageBuilder.append("nodeIds: ").append(set).append(", ").append(exceptionMessage3).append("; ");
            }
            int size = pipeExceptionMessage2RegionIdsMap.size();
            int count = 0;
            for (Map.Entry entry : pipeExceptionMessage2RegionIdsMap.entrySet()) {
                exceptionMessage = (String)entry.getKey();
                Set regionIds = (Set)entry.getValue();
                exceptionMessageBuilder.append("regionIds: ").append(regionIds).append(", ").append(exceptionMessage);
                if (++count >= size) continue;
                exceptionMessageBuilder.append("; ");
            }
            TShowPipeInfo showPipeInfo = new TShowPipeInfo(staticMeta.getPipeName(), staticMeta.getCreationTime(), ((PipeStatus)runtimeMeta.getStatus().get()).name(), SystemConstant.addSystemKeysIfNecessary((PipeParameters)staticMeta.getExtractorParameters()).toString(), staticMeta.getProcessorParameters().toString(), staticMeta.getConnectorParameters().toString(), exceptionMessageBuilder.toString());
            PipeTemporaryMetaInCoordinator pipeTemporaryMetaInCoordinator = (PipeTemporaryMetaInCoordinator)pipeMeta.getTemporaryMeta();
            boolean canCalculateOnLocal = this.canCalculateOnLocal(pipeMeta);
            showPipeInfo.setRemainingEventCount(canCalculateOnLocal ? -1L : pipeTemporaryMetaInCoordinator.getGlobalRemainingEvents());
            showPipeInfo.setEstimatedRemainingTime(canCalculateOnLocal ? -1.0 : pipeTemporaryMetaInCoordinator.getGlobalRemainingTime());
            showPipeInfoList.add(showPipeInfo);
        }
        showPipeInfoList.sort(Comparator.comparing(pipeInfo -> pipeInfo.id));
        return new TShowPipeResp().setStatus(this.status).setPipeInfoList(showPipeInfoList);
    }

    private boolean canCalculateOnLocal(PipeMeta pipeMeta) {
        try {
            return ConfigNode.getInstance().getConfigManager().getNodeManager().getRegisteredDataNodeCount() == 1 && ConfigRegionListeningFilter.parseListeningPlanTypeSet(pipeMeta.getStaticMeta().getExtractorParameters()).isEmpty();
        }
        catch (IllegalPathException e) {
            return false;
        }
    }
}

