/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.agent.plugin.dataregion;

import java.util.Map;
import org.apache.iotdb.commons.pipe.agent.plugin.PipePluginAgent;
import org.apache.iotdb.commons.pipe.agent.plugin.constructor.PipeProcessorConstructor;
import org.apache.iotdb.commons.pipe.agent.plugin.constructor.PipeSinkConstructor;
import org.apache.iotdb.commons.pipe.agent.plugin.constructor.PipeSourceConstructor;
import org.apache.iotdb.commons.pipe.agent.plugin.meta.DataNodePipePluginMetaKeeper;
import org.apache.iotdb.commons.pipe.agent.plugin.meta.PipePluginMetaKeeper;
import org.apache.iotdb.commons.pipe.datastructure.visibility.Visibility;
import org.apache.iotdb.commons.pipe.datastructure.visibility.VisibilityUtils;
import org.apache.iotdb.db.pipe.agent.plugin.dataregion.PipeDataRegionProcessorConstructor;
import org.apache.iotdb.db.pipe.agent.plugin.dataregion.PipeDataRegionSinkConstructor;
import org.apache.iotdb.db.pipe.agent.plugin.dataregion.PipeDataRegionSourceConstructor;
import org.apache.iotdb.pipe.api.PipeConnector;
import org.apache.iotdb.pipe.api.PipeExtractor;
import org.apache.iotdb.pipe.api.PipeProcessor;
import org.apache.iotdb.pipe.api.customizer.parameter.PipeParameters;
import org.apache.iotdb.pipe.api.exception.PipeParameterNotValidException;

public class PipeDataRegionPluginAgent
extends PipePluginAgent {
    public PipeDataRegionPluginAgent(DataNodePipePluginMetaKeeper pipePluginMetaKeeper) {
        super((PipePluginMetaKeeper)pipePluginMetaKeeper);
    }

    protected PipeSourceConstructor createPipeExtractorConstructor(PipePluginMetaKeeper pipePluginMetaKeeper) {
        return new PipeDataRegionSourceConstructor((DataNodePipePluginMetaKeeper)pipePluginMetaKeeper);
    }

    protected PipeProcessorConstructor createPipeProcessorConstructor(PipePluginMetaKeeper pipePluginMetaKeeper) {
        return new PipeDataRegionProcessorConstructor((DataNodePipePluginMetaKeeper)pipePluginMetaKeeper);
    }

    protected PipeSinkConstructor createPipeConnectorConstructor(PipePluginMetaKeeper pipePluginMetaKeeper) {
        return new PipeDataRegionSinkConstructor((DataNodePipePluginMetaKeeper)pipePluginMetaKeeper);
    }

    public void validate(String pipeName, Map<String, String> extractorAttributes, Map<String, String> processorAttributes, Map<String, String> connectorAttributes) throws Exception {
        PipeExtractor temporaryExtractor = this.validateExtractor(extractorAttributes);
        PipeProcessor temporaryProcessor = this.validateProcessor(processorAttributes);
        PipeConnector temporaryConnector = this.validateConnector(pipeName, connectorAttributes);
        Visibility pipeVisibility = VisibilityUtils.calculateFromExtractorParameters((PipeParameters)new PipeParameters(extractorAttributes));
        Visibility extractorVisibility = VisibilityUtils.calculateFromPluginClass(temporaryExtractor.getClass());
        Visibility processorVisibility = VisibilityUtils.calculateFromPluginClass(temporaryProcessor.getClass());
        Visibility connectorVisibility = VisibilityUtils.calculateFromPluginClass(temporaryConnector.getClass());
        if (!VisibilityUtils.isCompatible((Visibility)pipeVisibility, (Visibility[])new Visibility[]{extractorVisibility, processorVisibility, connectorVisibility})) {
            throw new PipeParameterNotValidException(String.format("The visibility of the pipe (%s, %s) is not compatible with the visibility of the extractor (%s, %s, %s), processor (%s, %s, %s), and connector (%s, %s, %s).", pipeName, pipeVisibility, extractorAttributes, temporaryExtractor.getClass().getName(), extractorVisibility, processorAttributes, temporaryProcessor.getClass().getName(), processorVisibility, connectorAttributes, temporaryConnector.getClass().getName(), connectorVisibility));
        }
    }
}

