/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.schema.filter.impl.values;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.apache.iotdb.commons.schema.filter.SchemaFilter;
import org.apache.iotdb.commons.schema.filter.SchemaFilterType;
import org.apache.iotdb.commons.schema.filter.SchemaFilterVisitor;
import org.apache.tsfile.utils.ReadWriteIOUtils;

public class InFilter
extends SchemaFilter {
    private final Set<String> values;

    public InFilter(Set<String> values) {
        this.values = values;
    }

    public InFilter(ByteBuffer byteBuffer) {
        int length = ReadWriteIOUtils.readInt((ByteBuffer)byteBuffer);
        this.values = new HashSet<String>();
        for (int i = 0; i < length; ++i) {
            this.values.add(ReadWriteIOUtils.readString((ByteBuffer)byteBuffer));
        }
    }

    public Set<String> getValues() {
        return this.values;
    }

    @Override
    public <C> Boolean accept(SchemaFilterVisitor<C> visitor, C node) {
        return visitor.visitInFilter(this, node);
    }

    @Override
    public SchemaFilterType getSchemaFilterType() {
        return SchemaFilterType.IN;
    }

    @Override
    protected void serialize(ByteBuffer byteBuffer) {
        ReadWriteIOUtils.write((int)this.values.size(), (ByteBuffer)byteBuffer);
        for (String value : this.values) {
            ReadWriteIOUtils.write((String)value, (ByteBuffer)byteBuffer);
        }
    }

    @Override
    protected void serialize(DataOutputStream stream) throws IOException {
        ReadWriteIOUtils.write((int)this.values.size(), (OutputStream)stream);
        for (String value : this.values) {
            ReadWriteIOUtils.write((String)value, (OutputStream)stream);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InFilter that = (InFilter)o;
        return Objects.equals(this.values, that.values);
    }

    public int hashCode() {
        return Objects.hash(this.values);
    }
}

