/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seata.discovery.registry.eureka;

import com.netflix.appinfo.ApplicationInfoManager;
import com.netflix.appinfo.EurekaInstanceConfig;
import com.netflix.appinfo.InstanceInfo;
import com.netflix.appinfo.providers.EurekaConfigBasedInstanceInfoProvider;
import com.netflix.config.ConfigurationManager;
import com.netflix.discovery.DefaultEurekaClientConfig;
import com.netflix.discovery.DiscoveryClient;
import com.netflix.discovery.EurekaClient;
import com.netflix.discovery.EurekaClientConfig;
import com.netflix.discovery.EurekaEventListener;
import com.netflix.discovery.shared.Application;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;
import org.apache.seata.common.exception.EurekaRegistryException;
import org.apache.seata.common.lock.ResourceLock;
import org.apache.seata.common.util.CollectionUtils;
import org.apache.seata.common.util.NetUtil;
import org.apache.seata.common.util.StringUtils;
import org.apache.seata.config.Configuration;
import org.apache.seata.config.ConfigurationFactory;
import org.apache.seata.config.exception.ConfigNotFoundException;
import org.apache.seata.discovery.registry.RegistryService;
import org.apache.seata.discovery.registry.eureka.CustomEurekaInstanceConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EurekaRegistryServiceImpl
implements RegistryService<EurekaEventListener> {
    private static final Logger LOGGER = LoggerFactory.getLogger(EurekaRegistryServiceImpl.class);
    private static final String DEFAULT_APPLICATION = "default";
    private static final String PRO_SERVICE_URL_KEY = "serviceUrl";
    private static final String FILE_ROOT_REGISTRY = "registry";
    private static final String FILE_CONFIG_SPLIT_CHAR = ".";
    private static final String REGISTRY_TYPE = "eureka";
    private static final String CLUSTER = "application";
    private static final String REGISTRY_WEIGHT = "weight";
    private static final String EUREKA_CONFIG_SERVER_URL_KEY = "eureka.serviceUrl.default";
    private static final String EUREKA_CONFIG_REFRESH_KEY = "eureka.client.refresh.interval";
    private static final String EUREKA_CONFIG_SHOULD_REGISTER = "eureka.registration.enabled";
    private static final String EUREKA_CONFIG_METADATA_WEIGHT = "eureka.metadata.weight";
    private static final int EUREKA_REFRESH_INTERVAL = 5;
    private static final int MAP_INITIAL_CAPACITY = 8;
    private static final String DEFAULT_WEIGHT = "1";
    private static final Configuration FILE_CONFIG = ConfigurationFactory.CURRENT_FILE_INSTANCE;
    private static final ConcurrentMap<String, List<EurekaEventListener>> LISTENER_SERVICE_MAP = new ConcurrentHashMap<String, List<EurekaEventListener>>();
    private static final ConcurrentMap<String, List<InetSocketAddress>> CLUSTER_ADDRESS_MAP = new ConcurrentHashMap<String, List<InetSocketAddress>>();
    private static final ConcurrentMap<String, ResourceLock> CLUSTER_LOCK = new ConcurrentHashMap<String, ResourceLock>();
    private static volatile ApplicationInfoManager applicationInfoManager;
    private static volatile CustomEurekaInstanceConfig instanceConfig;
    private static volatile EurekaRegistryServiceImpl instance;
    private static volatile EurekaClient eurekaClient;
    private String transactionServiceGroup;

    private EurekaRegistryServiceImpl() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static EurekaRegistryServiceImpl getInstance() {
        if (instance != null) return instance;
        Class<EurekaRegistryServiceImpl> clazz = EurekaRegistryServiceImpl.class;
        synchronized (EurekaRegistryServiceImpl.class) {
            if (instance != null) return instance;
            instanceConfig = new CustomEurekaInstanceConfig();
            instance = new EurekaRegistryServiceImpl();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public void register(InetSocketAddress address) throws Exception {
        NetUtil.validAddress((InetSocketAddress)address);
        instanceConfig.setIpAddress(address.getAddress().getHostAddress());
        instanceConfig.setPort(address.getPort());
        instanceConfig.setApplicationName(this.getApplicationName());
        instanceConfig.setInstanceId(this.getInstanceId());
        this.getEurekaClient(true);
        applicationInfoManager.setInstanceStatus(InstanceInfo.InstanceStatus.UP);
    }

    public void unregister(InetSocketAddress address) throws Exception {
        if (eurekaClient == null) {
            return;
        }
        applicationInfoManager.setInstanceStatus(InstanceInfo.InstanceStatus.DOWN);
    }

    public void subscribe(String cluster, EurekaEventListener listener) throws Exception {
        LISTENER_SERVICE_MAP.computeIfAbsent(cluster, key -> new ArrayList()).add(listener);
        this.getEurekaClient(false).registerEventListener(listener);
    }

    public void unsubscribe(String cluster, EurekaEventListener listener) throws Exception {
        List subscribeList = (List)LISTENER_SERVICE_MAP.get(cluster);
        if (subscribeList != null) {
            List newSubscribeList = subscribeList.stream().filter(eventListener -> !eventListener.equals(listener)).collect(Collectors.toList());
            LISTENER_SERVICE_MAP.put(cluster, newSubscribeList);
        }
        this.getEurekaClient(false).unregisterEventListener(listener);
    }

    public List<InetSocketAddress> lookup(String key) throws Exception {
        this.transactionServiceGroup = key;
        String clusterName = this.getServiceGroup(key);
        if (clusterName == null) {
            String missingDataId = "service.vgroupMapping." + key;
            throw new ConfigNotFoundException("%s configuration item is required", new String[]{missingDataId});
        }
        String clusterUpperName = clusterName.toUpperCase();
        if (!LISTENER_SERVICE_MAP.containsKey(clusterUpperName)) {
            ResourceLock lock = CLUSTER_LOCK.computeIfAbsent(clusterUpperName, k -> new ResourceLock());
            try (ResourceLock ignored = lock.obtain();){
                if (!LISTENER_SERVICE_MAP.containsKey(clusterUpperName)) {
                    this.refreshCluster(clusterUpperName);
                    this.subscribe(clusterUpperName, event -> this.refreshCluster(clusterUpperName));
                }
            }
        }
        return (List)CLUSTER_ADDRESS_MAP.get(clusterUpperName);
    }

    public void close() throws Exception {
        if (eurekaClient != null) {
            eurekaClient.shutdown();
        }
        this.clean();
    }

    private void refreshCluster(String clusterName) {
        Application application = this.getEurekaClient(false).getApplication(clusterName);
        if (application == null || CollectionUtils.isEmpty((Collection)application.getInstances())) {
            LOGGER.info("refresh cluster success,but cluster empty! cluster name:{}", (Object)clusterName);
        } else {
            List newAddressList = application.getInstances().stream().filter(instance -> InstanceInfo.InstanceStatus.UP.equals((Object)instance.getStatus()) && instance.getIPAddr() != null && instance.getPort() > 0 && instance.getPort() < 65535).map(instance -> new InetSocketAddress(instance.getIPAddr(), instance.getPort())).collect(Collectors.toList());
            CLUSTER_ADDRESS_MAP.put(clusterName, newAddressList);
            this.removeOfflineAddressesIfNecessary(this.transactionServiceGroup, clusterName, newAddressList);
        }
    }

    private Properties getEurekaProperties(boolean needRegister) {
        Properties eurekaProperties = new Properties();
        eurekaProperties.setProperty(EUREKA_CONFIG_REFRESH_KEY, String.valueOf(5));
        String url = FILE_CONFIG.getConfig(this.getEurekaServerUrlFileKey());
        if (StringUtils.isBlank((String)url)) {
            throw new EurekaRegistryException("eureka server url can not be null!");
        }
        eurekaProperties.setProperty(EUREKA_CONFIG_SERVER_URL_KEY, url);
        String weight = FILE_CONFIG.getConfig(this.getEurekaInstanceWeightFileKey());
        if (StringUtils.isNotBlank((String)weight)) {
            eurekaProperties.setProperty(EUREKA_CONFIG_METADATA_WEIGHT, weight);
        } else {
            eurekaProperties.setProperty(EUREKA_CONFIG_METADATA_WEIGHT, DEFAULT_WEIGHT);
        }
        if (!needRegister) {
            eurekaProperties.setProperty(EUREKA_CONFIG_SHOULD_REGISTER, "false");
        }
        return eurekaProperties;
    }

    private String getApplicationName() {
        String application = FILE_CONFIG.getConfig(this.getEurekaApplicationFileKey());
        if (application == null) {
            application = DEFAULT_APPLICATION;
        }
        return application;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private EurekaClient getEurekaClient(boolean needRegister) throws EurekaRegistryException {
        if (eurekaClient != null) return eurekaClient;
        Class<EurekaRegistryServiceImpl> clazz = EurekaRegistryServiceImpl.class;
        synchronized (EurekaRegistryServiceImpl.class) {
            try {
                if (eurekaClient != null) return eurekaClient;
                if (!needRegister) {
                    instanceConfig = new CustomEurekaInstanceConfig();
                }
                ConfigurationManager.loadProperties((Properties)this.getEurekaProperties(needRegister));
                InstanceInfo instanceInfo = new EurekaConfigBasedInstanceInfoProvider((EurekaInstanceConfig)instanceConfig).get();
                applicationInfoManager = new ApplicationInfoManager((EurekaInstanceConfig)instanceConfig, instanceInfo);
                eurekaClient = new DiscoveryClient(applicationInfoManager, (EurekaClientConfig)new DefaultEurekaClientConfig());
            }
            catch (Exception e) {
                this.clean();
                throw new EurekaRegistryException("register eureka is error!", (Throwable)e);
            }
            return eurekaClient;
        }
    }

    private void clean() {
        eurekaClient = null;
        applicationInfoManager = null;
        instanceConfig = null;
    }

    private String getInstanceId() {
        return String.format("%s:%s:%d", instanceConfig.getIpAddress(), instanceConfig.getAppname(), instanceConfig.getNonSecurePort());
    }

    private String getEurekaServerUrlFileKey() {
        return String.join((CharSequence)FILE_CONFIG_SPLIT_CHAR, FILE_ROOT_REGISTRY, REGISTRY_TYPE, PRO_SERVICE_URL_KEY);
    }

    private String getEurekaApplicationFileKey() {
        return String.join((CharSequence)FILE_CONFIG_SPLIT_CHAR, FILE_ROOT_REGISTRY, REGISTRY_TYPE, CLUSTER);
    }

    private String getEurekaInstanceWeightFileKey() {
        return String.join((CharSequence)FILE_CONFIG_SPLIT_CHAR, FILE_ROOT_REGISTRY, REGISTRY_TYPE, REGISTRY_WEIGHT);
    }
}

