/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seata.common.util;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import org.apache.seata.common.util.CollectionUtils;

public final class ReflectionUtil {
    public static final Field[] EMPTY_FIELD_ARRAY = new Field[0];
    public static final Class<?>[] EMPTY_CLASS_ARRAY = new Class[0];
    public static final Object[] EMPTY_ARGS = new Object[0];
    private static final Map<Class<?>, Field[]> CLASS_FIELDS_CACHE = new ConcurrentHashMap();
    private static final Map<Class<?>, Map<String, Field>> FIELD_CACHE = new ConcurrentHashMap();
    private static final Map<Class<?>, Map<String, Method>> METHOD_CACHE = new ConcurrentHashMap();

    private ReflectionUtil() {
    }

    public static Class<?> getClassByName(String className) throws ClassNotFoundException {
        return Class.forName(className, true, Thread.currentThread().getContextClassLoader());
    }

    public static boolean isClassPresent(String className) {
        try {
            Class.forName(className, false, Thread.currentThread().getContextClassLoader());
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public static Class<?> getWrappedClass(Class<?> clazz) {
        if (clazz.isPrimitive()) {
            if (clazz.equals(Byte.TYPE)) {
                return Byte.class;
            }
            if (clazz.equals(Boolean.TYPE)) {
                return Boolean.class;
            }
            if (clazz.equals(Character.TYPE)) {
                return Character.class;
            }
            if (clazz.equals(Short.TYPE)) {
                return Short.class;
            }
            if (clazz.equals(Integer.TYPE)) {
                return Integer.class;
            }
            if (clazz.equals(Long.TYPE)) {
                return Long.class;
            }
            if (clazz.equals(Float.TYPE)) {
                return Float.class;
            }
            if (clazz.equals(Double.TYPE)) {
                return Double.class;
            }
            if (clazz.equals(Void.TYPE)) {
                return Void.class;
            }
        }
        return clazz;
    }

    public static Set<Class<?>> getInterfaces(Class<?> clazz) {
        if (clazz.isInterface()) {
            return Collections.singleton(clazz);
        }
        LinkedHashSet interfaces = new LinkedHashSet();
        while (clazz != null) {
            Class<?>[] ifcs;
            for (Class<?> ifc : ifcs = clazz.getInterfaces()) {
                interfaces.addAll(ReflectionUtil.getInterfaces(ifc));
            }
            clazz = clazz.getSuperclass();
        }
        return interfaces;
    }

    public static Field[] getAllFields(Class<?> targetClazz) {
        if (targetClazz == Object.class || targetClazz.isInterface()) {
            return EMPTY_FIELD_ARRAY;
        }
        Field[] fields = CLASS_FIELDS_CACHE.get(targetClazz);
        if (fields != null) {
            return fields;
        }
        fields = targetClazz.getDeclaredFields();
        LinkedList<Field> fieldList = new LinkedList<Field>(Arrays.asList(fields));
        fieldList.removeIf(f -> Modifier.isStatic(f.getModifiers()) || f.isSynthetic());
        Object[] superFields = ReflectionUtil.getAllFields(targetClazz.getSuperclass());
        if (CollectionUtils.isNotEmpty(superFields)) {
            fieldList.addAll(Arrays.asList(superFields));
        }
        Field[] resultFields = !fieldList.isEmpty() ? fieldList.toArray(new Field[0]) : EMPTY_FIELD_ARRAY;
        CLASS_FIELDS_CACHE.put(targetClazz, resultFields);
        return resultFields;
    }

    public static Field getField(Class<?> clazz, String fieldName) throws NoSuchFieldException, SecurityException {
        Map fieldMap = CollectionUtils.computeIfAbsent(FIELD_CACHE, clazz, k -> new ConcurrentHashMap());
        Field field = CollectionUtils.computeIfAbsent(fieldMap, fieldName, k -> {
            for (Class cl = clazz; cl != null && cl != Object.class && !cl.isInterface(); cl = cl.getSuperclass()) {
                try {
                    return cl.getDeclaredField(fieldName);
                }
                catch (NoSuchFieldException e) {
                    continue;
                }
            }
            return null;
        });
        if (field == null) {
            throw new NoSuchFieldException("field not found: " + clazz.getName() + ", field: " + fieldName);
        }
        if (!field.isAccessible()) {
            field.setAccessible(true);
        }
        return field;
    }

    public static <T> T getFieldValue(Object target, Field field) throws IllegalArgumentException, SecurityException {
        if (target == null) {
            throw new IllegalArgumentException("target must be not null");
        }
        while (true) {
            if (!field.isAccessible()) {
                field.setAccessible(true);
            }
            try {
                return (T)field.get(target);
            }
            catch (IllegalAccessException illegalAccessException) {
                continue;
            }
            break;
        }
    }

    public static <T> T getFieldValue(Object target, String fieldName) throws IllegalArgumentException, NoSuchFieldException, SecurityException {
        if (target == null) {
            throw new IllegalArgumentException("target must be not null");
        }
        Field field = ReflectionUtil.getField(target.getClass(), fieldName);
        return ReflectionUtil.getFieldValue(target, field);
    }

    public static void setFieldValue(Object target, Field field, Object fieldValue) throws IllegalArgumentException, SecurityException {
        if (target == null) {
            throw new IllegalArgumentException("target must be not null");
        }
        while (true) {
            if (!field.isAccessible()) {
                field.setAccessible(true);
            }
            try {
                field.set(target, fieldValue);
                return;
            }
            catch (IllegalAccessException illegalAccessException) {
                continue;
            }
            break;
        }
    }

    public static void setFieldValue(Object target, String fieldName, Object fieldValue) throws IllegalArgumentException, NoSuchFieldException, SecurityException {
        if (target == null) {
            throw new IllegalArgumentException("target must be not null");
        }
        Field field = ReflectionUtil.getField(target.getClass(), fieldName);
        ReflectionUtil.setFieldValue(target, field, fieldValue);
    }

    public static void modifyStaticFinalField(Field staticField, Object newValue) throws NoSuchFieldException, IllegalAccessException {
        if (staticField == null) {
            throw new IllegalArgumentException("staticField must be not null");
        }
        if (!Modifier.isStatic(staticField.getModifiers())) {
            throw new IllegalArgumentException("the `" + ReflectionUtil.fieldToString(staticField) + "` is not a static field, cannot modify value.");
        }
        if (Modifier.isFinal(staticField.getModifiers())) {
            Field modifiers = staticField.getClass().getDeclaredField("modifiers");
            modifiers.setAccessible(true);
            modifiers.setInt(staticField, staticField.getModifiers() & 0xFFFFFFEF);
        }
        staticField.setAccessible(true);
        staticField.set(staticField.getDeclaringClass(), newValue);
    }

    public static void modifyStaticFinalField(Class<?> targetClass, String staticFieldName, Object newValue) throws NoSuchFieldException, IllegalAccessException {
        if (targetClass == null) {
            throw new IllegalArgumentException("targetClass must be not null");
        }
        Field field = targetClass.getDeclaredField(staticFieldName);
        ReflectionUtil.modifyStaticFinalField(field, newValue);
    }

    public static Method getMethod(Class<?> clazz, String methodName, Class<?> ... parameterTypes) throws NoSuchMethodException, SecurityException {
        String cacheKey;
        if (clazz == null) {
            throw new IllegalArgumentException("clazz must be not null");
        }
        Map methodMap = CollectionUtils.computeIfAbsent(METHOD_CACHE, clazz, k -> new ConcurrentHashMap());
        Method method = CollectionUtils.computeIfAbsent(methodMap, cacheKey = ReflectionUtil.generateMethodCacheKey(methodName, parameterTypes), k -> {
            for (Class cl = clazz; cl != null; cl = cl.getSuperclass()) {
                try {
                    return cl.getDeclaredMethod(methodName, parameterTypes);
                }
                catch (NoSuchMethodException e) {
                    continue;
                }
            }
            return null;
        });
        if (method == null) {
            throw new NoSuchMethodException("method not found: " + ReflectionUtil.methodToString(clazz, methodName, parameterTypes));
        }
        if (!method.isAccessible()) {
            method.setAccessible(true);
        }
        return method;
    }

    private static String generateMethodCacheKey(String methodName, Class<?>[] parameterTypes) {
        StringBuilder key = new StringBuilder(methodName);
        if (parameterTypes != null && parameterTypes.length > 0) {
            key.append("|");
            for (Class<?> parameterType : parameterTypes) {
                key.append(parameterType.getName()).append(",");
            }
        }
        return key.toString();
    }

    public static Method getMethod(Class<?> clazz, String methodName) throws NoSuchMethodException, SecurityException {
        return ReflectionUtil.getMethod(clazz, methodName, EMPTY_CLASS_ARRAY);
    }

    public static Map<Method, Class<?>> findMatchMethodClazzMap(Class<?> clazz, Predicate<Method> matchCondition) {
        HashMap methodClassMap = new HashMap();
        for (Method method : clazz.getMethods()) {
            if (!matchCondition.test(method)) continue;
            methodClassMap.put(method, clazz);
        }
        Set<Class<?>> interfaceClasses = ReflectionUtil.getInterfaces(clazz);
        for (Class<?> interClass : interfaceClasses) {
            for (Method method : interClass.getMethods()) {
                if (!matchCondition.test(method)) continue;
                methodClassMap.put(method, interClass);
            }
        }
        return methodClassMap;
    }

    public static Object invokeMethod(Object target, Method method, Object ... args) throws InvocationTargetException, IllegalArgumentException, SecurityException {
        while (true) {
            if (!method.isAccessible()) {
                method.setAccessible(true);
            }
            try {
                return method.invoke(target, args);
            }
            catch (IllegalAccessException illegalAccessException) {
                continue;
            }
            break;
        }
    }

    public static Object invokeMethod(Object target, Method method) throws InvocationTargetException, IllegalArgumentException, SecurityException {
        return ReflectionUtil.invokeMethod(target, method, EMPTY_ARGS);
    }

    public static Object invokeMethod(Object target, String methodName, Class<?>[] parameterTypes, Object ... args) throws NoSuchMethodException, InvocationTargetException, IllegalArgumentException, SecurityException {
        if (target == null) {
            throw new IllegalArgumentException("target must be not null");
        }
        Method method = ReflectionUtil.getMethod(target.getClass(), methodName, parameterTypes);
        return ReflectionUtil.invokeMethod(target, method, args);
    }

    public static Object invokeMethod(Object target, String methodName) throws NoSuchMethodException, InvocationTargetException, IllegalArgumentException, SecurityException {
        return ReflectionUtil.invokeMethod(target, methodName, EMPTY_CLASS_ARRAY, EMPTY_ARGS);
    }

    public static Object invokeStaticMethod(Method staticMethod, Object ... args) throws IllegalArgumentException, InvocationTargetException, SecurityException {
        if (staticMethod == null) {
            throw new IllegalArgumentException("staticMethod must be not null");
        }
        if (!Modifier.isStatic(staticMethod.getModifiers())) {
            throw new IllegalArgumentException("`" + ReflectionUtil.methodToString(staticMethod) + "` is not a static method");
        }
        return ReflectionUtil.invokeMethod(null, staticMethod, args);
    }

    public static Object invokeStaticMethod(Method staticMethod) throws InvocationTargetException, IllegalArgumentException, SecurityException {
        return ReflectionUtil.invokeStaticMethod(staticMethod, EMPTY_ARGS);
    }

    public static Object invokeStaticMethod(Class<?> targetClass, String staticMethodName, Class<?>[] parameterTypes, Object ... args) throws IllegalArgumentException, NoSuchMethodException, InvocationTargetException, SecurityException {
        if (targetClass == null) {
            throw new IllegalArgumentException("targetClass must be not null");
        }
        Method staticMethod = ReflectionUtil.getMethod(targetClass, staticMethodName, parameterTypes);
        if (!Modifier.isStatic(staticMethod.getModifiers())) {
            throw new NoSuchMethodException("static method not found: " + ReflectionUtil.methodToString(targetClass, staticMethodName, parameterTypes));
        }
        return ReflectionUtil.invokeStaticMethod(staticMethod, args);
    }

    public static Object invokeStaticMethod(Class<?> targetClass, String staticMethodName) throws IllegalArgumentException, NoSuchMethodException, SecurityException, InvocationTargetException {
        return ReflectionUtil.invokeStaticMethod(targetClass, staticMethodName, EMPTY_CLASS_ARRAY, EMPTY_ARGS);
    }

    public static Map<String, Object> getAnnotationValues(Annotation annotation) throws NoSuchFieldException {
        InvocationHandler h = Proxy.getInvocationHandler(annotation);
        return (Map)ReflectionUtil.getFieldValue((Object)h, "memberValues");
    }

    public static String classToString(Class<?> clazz) {
        return "Class<" + clazz.getSimpleName() + ">";
    }

    public static String fieldToString(Class<?> clazz, String fieldName, Class<?> fieldType) {
        return "Field<" + clazz.getSimpleName() + ".(" + fieldType.getSimpleName() + " " + fieldName + ")>";
    }

    public static String fieldToString(Field field) {
        return ReflectionUtil.fieldToString(field.getDeclaringClass(), field.getName(), field.getType());
    }

    public static String methodToString(Class<?> clazz, String methodName, Class<?> ... parameterTypes) {
        return "Method<" + clazz.getSimpleName() + "." + methodName + ReflectionUtil.parameterTypesToString(parameterTypes) + ">";
    }

    public static String methodToString(Method method) {
        String methodStr = method.getDeclaringClass().getSimpleName() + "." + method.getName() + ReflectionUtil.parameterTypesToString(method.getParameterTypes());
        if (Modifier.isStatic(method.getModifiers())) {
            methodStr = "static " + methodStr;
        }
        return "Method<" + methodStr + ">";
    }

    public static String annotationToString(Annotation annotation) {
        if (annotation == null) {
            return "null";
        }
        String annoStr = annotation.toString();
        String annoValueStr = annoStr.substring(annoStr.indexOf(40));
        return "@" + annotation.annotationType().getSimpleName() + annoValueStr;
    }

    public static String parameterTypesToString(Class<?>[] parameterTypes) {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        if (parameterTypes != null) {
            for (int i = 0; i < parameterTypes.length; ++i) {
                Class<?> c;
                if (i > 0) {
                    sb.append(", ");
                }
                sb.append((c = parameterTypes[i]) == null ? "null" : c.getSimpleName());
            }
        }
        sb.append(")");
        return sb.toString();
    }
}

