/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.jni;

import dm.jdbc.desc.DmSvcConf;
import dm.jdbc.driver.DBError;
import dm.jdbc.jni.MarkSocket;
import dm.jdbc.parser.LVal;
import dm.jdbc.parser.SQLProcessor;
import dm.jdbc.util.StringUtil;
import java.util.List;

public class MarkDll {
    public static final int SQL_TYPE_NULL = -2;
    public static final int SQL_TYPE_INVALID = -1;
    public static final int SQL_TYPE_CONNECT = 0;
    public static final int SQL_TYPE_SELECT = 1;
    public static final int SQL_TYPE_INSERT = 2;
    public static final int SQL_TYPE_UPDATE = 3;
    public static final int SQL_TYPE_DELETE = 4;
    public static final int SQL_TYPE_CREATE = 5;
    public static final int SQL_TYPE_ALTER = 6;
    public static final int SQL_TYPE_DROP = 7;
    public static final int SQL_TYPE_GRANT = 8;
    public static final int SQL_TYPE_REVOKE = 9;

    static {
        try {
            System.loadLibrary("dmutl");
            System.loadLibrary("dmelog");
            System.loadLibrary("dmos");
            System.loadLibrary("dmmem");
            System.loadLibrary("dmclientlex");
            System.loadLibrary("dmmark_client");
            if (StringUtil.isEmpty(DmSvcConf.GLOBAL.markConf) || MarkDll.initMarkEnv(DmSvcConf.GLOBAL.markConf) < 0) {
                DBError.throwRuntimeException(DBError.ECJDBC_INIT_SOCKET_MARK_FAILED.reason);
            }
        }
        catch (Throwable throwable) {
            DBError.throwRuntimeException(DBError.ECJDBC_INIT_SOCKET_MARK_FAILED.reason, throwable);
        }
    }

    public static final int getSqlType(String string) {
        if (StringUtil.isEmpty(string)) {
            return -2;
        }
        String string2 = "";
        try {
            List list = SQLProcessor.lexSkipWhitespace(string, 1);
            LVal lVal = (LVal)list.get(0);
            string2 = lVal.value.toUpperCase();
        }
        catch (Exception exception) {
            return -1;
        }
        if (StringUtil.equals(string2, "SELECT")) {
            return 1;
        }
        if (StringUtil.equals(string2, "INSERT")) {
            return 2;
        }
        if (StringUtil.equals(string2, "UPDATE")) {
            return 3;
        }
        if (StringUtil.equals(string2, "DELETE")) {
            return 4;
        }
        if (StringUtil.equals(string2, "CREATE")) {
            return 5;
        }
        if (StringUtil.equals(string2, "REVOKE")) {
            return 9;
        }
        if (StringUtil.equals(string2, "ALTER")) {
            return 6;
        }
        if (StringUtil.equals(string2, "GRANT")) {
            return 8;
        }
        if (StringUtil.equals(string2, "DROP")) {
            return 7;
        }
        return -1;
    }

    public static native int initMarkEnv(String var0);

    public static native int deinitMarkEnv();

    public static native int socket(MarkSocket var0, String var1, int var2);

    public static native int send(MarkSocket var0, byte[] var1, int var2);

    public static native int recv(MarkSocket var0, byte[] var1, int var2);

    public static native int close(MarkSocket var0);

    public static native int setSocketMark(MarkSocket var0, int var1, int var2, byte[] var3, int var4);

    public static native int checkMark(MarkSocket var0, byte[] var1, int var2);
}

