/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fury.memory;

import org.apache.fury.memory.Platform;

public class LittleEndian {
    public static int putVarUint36Small(byte[] arr, int index, long v) {
        if (v >>> 7 == 0L) {
            arr[index] = (byte)v;
            return 1;
        }
        if (v >>> 14 == 0L) {
            arr[index++] = (byte)(v & 0x7FL | 0x80L);
            arr[index] = (byte)(v >>> 7);
            return 2;
        }
        return LittleEndian.bigWriteUint36(arr, index, v);
    }

    private static int bigWriteUint36(byte[] arr, int index, long v) {
        if (v >>> 21 == 0L) {
            arr[index++] = (byte)(v & 0x7FL | 0x80L);
            arr[index++] = (byte)(v >>> 7 | 0x80L);
            arr[index] = (byte)(v >>> 14);
            return 3;
        }
        if (v >>> 28 == 0L) {
            arr[index++] = (byte)(v & 0x7FL | 0x80L);
            arr[index++] = (byte)(v >>> 7 | 0x80L);
            arr[index++] = (byte)(v >>> 14 | 0x80L);
            arr[index] = (byte)(v >>> 21);
            return 4;
        }
        arr[index++] = (byte)(v & 0x7FL | 0x80L);
        arr[index++] = (byte)(v >>> 7 | 0x80L);
        arr[index++] = (byte)(v >>> 14 | 0x80L);
        arr[index++] = (byte)(v >>> 21 | 0x80L);
        arr[index] = (byte)(v >>> 28);
        return 5;
    }

    public static void putInt32(Object o, long pos, int value) {
        if (!Platform.IS_LITTLE_ENDIAN) {
            value = Integer.reverseBytes(value);
        }
        Platform.putInt(o, pos, value);
    }

    public static int getInt32(Object o, long pos) {
        int i = Platform.getInt(o, pos);
        return Platform.IS_LITTLE_ENDIAN ? i : Integer.reverseBytes(i);
    }

    public static long getInt64(Object o, long pos) {
        long v = Platform.getLong(o, pos);
        return Platform.IS_LITTLE_ENDIAN ? v : Long.reverseBytes(v);
    }

    public static void putFloat32(Object o, long pos, float value) {
        int v = Float.floatToRawIntBits(value);
        if (!Platform.IS_LITTLE_ENDIAN) {
            v = Integer.reverseBytes(v);
        }
        Platform.putInt(o, pos, v);
    }

    public static void putFloat64(Object o, long pos, double value) {
        long v = Double.doubleToRawLongBits(value);
        if (!Platform.IS_LITTLE_ENDIAN) {
            v = Long.reverseBytes(v);
        }
        Platform.putLong(o, pos, v);
    }
}

