/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.avro;

import java.io.IOException;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.avro.io.DatumReader;
import org.apache.avro.io.Decoder;
import org.apache.iceberg.Schema;
import org.apache.iceberg.avro.AvroSchemaUtil;
import org.apache.iceberg.avro.SupportsRowPosition;
import org.apache.iceberg.mapping.MappingUtil;
import org.apache.iceberg.mapping.NameMapping;
import org.apache.iceberg.types.TypeUtil;

public class ProjectionDatumReader<D>
implements DatumReader<D>,
SupportsRowPosition {
    private final Function<org.apache.avro.Schema, DatumReader<?>> getReader;
    private final Schema expectedSchema;
    private final Map<String, String> renames;
    private NameMapping nameMapping;
    private org.apache.avro.Schema readSchema = null;
    private org.apache.avro.Schema fileSchema = null;
    private DatumReader<D> wrapped = null;

    public ProjectionDatumReader(Function<org.apache.avro.Schema, DatumReader<?>> getReader, Schema expectedSchema, Map<String, String> renames, NameMapping nameMapping) {
        this.getReader = getReader;
        this.expectedSchema = expectedSchema;
        this.renames = renames;
        this.nameMapping = nameMapping;
    }

    @Override
    public void setRowPositionSupplier(Supplier<Long> posSupplier) {
        if (this.wrapped instanceof SupportsRowPosition) {
            ((SupportsRowPosition)this.wrapped).setRowPositionSupplier(posSupplier);
        }
    }

    public void setSchema(org.apache.avro.Schema newFileSchema) {
        this.fileSchema = newFileSchema;
        if (this.nameMapping == null && !AvroSchemaUtil.hasIds(this.fileSchema)) {
            this.nameMapping = MappingUtil.create(this.expectedSchema);
        }
        Set projectedIds = TypeUtil.getProjectedIds((Schema)this.expectedSchema);
        org.apache.avro.Schema schemaWithIds = AvroSchemaUtil.applyNameMapping(newFileSchema, this.nameMapping);
        org.apache.avro.Schema prunedSchema = AvroSchemaUtil.pruneColumns(schemaWithIds, projectedIds);
        this.readSchema = AvroSchemaUtil.buildAvroProjection(prunedSchema, this.expectedSchema, this.renames);
        this.wrapped = this.newDatumReader();
    }

    public D read(D reuse, Decoder in) throws IOException {
        return (D)this.wrapped.read(reuse, in);
    }

    private DatumReader<D> newDatumReader() {
        DatumReader<?> reader = this.getReader.apply(this.readSchema);
        reader.setSchema(this.fileSchema);
        return reader;
    }
}

