/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.logmanager.handlers;

import java.security.AccessControlContext;
import java.security.AccessController;
import java.util.function.Supplier;
import java.util.logging.ErrorManager;
import java.util.logging.Handler;

class SecurityActions {
    SecurityActions() {
    }

    static ErrorManager getErrorManager(AccessControlContext acc, Handler handler) {
        Supplier<ErrorManager> supplier = () -> {
            if (System.getSecurityManager() == null) {
                return handler.getErrorManager();
            }
            return AccessController.doPrivileged(handler::getErrorManager, acc);
        };
        return new LazyErrorManager(supplier);
    }

    private static class LazyErrorManager
    extends ErrorManager {
        private final Supplier<ErrorManager> supplier;
        private volatile ErrorManager delegate;

        private LazyErrorManager(Supplier<ErrorManager> supplier) {
            this.supplier = supplier;
        }

        @Override
        public synchronized void error(String msg, Exception ex, int code) {
            this.getDelegate().error(msg, ex, code);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private ErrorManager getDelegate() {
            if (this.delegate == null) {
                LazyErrorManager lazyErrorManager = this;
                synchronized (lazyErrorManager) {
                    if (this.delegate == null) {
                        this.delegate = this.supplier.get();
                    }
                }
            }
            return this.delegate;
        }
    }
}

