/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozhera.monitor.service.helper;

import com.google.gson.Gson;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.apache.ozhera.monitor.service.model.redis.AppAlarmData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.StringRedisTemplate;

public class RedisHelper {
    private final Logger logger = LoggerFactory.getLogger(RedisHelper.class);
    private final String REDIS_PRE = "mimonitor_";
    private final String APP_ALARM_DATA_KEY = "mimonitor_alarm_data_v1_";
    private final int APP_ALARM_DATA_KEY_EXPIRE_SECONDS = 60;
    public static String redisSwitch = "on";
    @Autowired
    private StringRedisTemplate stringRedisTemplate;

    public boolean setAppAlarmData(String appName, AppAlarmData data) {
        StringBuilder strBKey = new StringBuilder();
        strBKey.append("mimonitor_alarm_data_v1_").append(appName);
        return this.set(strBKey.toString(), data, 60);
    }

    public AppAlarmData getAppAlarmData(String appName) {
        if (redisSwitch.equals("off")) {
            return null;
        }
        StringBuilder strBKey = new StringBuilder();
        strBKey.append("mimonitor_alarm_data_v1_").append(appName);
        return this.get(strBKey.toString(), AppAlarmData.class);
    }

    public boolean set(String key, Object data, int seconds) {
        try {
            this.stringRedisTemplate.opsForValue().set((Object)key, (Object)new Gson().toJson(data), (long)seconds, TimeUnit.SECONDS);
            return true;
        }
        catch (Exception e) {
            this.logger.error("RedisHelper.set\u5f02\u5e38 key={}, data={}", new Object[]{key, data, e});
            return false;
        }
    }

    public <T> T get(String key, Class<T> clazz) {
        try {
            String json = (String)this.stringRedisTemplate.opsForValue().get((Object)key);
            if (StringUtils.isEmpty((CharSequence)json)) {
                return null;
            }
            return (T)new Gson().fromJson(json, clazz);
        }
        catch (Exception e) {
            this.logger.error("RedisHelper.get\u5f02\u5e38 key={}", (Object)key, (Object)e);
            return null;
        }
    }
}

