/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozhera.app.dao;

import com.google.gson.Gson;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.ozhera.app.dao.mapper.HeraProjectGroupAppMapper;
import org.apache.ozhera.app.model.HeraProjectGroupApp;
import org.apache.ozhera.app.model.HeraProjectGroupAppExample;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Repository;
import org.springframework.util.CollectionUtils;

@Repository
public class HeraProjectGroupAppDao {
    private static final Logger log = LoggerFactory.getLogger(HeraProjectGroupAppDao.class);
    @Resource
    private HeraProjectGroupAppMapper projectGroupAppMapper;

    public List<Integer> getAppBaseInfoIds(List<Integer> projectGroupIds) {
        HeraProjectGroupAppExample example = new HeraProjectGroupAppExample();
        HeraProjectGroupAppExample.Criteria ca = example.createCriteria();
        ca.andStatusEqualTo(0);
        ca.andProjectGroupIdIn((List)projectGroupIds);
        List<HeraProjectGroupApp> heraProjectGroupApps = this.projectGroupAppMapper.selectByExample(example);
        if (CollectionUtils.isEmpty(heraProjectGroupApps)) {
            return null;
        }
        return heraProjectGroupApps.stream().map(t -> t.getAppBaseInfoId()).collect(Collectors.toList());
    }

    public List<HeraProjectGroupApp> listByProjectGroupId(Integer projectGroupId) {
        HeraProjectGroupAppExample example = new HeraProjectGroupAppExample();
        HeraProjectGroupAppExample.Criteria ca = example.createCriteria();
        ca.andStatusEqualTo(0);
        ca.andProjectGroupIdEqualTo(projectGroupId);
        return this.projectGroupAppMapper.selectByExample(example);
    }

    public Integer batchInsert(List<HeraProjectGroupApp> apps) {
        try {
            return this.projectGroupAppMapper.batchInsert(apps);
        }
        catch (Exception e) {
            String appsInfo = new Gson().toJson(apps);
            log.error("App batchInsert exception! exception:" + e.getMessage() + ",appsInfo:" + appsInfo, (Throwable)e);
            return 0;
        }
    }

    public Integer delById(Integer id) {
        if (id == null) {
            log.error("delById param is invalid!id : {}", (Object)id);
        }
        try {
            return this.projectGroupAppMapper.deleteByPrimaryKey(id);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public Integer delByGroupId(Integer groupId) {
        HeraProjectGroupAppExample example = new HeraProjectGroupAppExample();
        HeraProjectGroupAppExample.Criteria ca = example.createCriteria();
        ca.andProjectGroupIdEqualTo(groupId);
        try {
            return this.projectGroupAppMapper.deleteByExample(example);
        }
        catch (Exception e) {
            log.error("delByGroupId error!exception : {}", (Object)e.getMessage(), (Object)e);
            return 0;
        }
    }
}

