/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozhera.operator.controller;

import com.google.common.base.Preconditions;
import com.google.gson.Gson;
import com.xiaomi.youpin.docean.anno.Controller;
import com.xiaomi.youpin.docean.anno.RequestMapping;
import com.xiaomi.youpin.docean.anno.RequestParam;
import com.xiaomi.youpin.infra.rpc.Result;
import com.xiaomi.youpin.infra.rpc.errors.ErrorCode;
import com.xiaomi.youpin.infra.rpc.errors.ExceptionHelper;
import com.xiaomi.youpin.infra.rpc.errors.GeneralCodes;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.Semaphore;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.ozhera.operator.bo.HeraBootstrap;
import org.apache.ozhera.operator.bo.HeraResource;
import org.apache.ozhera.operator.bo.HeraStatus;
import org.apache.ozhera.operator.common.ResourceTypeEnum;
import org.apache.ozhera.operator.dto.DeployStateDTO;
import org.apache.ozhera.operator.dto.HeraOperatorDefineDTO;
import org.apache.ozhera.operator.dto.OperatorStateDTO;
import org.apache.ozhera.operator.dto.ServiceCheckResource;
import org.apache.ozhera.operator.service.HeraBootstrapInitService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Controller
public class OzHeraOperatorController {
    private static final Logger log = LoggerFactory.getLogger(OzHeraOperatorController.class);
    private Gson gson = new Gson();
    private Semaphore semaphore = new Semaphore(1);
    @Resource
    private HeraBootstrapInitService heraBootstrapInitService;

    @RequestMapping(path="/hera/operator/resource/get", method="get", timeout=5000L)
    public Result<HeraOperatorDefineDTO> getResource() {
        log.info("/hera/operator/resource/get call in");
        HeraOperatorDefineDTO heraOperatorDefineDTO = this.heraBootstrapInitService.getResource();
        heraOperatorDefineDTO.setCrExists(Boolean.valueOf(this.heraBootstrapInitService.crExists(heraOperatorDefineDTO.getHeraMeta().getNamespace())));
        return Result.success((Object)heraOperatorDefineDTO);
    }

    @RequestMapping(path="/hera/operator/service/createAndCheck", method="get", timeout=5000L)
    public Result<ServiceCheckResource> createAndCheckHeraService(@RequestParam(value="namespace") String namespace) {
        try {
            log.info("/hera/operator/service/createAndCheck call in");
            Preconditions.checkArgument((null != namespace ? 1 : 0) != 0);
            ServiceCheckResource serviceCheckResource = new ServiceCheckResource();
            serviceCheckResource.setStatus(Integer.valueOf(1));
            HashMap<String, String> serviceMap = new HashMap<String, String>();
            serviceMap.put("hera-nginx", "hera.homepage.url");
            serviceMap.put("tpclogin-nginx", "tpc.login.fe.url");
            serviceMap.put("tpc-nginx", "hera.tpc.url");
            serviceMap.put("grafana", "hera.grafana.url");
            serviceMap.put("alertmanager", "hera.alertmanager.url");
            serviceMap.put("prometheus", "hera.prometheus.url");
            ArrayList serviceNameList = new ArrayList(serviceMap.keySet());
            String serviceType = "LoadBalancer";
            String serviceYamlPath = "/ozhera_init/outer/ozhera_lb.yml";
            List serviceList = this.heraBootstrapInitService.createAndListService(serviceNameList, namespace, serviceYamlPath, serviceType);
            if (this.heraBootstrapInitService.checkLbServiceFailed(serviceList, serviceType)) {
                if (CollectionUtils.isNotEmpty((Collection)serviceList)) {
                    log.warn("LoadBalancer type failed, change to NodePort type");
                    this.heraBootstrapInitService.deleteService(serviceNameList, namespace, serviceType);
                }
                serviceType = "NodePort";
                serviceYamlPath = "/ozhera_init/outer/ozhera_nodeport.yml";
                serviceList = this.heraBootstrapInitService.createAndListService(serviceNameList, namespace, serviceYamlPath, serviceType);
            } else {
                String currentType = this.heraBootstrapInitService.getServiceType(serviceList);
                if ("NodePort".equals(currentType)) {
                    log.warn("NodePort type finish");
                    serviceType = "NodePort";
                }
            }
            Map ipPortMap = this.heraBootstrapInitService.getServiceIpPort(serviceList, serviceType);
            serviceCheckResource.setServiceType(serviceType);
            if (ipPortMap.size() == serviceNameList.size()) {
                serviceCheckResource.setStatus(Integer.valueOf(0));
                HeraResource heraResource = HeraResource.builder().needCreate(Boolean.valueOf(false)).required(Boolean.valueOf(true)).resourceType(ResourceTypeEnum.SERVICE_CHECK.getTypeName()).resourceName("k8s-serviceType").remark("k8sService\u2018s Way to obtain").build();
                ArrayList<Map<String, String>> connectionMapList = new ArrayList<Map<String, String>>();
                for (Map.Entry entry : ipPortMap.entrySet()) {
                    connectionMapList.add(this.kvMap((String)serviceMap.get(entry.getKey()), (String)entry.getValue(), "External access address"));
                }
                heraResource.setConnectionMapList(connectionMapList);
                serviceCheckResource.setHeraResource(heraResource);
            }
            return Result.success((Object)serviceCheckResource);
        }
        catch (Throwable e) {
            log.error("createAndCheckHeraService error", e);
            return Result.fromException((Throwable)e);
        }
    }

    private Map<String, String> kvMap(String key, String value, String remark) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("key", key);
        map.put("value", value);
        map.put("remark", remark);
        return map;
    }

    @RequestMapping(path="/hera/operator/resource/update", method="post", timeout=5000L)
    public Result<HeraOperatorDefineDTO> updateResource(HeraOperatorDefineDTO heraOperatorDefine) {
        try {
            HeraOperatorDefineDTO newDefineDTo = this.heraBootstrapInitService.updateResource(heraOperatorDefine);
            return Result.success((Object)newDefineDTo);
        }
        catch (Throwable e) {
            log.error("updateResource error", e);
            return Result.fromException((Throwable)e);
        }
    }

    @RequestMapping(path="/hera/operator/cr/createOrReplace", timeout=5000L)
    public Result<HeraStatus> createCustomResource() {
        if (this.semaphore.tryAcquire()) {
            try {
                HeraStatus status = this.heraBootstrapInitService.createOrReplaceCr();
                log.warn("hera operator result:{}", (Object)this.gson.toJson((Object)status));
                Result result = Result.success((Object)status);
                return result;
            }
            catch (Throwable e) {
                log.error("createCustomResource failed:", e);
                Result result = Result.success((Object)new HeraStatus());
                return result;
            }
            finally {
                this.semaphore.release();
            }
        }
        return Result.fromException((Throwable)new RuntimeException("only support one serial request\uff0cplease wait and try again"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(path="/hera/operator/cr/delete", timeout=5000L)
    public Result<Boolean> deleteCustomResource() {
        HeraBootstrap heraBootstrap = new HeraBootstrap();
        HeraStatus heraStatus = new HeraStatus();
        ObjectMeta objectMeta = new ObjectMeta();
        if (this.semaphore.tryAcquire()) {
            try {
                Boolean result = this.heraBootstrapInitService.deleteCr();
                log.warn("hera operator delete result:{}", (Object)result);
                Result result2 = Result.success((Object)result);
                return result2;
            }
            catch (Throwable e) {
                log.error("createCustomResource failed:", e);
                Result result = Result.success((Object)false);
                return result;
            }
            finally {
                this.semaphore.release();
            }
        }
        return Result.fromException((Throwable)new RuntimeException("only support one serial request\uff0cplease wait and try again"));
    }

    @RequestMapping(path="/hera/operator/cr/state", timeout=5000L)
    public Result<OperatorStateDTO> customResourceState() {
        try {
            OperatorStateDTO operatorState = new OperatorStateDTO();
            List deployStateDTOList = this.heraBootstrapInitService.crState();
            operatorState.setDeployStateList(deployStateDTOList);
            log.warn("hera operator status:{}", (Object)this.gson.toJson((Object)deployStateDTOList));
            Optional<DeployStateDTO> optional = deployStateDTOList.stream().filter(d -> d.getReady() == false).findAny();
            if (optional.isPresent() || deployStateDTOList.size() < 19) {
                operatorState.setStatus(Integer.valueOf(1));
            } else {
                operatorState.setStatus(Integer.valueOf(0));
            }
            return Result.success((Object)operatorState);
        }
        catch (Throwable e) {
            log.error("customResourceState failed:", e);
            return Result.fromException((Throwable)ExceptionHelper.create((ErrorCode)GeneralCodes.InternalError, (String)e.getMessage()));
        }
    }
}

