/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozhera.log.manager.service.extension.store;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xiaomi.youpin.docean.anno.Service;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.apache.ozhera.log.api.enums.LogStorageTypeEnum;
import org.apache.ozhera.log.api.enums.OperateEnum;
import org.apache.ozhera.log.api.model.vo.ResourceUserSimple;
import org.apache.ozhera.log.common.Constant;
import org.apache.ozhera.log.manager.dao.MilogLogstoreDao;
import org.apache.ozhera.log.manager.domain.EsIndexTemplate;
import org.apache.ozhera.log.manager.mapper.MilogEsClusterMapper;
import org.apache.ozhera.log.manager.model.dto.EsInfoDTO;
import org.apache.ozhera.log.manager.model.dto.LogStorageData;
import org.apache.ozhera.log.manager.model.pojo.MilogEsClusterDO;
import org.apache.ozhera.log.manager.model.pojo.MilogLogStoreDO;
import org.apache.ozhera.log.manager.model.pojo.MilogMiddlewareConfig;
import org.apache.ozhera.log.manager.model.vo.LogStoreParam;
import org.apache.ozhera.log.manager.service.extension.store.DorisLogStorageService;
import org.apache.ozhera.log.manager.service.extension.store.StoreExtensionService;
import org.apache.ozhera.log.manager.service.impl.MilogMiddlewareConfigServiceImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Service(name="defaultStoreExtensionService")
public class DefaultStoreExtensionService
implements StoreExtensionService {
    private static final Logger log = LoggerFactory.getLogger(DefaultStoreExtensionService.class);
    @Resource
    private MilogMiddlewareConfigServiceImpl resourceConfigService;
    @Resource
    private MilogMiddlewareConfigServiceImpl milogMiddlewareConfigService;
    @Resource
    private MilogEsClusterMapper milogEsClusterMapper;
    @Resource
    private EsIndexTemplate esIndexTemplate;
    @Resource
    private MilogLogstoreDao logStoreDao;
    @Resource
    private DorisLogStorageService dorisLogStorageService;

    @Override
    public boolean storeInfoCheck(LogStoreParam param) {
        return false;
    }

    @Override
    public void storeResourceBinding(MilogLogStoreDO storeDO, LogStoreParam storeParam, OperateEnum operateEnum) {
        if (StringUtils.isNotEmpty((CharSequence)storeDO.getEsIndex()) && null != storeDO.getMqResourceId() && null != storeDO.getEsClusterId()) {
            this.customResources(storeDO, storeParam);
            return;
        }
        this.bindMqResource(storeDO, storeParam);
        this.bindStorageResource(storeDO, storeParam);
    }

    private void bindStorageResource(MilogLogStoreDO storeDO, LogStoreParam storeParam) {
        ResourceUserSimple resourceUserConfig = this.resourceConfigService.userResourceList(storeParam.getMachineRoom(), storeParam.getLogType());
        if (resourceUserConfig.getInitializedFlag().booleanValue()) {
            storeParam.setEsResourceId(storeParam.getEsResourceId() != null ? storeParam.getEsResourceId() : this.getDefaultEsClusterId());
            MilogEsClusterDO esClusterDO = (MilogEsClusterDO)this.milogEsClusterMapper.selectById(storeParam.getEsResourceId());
            LogStorageTypeEnum storageTypeEnum = LogStorageTypeEnum.queryByName((String)esClusterDO.getLogStorageType());
            if (storageTypeEnum == LogStorageTypeEnum.DORIS) {
                return;
            }
            EsInfoDTO esInfo = this.esIndexTemplate.getEsInfo(storeParam.getEsResourceId(), storeParam.getLogType(), null);
            storeParam.setEsIndex((String)StringUtils.defaultIfBlank((CharSequence)storeParam.getEsIndex(), (CharSequence)esInfo.getIndex()));
            storeDO.setEsClusterId(esInfo.getClusterId());
            storeDO.setEsIndex(storeParam.getEsIndex());
        }
    }

    private Long getDefaultEsClusterId() {
        LambdaQueryWrapper lambdaQueryWrapper = Wrappers.lambdaQuery();
        lambdaQueryWrapper.eq(MilogEsClusterDO::getIsDefault, (Object)Constant.YES);
        return this.milogEsClusterMapper.selectList((Wrapper)lambdaQueryWrapper).stream().map(MilogEsClusterDO::getId).reduce((first, second) -> second).orElse(null);
    }

    private void bindMqResource(MilogLogStoreDO storeDO, LogStoreParam storeParam) {
        ResourceUserSimple resourceUserConfig = this.resourceConfigService.userResourceList(storeParam.getMachineRoom(), storeParam.getLogType());
        if (resourceUserConfig.getInitializedFlag().booleanValue() && null == storeParam.getMqResourceId()) {
            MilogMiddlewareConfig milogMiddlewareConfig = this.milogMiddlewareConfigService.queryMiddlewareConfigDefault(storeParam.getMachineRoom());
            storeDO.setMqResourceId(milogMiddlewareConfig.getId());
            storeParam.setMqResourceId(milogMiddlewareConfig.getId());
        }
    }

    private void customResources(MilogLogStoreDO ml, LogStoreParam command) {
        if (null != command.getMqResourceId()) {
            ml.setMqResourceId(command.getMqResourceId());
        }
        if (null != command.getEsResourceId()) {
            ml.setEsClusterId(command.getEsResourceId());
        }
        if (StringUtils.isNotBlank((CharSequence)command.getEsIndex())) {
            ml.setEsIndex(command.getEsIndex());
        }
    }

    @Override
    public void postProcessing(MilogLogStoreDO storeDO, LogStoreParam cmd, OperateEnum operateEnum) {
        if (this.isDorisStorage(storeDO)) {
            this.processDorisStorage(storeDO, cmd, operateEnum);
        }
    }

    private boolean isDorisStorage(MilogLogStoreDO storeDO) {
        MilogEsClusterDO esClusterDO = (MilogEsClusterDO)this.milogEsClusterMapper.selectById(storeDO.getEsClusterId());
        LogStorageTypeEnum storageTypeEnum = LogStorageTypeEnum.queryByName((String)esClusterDO.getLogStorageType());
        return storageTypeEnum == LogStorageTypeEnum.DORIS;
    }

    private void processDorisStorage(MilogLogStoreDO ml, LogStoreParam cmd, OperateEnum operateEnum) {
        LogStorageData storageData = LogStorageData.builder().storeId(ml.getId()).build();
        switch (operateEnum) {
            case DELETE_OPERATE: {
                this.deleteDorisTable(ml, storageData);
                break;
            }
            case ADD_OPERATE: {
                this.addDorisTable(cmd, storageData);
                break;
            }
            case UPDATE_OPERATE: {
                this.updateDorisTable(ml, cmd, storageData);
                break;
            }
        }
        this.updateEsIndexIfNeeded(ml, storageData, operateEnum);
    }

    private void deleteDorisTable(MilogLogStoreDO ml, LogStorageData storageData) {
        storageData.setClusterId(ml.getEsClusterId());
        this.dorisLogStorageService.deleteTable(storageData);
    }

    private void addDorisTable(LogStoreParam cmd, LogStorageData storageData) {
        storageData.setLogType(cmd.getLogType());
        storageData.setClusterId(cmd.getEsResourceId());
        storageData.setLogStoreName(cmd.getLogstoreName());
        storageData.setKeys(cmd.getKeyList());
        storageData.setColumnTypes(cmd.getColumnTypeList());
        this.dorisLogStorageService.createTable(storageData);
    }

    private void updateDorisTable(MilogLogStoreDO ml, LogStoreParam cmd, LogStorageData storageData) {
        storageData.setUpdateKeys(cmd.getKeyList());
        storageData.setUpdateColumnTypes(cmd.getColumnTypeList());
        storageData.setKeys(ml.getKeyList());
        storageData.setColumnTypes(ml.getColumnTypeList());
        storageData.setLogStoreName(ml.getLogstoreName());
        storageData.setUpdateStoreName(cmd.getLogstoreName());
        this.dorisLogStorageService.updateTable(storageData);
    }

    private void updateEsIndexIfNeeded(MilogLogStoreDO ml, LogStorageData storageData, OperateEnum operateEnum) {
        if (OperateEnum.DELETE_OPERATE == operateEnum) {
            return;
        }
        String tableName = this.dorisLogStorageService.buildTableName(storageData.getClusterId(), storageData.getStoreId());
        if (!StringUtils.equals((CharSequence)tableName, (CharSequence)ml.getEsIndex())) {
            ml.setEsClusterId(storageData.getClusterId());
            ml.setEsIndex(tableName);
            this.logStoreDao.updateMilogLogStore(ml);
        }
    }

    @Override
    public boolean sendConfigSwitch(LogStoreParam param) {
        return true;
    }

    @Override
    public void deleteStorePostProcessing(MilogLogStoreDO logStoreD) {
    }

    @Override
    public String getMangerEsLabel() {
        return "open source";
    }

    @Override
    public boolean updateLogStore(MilogLogStoreDO ml) {
        return this.logStoreDao.updateMilogLogStore(ml);
    }

    @Override
    public boolean isNeedSendMsgType(Integer logType) {
        return true;
    }
}

