/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.repository.cdi;

import jakarta.enterprise.context.spi.Contextual;
import jakarta.enterprise.context.spi.CreationalContext;
import jakarta.enterprise.inject.spi.Bean;
import jakarta.enterprise.inject.spi.BeanManager;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Iterator;
import java.util.function.Supplier;
import org.springframework.beans.BeanUtils;
import org.springframework.data.jpa.repository.QueryRewriter;
import org.springframework.data.jpa.repository.query.DelegatingQueryRewriter;
import org.springframework.data.jpa.repository.query.JpaQueryMethod;
import org.springframework.data.jpa.repository.query.QueryRewriterProvider;
import org.springframework.data.util.Lazy;

public class BeanManagerQueryRewriterProvider
implements QueryRewriterProvider {
    private final BeanManager beanManager;

    public BeanManagerQueryRewriterProvider(BeanManager beanManager) {
        this.beanManager = beanManager;
    }

    @Override
    public QueryRewriter getQueryRewriter(JpaQueryMethod method) {
        Class<? extends QueryRewriter> queryRewriter = method.getQueryRewriter();
        if (queryRewriter == QueryRewriter.IdentityQueryRewriter.class) {
            return QueryRewriter.IdentityQueryRewriter.INSTANCE;
        }
        Iterator iterator = this.beanManager.getBeans(queryRewriter, new Annotation[0]).iterator();
        if (iterator.hasNext()) {
            Bean bean = (Bean)iterator.next();
            CreationalContext context = this.beanManager.createCreationalContext((Contextual)bean);
            Lazy rewriter = Lazy.of(() -> (QueryRewriter)this.beanManager.getReference(bean, (Type)queryRewriter, context));
            return new DelegatingQueryRewriter((Supplier<QueryRewriter>)rewriter);
        }
        return (QueryRewriter)BeanUtils.instantiateClass(queryRewriter);
    }
}

