/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.trino.connector.catalog.jdbc.mysql;

import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.TrinoException;
import io.trino.spi.type.CharType;
import io.trino.spi.type.VarcharType;
import org.apache.gravitino.rel.types.Type;
import org.apache.gravitino.rel.types.Types;
import org.apache.gravitino.trino.connector.GravitinoErrorCode;
import org.apache.gravitino.trino.connector.util.GeneralDataTypeTransformer;

public class MySQLDataTypeTransformer
extends GeneralDataTypeTransformer {
    private static final int MYSQL_CHAR_LENGTH_LIMIT = 255;
    private static final int MYSQL_VARCHAR_LENGTH_LIMIT = 16383;

    @Override
    public io.trino.spi.type.Type getTrinoType(Type type) {
        if (type.name() == Type.Name.STRING) {
            return VarcharType.createUnboundedVarcharType();
        }
        return super.getTrinoType(type);
    }

    @Override
    public Type getGravitinoType(io.trino.spi.type.Type type) {
        Class<?> typeClass = type.getClass();
        if (typeClass == CharType.class) {
            CharType charType = (CharType)type;
            if (charType.getLength() > 255) {
                throw new TrinoException((ErrorCodeSupplier)GravitinoErrorCode.GRAVITINO_ILLEGAL_ARGUMENT, "MySQL does not support the datatype CHAR with the length greater than 255");
            }
            if (charType.getLength() == 0) {
                throw new TrinoException((ErrorCodeSupplier)GravitinoErrorCode.GRAVITINO_ILLEGAL_ARGUMENT, "MySQL does not support the datatype CHAR with the length 0");
            }
            return Types.FixedCharType.of((int)charType.getLength());
        }
        if (typeClass == VarcharType.class) {
            VarcharType varcharType = (VarcharType)type;
            if (varcharType.getLength().isEmpty()) {
                return Types.StringType.get();
            }
            int length = (Integer)varcharType.getLength().get();
            if (length > 16383) {
                throw new TrinoException((ErrorCodeSupplier)GravitinoErrorCode.GRAVITINO_ILLEGAL_ARGUMENT, "MySQL does not support the datatype VARCHAR with the length greater than 16383");
            }
            return Types.VarCharType.of((int)length);
        }
        return super.getGravitinoType(type);
    }
}

