/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.storage.relational.mapper;

import java.util.List;
import org.apache.gravitino.storage.relational.po.TagMetadataObjectRelPO;
import org.apache.gravitino.storage.relational.po.TagPO;
import org.apache.ibatis.annotations.Delete;
import org.apache.ibatis.annotations.Insert;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Select;
import org.apache.ibatis.annotations.Update;

public interface TagMetadataObjectRelMapper {
    public static final String TAG_METADATA_OBJECT_RELATION_TABLE_NAME = "tag_relation_meta";

    @Select(value={"SELECT tm.tag_id as tagId, tm.tag_name as tagName, tm.metalake_id as metalakeId, tm.tag_comment as comment, tm.properties as properties, tm.audit_info as auditInfo, tm.current_version as currentVersion, tm.last_version as lastVersion, tm.deleted_at as deletedAt FROM tag_meta tm JOIN tag_relation_meta te ON tm.tag_id = te.tag_id WHERE te.metadata_object_id = #{metadataObjectId} AND te.metadata_object_type = #{metadataObjectType} AND te.deleted_at = 0 AND tm.deleted_at = 0"})
    public List<TagPO> listTagPOsByMetadataObjectIdAndType(@Param(value="metadataObjectId") Long var1, @Param(value="metadataObjectType") String var2);

    @Select(value={"SELECT tm.tag_id as tagId, tm.tag_name as tagName, tm.metalake_id as metalakeId, tm.tag_comment as comment, tm.properties as properties, tm.audit_info as auditInfo, tm.current_version as currentVersion, tm.last_version as lastVersion, tm.deleted_at as deletedAt FROM tag_meta tm JOIN tag_relation_meta te ON tm.tag_id = te.tag_id WHERE te.metadata_object_id = #{metadataObjectId} AND te.metadata_object_type = #{metadataObjectType} AND tm.tag_name = #{tagName} AND te.deleted_at = 0 AND tm.deleted_at = 0"})
    public TagPO getTagPOsByMetadataObjectAndTagName(@Param(value="metadataObjectId") Long var1, @Param(value="metadataObjectType") String var2, @Param(value="tagName") String var3);

    @Select(value={"SELECT te.tag_id as tagId, te.metadata_object_id as metadataObjectId, te.metadata_object_type as metadataObjectType, te.audit_info as auditInfo, te.current_version as currentVersion, te.last_version as lastVersion, te.deleted_at as deletedAt FROM tag_relation_meta te JOIN tag_meta tm JOIN metalake_meta mm ON te.tag_id = tm.tag_id AND tm.metalake_id = mm.metalake_id WHERE mm.metalake_name = #{metalakeName} AND tm.tag_name = #{tagName} AND te.deleted_at = 0 AND tm.deleted_at = 0 AND mm.deleted_at = 0"})
    public List<TagMetadataObjectRelPO> listTagMetadataObjectRelsByMetalakeAndTagName(@Param(value="metalakeName") String var1, @Param(value="tagName") String var2);

    @Insert(value={"<script>", "INSERT INTO tag_relation_meta(tag_id, metadata_object_id, metadata_object_type, audit_info, current_version, last_version, deleted_at) VALUES ", "<foreach collection='tagRels' item='item' separator=','>", "(#{item.tagId}, #{item.metadataObjectId}, #{item.metadataObjectType}, #{item.auditInfo}, #{item.currentVersion}, #{item.lastVersion}, #{item.deletedAt})", "</foreach>", "</script>"})
    public void batchInsertTagMetadataObjectRels(@Param(value="tagRels") List<TagMetadataObjectRelPO> var1);

    @Update(value={"<script>", "UPDATE tag_relation_meta SET deleted_at = (UNIX_TIMESTAMP() * 1000.0) + EXTRACT(MICROSECOND FROM CURRENT_TIMESTAMP(3)) / 1000 WHERE tag_id IN ", "<foreach item='tagId' collection='tagIds' open='(' separator=',' close=')'>", "#{tagId}", "</foreach>", " And metadata_object_id = #{metadataObjectId} AND metadata_object_type = #{metadataObjectType} AND deleted_at = 0", "</script>"})
    public void batchDeleteTagMetadataObjectRelsByTagIdsAndMetadataObject(@Param(value="metadataObjectId") Long var1, @Param(value="metadataObjectType") String var2, @Param(value="tagIds") List<Long> var3);

    @Update(value={"UPDATE tag_relation_meta te SET te.deleted_at = (UNIX_TIMESTAMP() * 1000.0) + EXTRACT(MICROSECOND FROM CURRENT_TIMESTAMP(3)) / 1000 WHERE te.tag_id IN (SELECT tm.tag_id FROM tag_meta tm WHERE tm.metalake_id IN (SELECT mm.metalake_id FROM metalake_meta mm WHERE mm.metalake_name = #{metalakeName} AND mm.deleted_at = 0) AND tm.deleted_at = 0) AND te.deleted_at = 0"})
    public Integer softDeleteTagMetadataObjectRelsByMetalakeAndTagName(@Param(value="metalakeName") String var1, @Param(value="tagName") String var2);

    @Update(value={"UPDATE tag_relation_meta te SET te.deleted_at = (UNIX_TIMESTAMP() * 1000.0) + EXTRACT(MICROSECOND FROM CURRENT_TIMESTAMP(3)) / 1000 WHERE EXISTS (SELECT * FROM tag_meta tm WHERE tm.metalake_id = #{metalakeId} AND tm.tag_id = te.tag_id AND tm.deleted_at = 0) AND te.deleted_at = 0"})
    public void softDeleteTagMetadataObjectRelsByMetalakeId(@Param(value="metalakeId") Long var1);

    @Delete(value={"DELETE FROM tag_relation_meta WHERE deleted_at > 0 AND deleted_at < #{legacyTimeline} LIMIT #{limit}"})
    public Integer deleteTagEntityRelsByLegacyTimeline(@Param(value="legacyTimeline") Long var1, @Param(value="limit") int var2);
}

