/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino;

import com.google.common.collect.Lists;
import java.io.File;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.gravitino.config.ConfigBuilder;
import org.apache.gravitino.config.ConfigEntry;

public class Configs {
    public static final String KV_STORE_KEY = "kv";
    public static final String RELATIONAL_ENTITY_STORE = "relational";
    public static final String ENTITY_STORE_KEY = "gravitino.entity.store";
    public static final String DEFAULT_ENTITY_KV_STORE = "RocksDBKvBackend";
    public static final String ENTITY_KV_STORE_KEY = "gravitino.entity.store.kv";
    public static final String DEFAULT_ENTITY_RELATIONAL_STORE = "JDBCBackend";
    public static final String ENTITY_RELATIONAL_STORE_KEY = "gravitino.entity.store.relational";
    public static final String ENTITY_RELATIONAL_JDBC_BACKEND_URL_KEY = "gravitino.entity.store.relational.jdbcUrl";
    public static final String ENTITY_RELATIONAL_JDBC_BACKEND_DRIVER_KEY = "gravitino.entity.store.relational.jdbcDriver";
    public static final String ENTITY_RELATIONAL_JDBC_BACKEND_USER_KEY = "gravitino.entity.store.relational.jdbcUser";
    public static final String ENTITY_RELATIONAL_JDBC_BACKEND_PASSWORD_KEY = "gravitino.entity.store.relational.jdbcPassword";
    public static final String ENTITY_RELATIONAL_JDBC_BACKEND_STORAGE_PATH_KEY = "gravitino.entity.store.relational.storagePath";
    public static final String ENTITY_KV_ROCKSDB_BACKEND_PATH_KEY = "gravitino.entity.store.kv.rocksdbPath";
    public static final Long DEFAULT_KV_DELETE_AFTER_TIME;
    public static final String KV_DELETE_AFTER_TIME_KEY = "gravitino.entity.store.kv.deleteAfterTimeMs";
    public static final String STORE_DELETE_AFTER_TIME_KEY = "gravitino.entity.store.deleteAfterTimeMs";
    public static final Long DEFAULT_STORE_DELETE_AFTER_TIME;
    public static final Long MAX_DELETE_TIME_ALLOW;
    public static final Long MIN_DELETE_TIME_ALLOW;
    public static final String VERSION_RETENTION_COUNT_KEY = "gravitino.entity.store.versionRetentionCount";
    public static final Long DEFAULT_VERSION_RETENTION_COUNT;
    public static final Long MAX_VERSION_RETENTION_COUNT;
    public static final Long MIN_VERSION_RETENTION_COUNT;
    public static final String DEFAULT_KV_ROCKSDB_BACKEND_PATH;
    public static final String DEFAULT_RELATIONAL_JDBC_BACKEND_PATH;
    public static final String DEFAULT_RELATIONAL_JDBC_BACKEND_URL = "jdbc:h2";
    public static final String DEFAULT_RELATIONAL_JDBC_BACKEND_DRIVER = "org.h2.Driver";
    public static final String DEFAULT_RELATIONAL_JDBC_BACKEND_USERNAME = "gravitino";
    public static final String DEFAULT_RELATIONAL_JDBC_BACKEND_PASSWORD = "gravitino";
    public static final int GARBAGE_COLLECTOR_SINGLE_DELETION_LIMIT = 100;
    public static final long MAX_NODE_IN_MEMORY = 100000L;
    public static final long MIN_NODE_IN_MEMORY = 1000L;
    public static final long CLEAN_INTERVAL_IN_SECS = 60L;
    public static final ConfigEntry<String> ENTITY_STORE;
    public static final ConfigEntry<String> ENTITY_KV_STORE;
    public static final ConfigEntry<String> ENTITY_RELATIONAL_STORE;
    public static final ConfigEntry<String> ENTITY_RELATIONAL_JDBC_BACKEND_URL;
    public static final ConfigEntry<String> ENTITY_RELATIONAL_JDBC_BACKEND_DRIVER;
    public static final ConfigEntry<String> ENTITY_RELATIONAL_JDBC_BACKEND_USER;
    public static final ConfigEntry<String> ENTITY_RELATIONAL_JDBC_BACKEND_PASSWORD;
    public static final ConfigEntry<String> ENTITY_RELATIONAL_JDBC_BACKEND_PATH;
    public static final ConfigEntry<String> ENTITY_KV_ROCKSDB_BACKEND_PATH;
    public static final ConfigEntry<String> ENTITY_SERDE;
    public static final ConfigEntry<Long> CATALOG_CACHE_EVICTION_INTERVAL_MS;
    public static final ConfigEntry<Boolean> CATALOG_LOAD_ISOLATED;
    public static final ConfigEntry<String> AUTHENTICATOR;
    public static final ConfigEntry<List<String>> AUTHENTICATORS;
    public static final ConfigEntry<Long> STORE_TRANSACTION_MAX_SKEW_TIME;
    public static final ConfigEntry<Long> KV_DELETE_AFTER_TIME;
    public static final ConfigEntry<Long> STORE_DELETE_AFTER_TIME;
    public static final ConfigEntry<Long> VERSION_RETENTION_COUNT;
    public static final ConfigEntry<Long> TREE_LOCK_MAX_NODE_IN_MEMORY;
    public static final ConfigEntry<Long> TREE_LOCK_MIN_NODE_IN_MEMORY;
    public static final ConfigEntry<Long> TREE_LOCK_CLEAN_INTERVAL;
    public static final ConfigEntry<Boolean> ENABLE_AUTHORIZATION;
    public static final ConfigEntry<List<String>> SERVICE_ADMINS;
    public static final ConfigEntry<Long> ROLE_CACHE_EVICTION_INTERVAL_MS;
    public static final int DEFAULT_METRICS_TIME_SLIDING_WINDOW_SECONDS = 60;
    public static final ConfigEntry<Integer> METRICS_TIME_SLIDING_WINDOW_SECONDS;
    public static final ConfigEntry<List<String>> REST_API_EXTENSION_PACKAGES;

    private Configs() {
    }

    static {
        DEFAULT_STORE_DELETE_AFTER_TIME = DEFAULT_KV_DELETE_AFTER_TIME = Long.valueOf(604800000L);
        MAX_DELETE_TIME_ALLOW = 2592000000L;
        MIN_DELETE_TIME_ALLOW = 600000L;
        DEFAULT_VERSION_RETENTION_COUNT = 1L;
        MAX_VERSION_RETENTION_COUNT = 10L;
        MIN_VERSION_RETENTION_COUNT = 1L;
        DEFAULT_KV_ROCKSDB_BACKEND_PATH = String.join((CharSequence)File.separator, System.getenv("GRAVITINO_HOME"), "data", "rocksdb");
        DEFAULT_RELATIONAL_JDBC_BACKEND_PATH = String.join((CharSequence)File.separator, System.getenv("GRAVITINO_HOME"), "data", "jdbc");
        ENTITY_STORE = new ConfigBuilder(ENTITY_STORE_KEY).doc("Which storage implementation to use").version("0.1.0").stringConf().createWithDefault(RELATIONAL_ENTITY_STORE);
        ENTITY_KV_STORE = new ConfigBuilder(ENTITY_KV_STORE_KEY).doc("Detailed implementation of Kv storage").version("0.1.0").stringConf().createWithDefault(DEFAULT_ENTITY_KV_STORE);
        ENTITY_RELATIONAL_STORE = new ConfigBuilder(ENTITY_RELATIONAL_STORE_KEY).doc("Detailed implementation of relational storage").version("0.5.0").stringConf().checkValue(StringUtils::isNotBlank, "The value can't be blank").createWithDefault(DEFAULT_ENTITY_RELATIONAL_STORE);
        ENTITY_RELATIONAL_JDBC_BACKEND_URL = new ConfigBuilder(ENTITY_RELATIONAL_JDBC_BACKEND_URL_KEY).doc("Connection URL of `JDBCBackend`").version("0.5.0").stringConf().checkValue(StringUtils::isNotBlank, "The value can't be blank").createWithDefault(DEFAULT_RELATIONAL_JDBC_BACKEND_URL);
        ENTITY_RELATIONAL_JDBC_BACKEND_DRIVER = new ConfigBuilder(ENTITY_RELATIONAL_JDBC_BACKEND_DRIVER_KEY).doc("Driver Name of `JDBCBackend`").version("0.5.0").stringConf().checkValue(StringUtils::isNotBlank, "The value can't be blank").createWithDefault(DEFAULT_RELATIONAL_JDBC_BACKEND_DRIVER);
        ENTITY_RELATIONAL_JDBC_BACKEND_USER = new ConfigBuilder(ENTITY_RELATIONAL_JDBC_BACKEND_USER_KEY).doc("Username of `JDBCBackend`").version("0.5.0").stringConf().checkValue(StringUtils::isNotBlank, "The value can't be blank").createWithDefault("gravitino");
        ENTITY_RELATIONAL_JDBC_BACKEND_PASSWORD = new ConfigBuilder(ENTITY_RELATIONAL_JDBC_BACKEND_PASSWORD_KEY).doc("Password of `JDBCBackend`").version("0.5.0").stringConf().createWithDefault("gravitino");
        ENTITY_RELATIONAL_JDBC_BACKEND_PATH = new ConfigBuilder(ENTITY_RELATIONAL_JDBC_BACKEND_STORAGE_PATH_KEY).doc("The storage path for JDBC storage implementation. It supports both absolute and relative path, if the value is a relative path, the final path is `${GRAVITINO_HOME}/${PATH_YOU_HAVA_SET}`, default value is `${GRAVITINO_HOME}/data/jdbc`").version("0.6.0").stringConf().createWithDefault(DEFAULT_RELATIONAL_JDBC_BACKEND_PATH);
        ENTITY_KV_ROCKSDB_BACKEND_PATH = new ConfigBuilder(ENTITY_KV_ROCKSDB_BACKEND_PATH_KEY).doc("The storage path for RocksDB storage implementation. It supports both absolute and relative path, if the value is a relative path, the final path is `${GRAVITINO_HOME}/${PATH_YOU_HAVA_SET}`, default value is `${GRAVITINO_HOME}/data/rocksdb`").version("0.1.0").stringConf().createWithDefault(DEFAULT_KV_ROCKSDB_BACKEND_PATH);
        ENTITY_SERDE = new ConfigBuilder("gravitino.entity.serde").doc("The entity SerDe to use").version("0.1.0").stringConf().createWithDefault("proto");
        CATALOG_CACHE_EVICTION_INTERVAL_MS = new ConfigBuilder("gravitino.catalog.cache.evictionIntervalMs").doc("The interval in milliseconds to evict the catalog cache").version("0.1.0").longConf().createWithDefault(3600000L);
        CATALOG_LOAD_ISOLATED = new ConfigBuilder("gravitino.catalog.classloader.isolated").doc("Whether to load the catalog in an isolated classloader").version("0.1.0").booleanConf().createWithDefault(true);
        AUTHENTICATOR = new ConfigBuilder("gravitino.authenticator").doc("The authenticator which Gravitino uses. Multiple authenticators separated by commas").version("0.3.0").deprecated().stringConf().createWithDefault("simple");
        AUTHENTICATORS = new ConfigBuilder("gravitino.authenticators").doc("The authenticators which Gravitino uses. Multiple authenticators separated by commas").version("0.6.0").alternatives(Lists.newArrayList((Object[])new String[]{"gravitino.authenticator"})).stringConf().toSequence().checkValue(valueList -> valueList != null && valueList.stream().allMatch(StringUtils::isNotBlank), "The value can't be blank").createWithDefault(Lists.newArrayList((Object[])new String[]{"simple"}));
        STORE_TRANSACTION_MAX_SKEW_TIME = new ConfigBuilder("gravitino.entity.store.maxTransactionSkewTimeMs").doc("The maximum skew time of transactions in milliseconds").version("0.3.0").longConf().createWithDefault(2000L);
        KV_DELETE_AFTER_TIME = new ConfigBuilder(KV_DELETE_AFTER_TIME_KEY).doc(String.format("The maximum time in milliseconds that the deleted data and old version data is kept, max delete time allow is %s ms(30 days), min delete time allow is %s ms(10 minutes)", MAX_DELETE_TIME_ALLOW, MIN_DELETE_TIME_ALLOW)).version("0.5.0").deprecated().longConf().checkValue(v -> v >= MIN_DELETE_TIME_ALLOW && v <= MAX_DELETE_TIME_ALLOW, String.format("The value of %s is out of range, which must be between %s and %s", KV_DELETE_AFTER_TIME_KEY, MIN_DELETE_TIME_ALLOW, MAX_DELETE_TIME_ALLOW)).createWithDefault(DEFAULT_KV_DELETE_AFTER_TIME);
        STORE_DELETE_AFTER_TIME = new ConfigBuilder(STORE_DELETE_AFTER_TIME_KEY).doc(String.format("The maximum time in milliseconds that the deleted data and old version data is kept, max delete time allow is %s ms(30 days), min delete time allow is %s ms(10 minutes)", MAX_DELETE_TIME_ALLOW, MIN_DELETE_TIME_ALLOW)).version("0.5.0").alternatives(Lists.newArrayList((Object[])new String[]{KV_DELETE_AFTER_TIME_KEY})).longConf().checkValue(v -> v >= MIN_DELETE_TIME_ALLOW && v <= MAX_DELETE_TIME_ALLOW, String.format("The value of %s is out of range, which must be between %s and %s", STORE_DELETE_AFTER_TIME_KEY, MIN_DELETE_TIME_ALLOW, MAX_DELETE_TIME_ALLOW)).createWithDefault(DEFAULT_STORE_DELETE_AFTER_TIME);
        VERSION_RETENTION_COUNT = new ConfigBuilder(VERSION_RETENTION_COUNT_KEY).doc(String.format("The count of versions allowed to be retained, including the current version, max version retention count is %s, min version retention count is %s", MAX_VERSION_RETENTION_COUNT, MIN_VERSION_RETENTION_COUNT)).version("0.5.0").longConf().checkValue(v -> v >= MIN_VERSION_RETENTION_COUNT && v <= MAX_VERSION_RETENTION_COUNT, String.format("The value of %s is out of range, which must be between %s and %s", VERSION_RETENTION_COUNT_KEY, MIN_VERSION_RETENTION_COUNT, MAX_VERSION_RETENTION_COUNT)).createWithDefault(DEFAULT_VERSION_RETENTION_COUNT);
        TREE_LOCK_MAX_NODE_IN_MEMORY = new ConfigBuilder("gravitino.lock.maxNodes").doc("The maximum number of tree lock nodes to keep in memory").version("0.4.0").longConf().createWithDefault(100000L);
        TREE_LOCK_MIN_NODE_IN_MEMORY = new ConfigBuilder("gravitino.lock.minNodes").doc("The minimum number of tree lock nodes to keep in memory").version("0.4.0").longConf().createWithDefault(1000L);
        TREE_LOCK_CLEAN_INTERVAL = new ConfigBuilder("gravitino.lock.cleanIntervalInSecs").doc("The interval in seconds to clean up the stale tree lock nodes").version("0.4.0").longConf().createWithDefault(60L);
        ENABLE_AUTHORIZATION = new ConfigBuilder("gravitino.authorization.enable").doc("Enable the authorization").version("0.5.0").booleanConf().createWithDefault(false);
        SERVICE_ADMINS = new ConfigBuilder("gravitino.authorization.serviceAdmins").doc("The admins of Gravitino service").version("0.5.0").stringConf().toSequence().checkValue(valueList -> valueList != null && valueList.stream().allMatch(StringUtils::isNotBlank), "The value can't be blank").create();
        ROLE_CACHE_EVICTION_INTERVAL_MS = new ConfigBuilder("gravitino.authorization.roleCacheEvictionIntervalMs").doc("The interval in milliseconds to evict the role cache").version("0.5.0").longConf().createWithDefault(3600000L);
        METRICS_TIME_SLIDING_WINDOW_SECONDS = new ConfigBuilder("gravitino.metrics.timeSlidingWindowSecs").doc("The seconds of Gravitino metrics time sliding window").version("0.5.1").intConf().createWithDefault(60);
        REST_API_EXTENSION_PACKAGES = new ConfigBuilder("gravitino.server.rest.extensionPackages").doc("Comma-separated list of REST API packages to expand").version("0.6.0").stringConf().toSequence().createWithDefault(Collections.emptyList());
    }
}

