/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.migrationtools.config.converters;

import java.util.concurrent.ExecutionException;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.migrationtools.config.converters.ConfigurationConverter;
import org.apache.ignite.migrationtools.config.registry.ConfigurationRegistryInterface;
import org.apache.ignite.spi.communication.CommunicationSpi;
import org.apache.ignite.spi.communication.tcp.TcpCommunicationSpi;
import org.apache.ignite3.internal.network.configuration.NetworkConfiguration;
import org.apache.ignite3.internal.network.configuration.NetworkExtensionConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommunicationSpiConverter
implements ConfigurationConverter {
    private static final Logger LOGGER = LoggerFactory.getLogger(CommunicationSpiConverter.class);

    @Override
    public void convert(IgniteConfiguration src, ConfigurationRegistryInterface registry) throws ExecutionException, InterruptedException {
        CommunicationSpi commSpi = src.getCommunicationSpi();
        if (commSpi == null) {
            LOGGER.error("Could not find a CommunicationSpi in the source configuration.");
            return;
        }
        if (!(commSpi instanceof TcpCommunicationSpi)) {
            LOGGER.warn("CommunicationSpi is not a TcpCommunicationSpi: {}", (Object)commSpi.getClass().getName());
            return;
        }
        TcpCommunicationSpi tcpCommSpi = (TcpCommunicationSpi)commSpi;
        NetworkConfiguration target = ((NetworkExtensionConfiguration)registry.getConfiguration(NetworkExtensionConfiguration.KEY)).network();
        target.port().update((Object)tcpCommSpi.getLocalPort()).get();
        if (tcpCommSpi.getLocalPortRange() > 0) {
            LOGGER.error("Local Port Range in TcpCommunicationSpi will be ignored. There's no similar feature in Apache Ignite 3");
        }
        target.inbound().tcpNoDelay().update((Object)tcpCommSpi.isTcpNoDelay()).get();
    }
}

