/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.catalog.descriptors;

import java.util.Objects;
import org.apache.ignite3.internal.catalog.CatalogManager;
import org.apache.ignite3.internal.hlc.HybridTimestamp;
import org.apache.ignite3.internal.tostring.S;

public abstract class CatalogObjectDescriptor {
    private final int id;
    private final String name;
    private final Type type;
    private HybridTimestamp updateTimestamp;

    CatalogObjectDescriptor(int id, Type type, String name, HybridTimestamp timestamp) {
        this.id = id;
        this.type = Objects.requireNonNull(type, "type");
        this.name = Objects.requireNonNull(name, "name");
        this.updateTimestamp = timestamp;
    }

    public int id() {
        return this.id;
    }

    public String name() {
        return this.name;
    }

    public Type type() {
        return this.type;
    }

    public HybridTimestamp updateTimestamp() {
        return this.updateTimestamp;
    }

    public void updateTimestamp(HybridTimestamp updateTimestamp) {
        assert (this.updateTimestamp.equals(CatalogManager.INITIAL_TIMESTAMP)) : "Update timestamp for the descriptor must be updated only once";
        this.updateTimestamp = updateTimestamp;
    }

    public String toString() {
        return S.toString(CatalogObjectDescriptor.class, this);
    }

    public static enum Type {
        SCHEMA,
        TABLE,
        INDEX,
        ZONE,
        SYSTEM_VIEW;

    }
}

