/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.partition.replicator.network.replication;

import java.util.BitSet;
import java.util.UUID;
import org.apache.ignite.internal.hlc.HybridTimestamp;
import org.apache.ignite.internal.network.serialization.MessageDeserializer;
import org.apache.ignite.internal.network.serialization.MessageMappingException;
import org.apache.ignite.internal.network.serialization.MessageReader;
import org.apache.ignite.internal.partition.replicator.network.PartitionReplicationMessagesFactory;
import org.apache.ignite.internal.partition.replicator.network.replication.BinaryTupleMessage;
import org.apache.ignite.internal.partition.replicator.network.replication.ReadOnlyScanRetrieveBatchReplicaRequest;
import org.apache.ignite.internal.partition.replicator.network.replication.ReadOnlyScanRetrieveBatchReplicaRequestBuilder;
import org.apache.ignite.internal.replicator.message.ReplicationGroupIdMessage;

class ReadOnlyScanRetrieveBatchReplicaRequestDeserializer
implements MessageDeserializer<ReadOnlyScanRetrieveBatchReplicaRequest> {
    private final ReadOnlyScanRetrieveBatchReplicaRequestBuilder msg;

    ReadOnlyScanRetrieveBatchReplicaRequestDeserializer(PartitionReplicationMessagesFactory messageFactory) {
        this.msg = messageFactory.readOnlyScanRetrieveBatchReplicaRequest();
    }

    public Class<ReadOnlyScanRetrieveBatchReplicaRequest> klass() {
        return ReadOnlyScanRetrieveBatchReplicaRequest.class;
    }

    public ReadOnlyScanRetrieveBatchReplicaRequest getMessage() {
        return this.msg.build();
    }

    public boolean readMessage(MessageReader reader) throws MessageMappingException {
        if (!reader.beforeMessageRead()) {
            return false;
        }
        switch (reader.state()) {
            case 0: {
                int tmp = reader.readInt("batchSize");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.batchSize(tmp);
                reader.incrementState();
            }
            case 1: {
                Object tmp = reader.readBitSet("columnsToInclude");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.columnsToInclude((BitSet)tmp);
                reader.incrementState();
            }
            case 2: {
                Object tmp = reader.readUuid("coordinatorId");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.coordinatorId((UUID)tmp);
                reader.incrementState();
            }
            case 3: {
                Object tmp = (BinaryTupleMessage)reader.readMessage("exactKey");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.exactKey((BinaryTupleMessage)tmp);
                reader.incrementState();
            }
            case 4: {
                int tmp = reader.readInt("flags");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.flags(tmp);
                reader.incrementState();
            }
            case 5: {
                Object tmp = (ReplicationGroupIdMessage)reader.readMessage("groupId");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.groupId((ReplicationGroupIdMessage)tmp);
                reader.incrementState();
            }
            case 6: {
                Object tmp = reader.readBoxedInt("indexToUse");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.indexToUse((Integer)tmp);
                reader.incrementState();
            }
            case 7: {
                Object tmp = (BinaryTupleMessage)reader.readMessage("lowerBoundPrefix");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.lowerBoundPrefix((BinaryTupleMessage)tmp);
                reader.incrementState();
            }
            case 8: {
                Object tmp = reader.readHybridTimestamp("readTimestamp");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.readTimestamp((HybridTimestamp)tmp);
                reader.incrementState();
            }
            case 9: {
                long tmp = reader.readLong("scanId");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.scanId(tmp);
                reader.incrementState();
            }
            case 10: {
                int tmp = reader.readInt("tableId");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.tableId(tmp);
                reader.incrementState();
            }
            case 11: {
                Object tmp = reader.readHybridTimestamp("timestamp");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.timestamp((HybridTimestamp)tmp);
                reader.incrementState();
            }
            case 12: {
                Object tmp = reader.readUuid("transactionId");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.transactionId((UUID)tmp);
                reader.incrementState();
            }
            case 13: {
                Object tmp = (BinaryTupleMessage)reader.readMessage("upperBoundPrefix");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.upperBoundPrefix((BinaryTupleMessage)tmp);
                reader.incrementState();
            }
        }
        return reader.afterMessageRead(ReadOnlyScanRetrieveBatchReplicaRequest.class);
    }
}

