/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.sql.dialect;

import org.apache.calcite.avatica.util.TimeUnitRange;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlDialect;
import org.apache.calcite.sql.SqlLiteral;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlWriter;
import org.apache.calcite.sql.dialect.StarRocksSqlDialect;
import org.apache.calcite.sql.fun.SqlFloorFunction;
import org.apache.calcite.util.RelToSqlConverterUtil;

public class DorisSqlDialect
extends StarRocksSqlDialect {
    public static final SqlDialect DEFAULT = new DorisSqlDialect(DEFAULT_CONTEXT);

    public DorisSqlDialect(SqlDialect.Context context) {
        super(context);
    }

    @Override
    public void unparseCall(SqlWriter writer, SqlCall call, int leftPrec, int rightPrec) {
        switch (call.getKind()) {
            case MAP_VALUE_CONSTRUCTOR: {
                RelToSqlConverterUtil.unparseSparkArrayAndMap(writer, call, leftPrec, rightPrec);
                break;
            }
            case FLOOR: {
                if (call.operandCount() != 2) {
                    super.unparseCall(writer, call, leftPrec, rightPrec);
                    return;
                }
                SqlLiteral timeUnitNode = (SqlLiteral)call.operand(1);
                TimeUnitRange timeUnit = timeUnitNode.getValueAs(TimeUnitRange.class);
                SqlCall newCall = SqlFloorFunction.replaceTimeUnitOperand(call, timeUnit.name(), timeUnitNode.getParserPosition());
                SqlFloorFunction.unparseDatetimeFunction(writer, newCall, "DATE_TRUNC", true);
                break;
            }
            case EXTRACT: {
                writer.print(call.getOperator().getName());
                SqlWriter.Frame extractFrame = writer.startList("(", ")");
                ((SqlNode)call.operand(0)).unparse(writer, 0, 0);
                writer.sep("FROM");
                String value = ((SqlLiteral)call.operand(1)).toValue();
                writer.print("'" + value + "'");
                writer.endList(extractFrame);
                break;
            }
            default: {
                super.unparseCall(writer, call, leftPrec, rightPrec);
            }
        }
    }
}

