/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http2.impl.nio;

import java.io.IOException;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hc.core5.concurrent.Cancellable;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpException;
import org.apache.hc.core5.http.nio.AsyncPushProducer;
import org.apache.hc.core5.http.nio.CapacityChannel;
import org.apache.hc.core5.http.nio.DataStreamChannel;
import org.apache.hc.core5.http2.H2Error;

interface H2StreamChannel
extends DataStreamChannel,
CapacityChannel,
Cancellable {
    public int getId();

    public AtomicInteger getOutputWindow();

    public AtomicInteger getInputWindow();

    public void submit(List<Header> var1, boolean var2) throws HttpException, IOException;

    public void push(List<Header> var1, AsyncPushProducer var2) throws HttpException, IOException;

    public boolean isLocalClosed();

    public void markLocalClosed();

    public boolean localReset(int var1) throws IOException;

    default public boolean localReset(H2Error error) throws IOException {
        return this.localReset(error != null ? error.getCode() : H2Error.INTERNAL_ERROR.getCode());
    }

    default public void terminate() {
        try {
            this.localReset(H2Error.INTERNAL_ERROR);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public long getLocalResetTime();

    default public boolean isLocalReset() {
        return this.getLocalResetTime() > 0L;
    }
}

