/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.utils;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimaps;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.beans.PropertyDescriptor;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.ListUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.common.StatsSetupConst;
import org.apache.hadoop.hive.common.TableName;
import org.apache.hadoop.hive.metastore.ColumnType;
import org.apache.hadoop.hive.metastore.ExceptionHandler;
import org.apache.hadoop.hive.metastore.HiveMetaStore;
import org.apache.hadoop.hive.metastore.IMetaStoreClient;
import org.apache.hadoop.hive.metastore.Warehouse;
import org.apache.hadoop.hive.metastore.api.ColumnStatistics;
import org.apache.hadoop.hive.metastore.api.ColumnStatisticsData;
import org.apache.hadoop.hive.metastore.api.ColumnStatisticsObj;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.metastore.api.Decimal;
import org.apache.hadoop.hive.metastore.api.EnvironmentContext;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.GetPartitionsRequest;
import org.apache.hadoop.hive.metastore.api.GetPartitionsResponse;
import org.apache.hadoop.hive.metastore.api.InvalidObjectException;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.MetastoreException;
import org.apache.hadoop.hive.metastore.api.NoSuchObjectException;
import org.apache.hadoop.hive.metastore.api.Order;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.api.PartitionListComposingSpec;
import org.apache.hadoop.hive.metastore.api.PartitionSpec;
import org.apache.hadoop.hive.metastore.api.PartitionSpecWithSharedSD;
import org.apache.hadoop.hive.metastore.api.PartitionWithoutSD;
import org.apache.hadoop.hive.metastore.api.SerDeInfo;
import org.apache.hadoop.hive.metastore.api.SkewedInfo;
import org.apache.hadoop.hive.metastore.api.StorageDescriptor;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.metastore.api.TxnType;
import org.apache.hadoop.hive.metastore.columnstats.aggr.ColumnStatsAggregator;
import org.apache.hadoop.hive.metastore.columnstats.aggr.ColumnStatsAggregatorFactory;
import org.apache.hadoop.hive.metastore.columnstats.merge.ColumnStatsMerger;
import org.apache.hadoop.hive.metastore.columnstats.merge.ColumnStatsMergerFactory;
import org.apache.hadoop.hive.metastore.conf.MetastoreConf;
import org.apache.hadoop.hive.metastore.partition.spec.PartitionSpecProxy;
import org.apache.hadoop.hive.metastore.security.DBTokenStore;
import org.apache.hadoop.hive.metastore.security.HadoopThriftAuthBridge;
import org.apache.hadoop.hive.metastore.security.MemoryTokenStore;
import org.apache.hadoop.hive.metastore.security.ZooKeeperTokenStore;
import org.apache.hadoop.hive.metastore.utils.FileUtils;
import org.apache.hadoop.hive.metastore.utils.JavaUtils;
import org.apache.hadoop.hive.metastore.utils.MetaStoreUtils;
import org.apache.hadoop.security.authorize.DefaultImpersonationProvider;
import org.apache.hadoop.security.authorize.ProxyUsers;
import org.apache.hadoop.util.MachineList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetaStoreServerUtils {
    private static final Charset ENCODING = StandardCharsets.UTF_8;
    private static final Logger LOG = LoggerFactory.getLogger(MetaStoreServerUtils.class);
    public static final String JUNIT_DATABASE_PREFIX = "junit_metastore_db";
    private static final Function<String, String> transFormNullsToEmptyString = new Function<String, String>(){

        public String apply(@Nullable String string) {
            return StringUtils.defaultString((String)string);
        }
    };
    private static final String DELEGATION_TOKEN_STORE_CLS = "hive.cluster.delegation.token.store.class";
    private static final char DOT = '.';

    public static Map<String, String> trimMapNulls(Map<String, String> dnMap, boolean retrieveMapNullsAsEmptyStrings) {
        if (dnMap == null) {
            return null;
        }
        if (retrieveMapNullsAsEmptyStrings) {
            return Maps.newLinkedHashMap((Map)Maps.transformValues(dnMap, transFormNullsToEmptyString));
        }
        return Maps.newLinkedHashMap((Map)Maps.filterValues(dnMap, (Predicate)Predicates.notNull()));
    }

    public static List<ColumnStatisticsObj> aggrPartitionStats(List<ColumnStatistics> partStats, String catName, String dbName, String tableName, List<String> partNames, List<String> colNames, boolean areAllPartsFound, boolean useDensityFunctionForNDVEstimation, double ndvTuner) throws MetaException {
        HashMap<ColumnStatsAggregator, List<ColStatsObjWithSourceInfo>> colStatsMap = new HashMap<ColumnStatsAggregator, List<ColStatsObjWithSourceInfo>>();
        HashMap<String, ColumnStatsAggregator> aliasToAggregator = new HashMap<String, ColumnStatsAggregator>();
        for (ColumnStatistics css : partStats) {
            List objs = css.getStatsObj();
            for (ColumnStatisticsObj obj : objs) {
                String partName = css.getStatsDesc().getPartName();
                if (aliasToAggregator.get(obj.getColName()) == null) {
                    aliasToAggregator.put(obj.getColName(), ColumnStatsAggregatorFactory.getColumnStatsAggregator((ColumnStatisticsData._Fields)obj.getStatsData().getSetField(), useDensityFunctionForNDVEstimation, ndvTuner));
                    colStatsMap.put((ColumnStatsAggregator)aliasToAggregator.get(obj.getColName()), new ArrayList());
                }
                ((List)colStatsMap.get(aliasToAggregator.get(obj.getColName()))).add(new ColStatsObjWithSourceInfo(obj, catName, dbName, tableName, partName));
            }
        }
        if (colStatsMap.size() < 1) {
            LOG.debug("No stats data found for: tblName= {}, partNames= {}, colNames= {}", new Object[]{TableName.getQualified((String)catName, (String)dbName, (String)tableName), partNames, colNames});
            return Collections.emptyList();
        }
        return MetaStoreServerUtils.aggrPartitionStats(colStatsMap, partNames, areAllPartsFound, useDensityFunctionForNDVEstimation, ndvTuner);
    }

    public static List<ColumnStatisticsObj> aggrPartitionStats(Map<ColumnStatsAggregator, List<ColStatsObjWithSourceInfo>> colStatsMap, final List<String> partNames, final boolean areAllPartsFound, boolean useDensityFunctionForNDVEstimation, double ndvTuner) throws MetaException {
        ArrayList<ColumnStatisticsObj> aggrColStatObjs = new ArrayList<ColumnStatisticsObj>();
        int numProcessors = Runtime.getRuntime().availableProcessors();
        ExecutorService pool = Executors.newFixedThreadPool(Math.min(colStatsMap.size(), numProcessors), new ThreadFactoryBuilder().setDaemon(true).setNameFormat("aggr-col-stats-%d").build());
        LinkedList futures = Lists.newLinkedList();
        LOG.debug("Aggregating column stats. Threads used: {}", (Object)Math.min(colStatsMap.size(), numProcessors));
        long start = System.currentTimeMillis();
        for (final Map.Entry<ColumnStatsAggregator, List<ColStatsObjWithSourceInfo>> entry : colStatsMap.entrySet()) {
            futures.add(pool.submit(new Callable<ColumnStatisticsObj>(){

                @Override
                public ColumnStatisticsObj call() throws MetaException {
                    List colStatWithSourceInfo = (List)entry.getValue();
                    ColumnStatsAggregator aggregator = (ColumnStatsAggregator)entry.getKey();
                    try {
                        ColumnStatisticsObj statsObj = aggregator.aggregate(colStatWithSourceInfo, partNames, areAllPartsFound);
                        return statsObj;
                    }
                    catch (MetaException e) {
                        LOG.debug(e.getMessage());
                        throw e;
                    }
                }
            }));
        }
        pool.shutdown();
        if (!futures.isEmpty()) {
            for (Future future : futures) {
                try {
                    if (future.get() == null) continue;
                    aggrColStatObjs.add((ColumnStatisticsObj)future.get());
                }
                catch (InterruptedException | ExecutionException e) {
                    LOG.debug(e.getMessage());
                    pool.shutdownNow();
                    throw new MetaException(e.toString());
                }
            }
        }
        LOG.debug("Time for aggr col stats in seconds: {} Threads used: {}", (Object)(((double)System.currentTimeMillis() - (double)start) / 1000.0), (Object)Math.min(colStatsMap.size(), numProcessors));
        return aggrColStatObjs;
    }

    public static double decimalToDouble(Decimal decimal) {
        return new BigDecimal(new BigInteger(decimal.getUnscaled()), decimal.getScale()).doubleValue();
    }

    private static Pattern getPartitionValidationRegex(Configuration conf) {
        return Optional.ofNullable(MetastoreConf.getVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.PARTITION_NAME_WHITELIST_PATTERN)).filter(StringUtils::isNotBlank).map(Pattern::compile).orElse(null);
    }

    public static void validatePartitionNameCharacters(List<String> partVals, Configuration conf) throws MetaException {
        Pattern partitionValidationPattern = MetaStoreServerUtils.getPartitionValidationRegex(conf);
        String invalidPartitionVal = MetaStoreServerUtils.getPartitionValWithInvalidCharacter(partVals, partitionValidationPattern);
        if (invalidPartitionVal != null) {
            String errorMsg = "Partition value '%s' contains a character not matched by whitelist pattern '%s'. Configure with %s".formatted(invalidPartitionVal, partitionValidationPattern.toString(), MetastoreConf.ConfVars.PARTITION_NAME_WHITELIST_PATTERN.getVarname());
            throw new MetaException(errorMsg);
        }
    }

    private static String getPartitionValWithInvalidCharacter(List<String> partVals, Pattern partitionValidationPattern) {
        String result = null;
        if (partitionValidationPattern != null) {
            result = partVals.stream().filter(partVal -> !partitionValidationPattern.matcher((CharSequence)partVal).matches()).findFirst().orElse(null);
        }
        return result;
    }

    public static synchronized byte[] hashStorageDescriptor(StorageDescriptor sd, MessageDigest md) {
        md.reset();
        if (sd.getCols() != null) {
            for (FieldSchema fs : sd.getCols()) {
                md.update(fs.getName().getBytes(ENCODING));
                md.update(fs.getType().getBytes(ENCODING));
                if (fs.getComment() == null) continue;
                md.update(fs.getComment().getBytes(ENCODING));
            }
        }
        if (sd.getInputFormat() != null) {
            md.update(sd.getInputFormat().getBytes(ENCODING));
        }
        if (sd.getOutputFormat() != null) {
            md.update(sd.getOutputFormat().getBytes(ENCODING));
        }
        md.update(sd.isCompressed() ? "true".getBytes(ENCODING) : "false".getBytes(ENCODING));
        md.update(Integer.toString(sd.getNumBuckets()).getBytes(ENCODING));
        if (sd.getSerdeInfo() != null) {
            SerDeInfo serde = sd.getSerdeInfo();
            if (serde.getName() != null) {
                md.update(serde.getName().getBytes(ENCODING));
            }
            if (serde.getSerializationLib() != null) {
                md.update(serde.getSerializationLib().getBytes(ENCODING));
            }
            if (serde.getParameters() != null) {
                TreeMap params = new TreeMap(serde.getParameters());
                for (Map.Entry param : params.entrySet()) {
                    md.update(((String)param.getKey()).getBytes(ENCODING));
                    md.update(((String)param.getValue()).getBytes(ENCODING));
                }
            }
        }
        if (sd.getBucketCols() != null) {
            ArrayList bucketCols = new ArrayList(sd.getBucketCols());
            for (String bucket : bucketCols) {
                md.update(bucket.getBytes(ENCODING));
            }
        }
        if (sd.getSortCols() != null) {
            TreeSet orders = new TreeSet(sd.getSortCols());
            for (Order order : orders) {
                md.update(order.getCol().getBytes(ENCODING));
                md.update(Integer.toString(order.getOrder()).getBytes(ENCODING));
            }
        }
        if (sd.getSkewedInfo() != null) {
            SkewedInfo skewed = sd.getSkewedInfo();
            if (skewed.getSkewedColNames() != null) {
                TreeSet colnames = new TreeSet(skewed.getSkewedColNames());
                for (String colname : colnames) {
                    md.update(colname.getBytes(ENCODING));
                }
            }
            if (skewed.getSkewedColValues() != null) {
                TreeSet<String> sortedOuterList = new TreeSet<String>();
                for (List innerList : skewed.getSkewedColValues()) {
                    TreeSet sortedInnerList = new TreeSet(innerList);
                    sortedOuterList.add(StringUtils.join(sortedInnerList, (String)"."));
                }
                for (String colval : sortedOuterList) {
                    md.update(colval.getBytes(ENCODING));
                }
            }
            if (skewed.getSkewedColValueLocationMaps() != null) {
                TreeMap<String, String> sortedMap = new TreeMap<String, String>();
                for (Map.Entry smap : skewed.getSkewedColValueLocationMaps().entrySet()) {
                    TreeSet sortedKey = new TreeSet((Collection)smap.getKey());
                    sortedMap.put(StringUtils.join(sortedKey, (String)"."), (String)smap.getValue());
                }
                for (Map.Entry e : sortedMap.entrySet()) {
                    md.update(((String)e.getKey()).getBytes(ENCODING));
                    md.update(((String)e.getValue()).getBytes(ENCODING));
                }
            }
            md.update(sd.isStoredAsSubDirectories() ? "true".getBytes(ENCODING) : "false".getBytes(ENCODING));
        }
        return md.digest();
    }

    public static boolean validateColumnName(String name) {
        return true;
    }

    static boolean containsAllFastStats(Map<String, String> partParams) {
        for (String stat : StatsSetupConst.FAST_STATS) {
            if (partParams.containsKey(stat)) continue;
            return false;
        }
        return true;
    }

    public static boolean isFastStatsSame(Partition oldPart, Partition newPart) {
        if (oldPart != null && oldPart.isSetParameters() && newPart != null && newPart.isSetParameters()) {
            for (String stat : StatsSetupConst.FAST_STATS) {
                if (oldPart.getParameters().containsKey(stat) && newPart.getParameters().containsKey(stat)) {
                    Long oldStat = Long.parseLong((String)oldPart.getParameters().get(stat));
                    String newStat = (String)newPart.getParameters().get(stat);
                    if (newStat != null && oldStat.equals(Long.parseLong(newStat))) continue;
                    return false;
                }
                return false;
            }
            return true;
        }
        return false;
    }

    public static void updateTableStatsSlow(Database db, Table tbl, Warehouse wh, boolean newDir, boolean forceRecompute, EnvironmentContext environmentContext) throws MetaException {
        boolean populateQuickStats;
        HashMap<String, String> params = tbl.getParameters();
        boolean updateStats = true;
        if (params != null && params.containsKey("DO_NOT_UPDATE_STATS")) {
            updateStats = Boolean.valueOf((String)params.get("DO_NOT_UPDATE_STATS")) == false;
            params.remove("DO_NOT_UPDATE_STATS");
        }
        if (!updateStats || newDir || tbl.getPartitionKeysSize() != 0) {
            return;
        }
        if (!forceRecompute && params != null && MetaStoreServerUtils.containsAllFastStats((Map<String, String>)params)) {
            return;
        }
        if (params == null) {
            params = new HashMap<String, String>();
            tbl.setParameters(params);
        }
        boolean bl = populateQuickStats = environmentContext == null || !environmentContext.isSetProperties() || !"true".equals(environmentContext.getProperties().get("DO_NOT_POPULATE_QUICK_STATS"));
        if (populateQuickStats) {
            List fileStatus = wh.getFileStatusesForUnpartitionedTable(db, tbl);
            LOG.info("Updating table stats for {}", (Object)tbl.getTableName());
            MetaStoreServerUtils.populateQuickStats(fileStatus, params);
        }
        LOG.info("Updated size of table {} to {}", (Object)tbl.getTableName(), params.get("totalSize"));
        if (environmentContext != null && environmentContext.isSetProperties() && "TASK".equals(environmentContext.getProperties().get("STATS_GENERATED"))) {
            StatsSetupConst.setBasicStatsState(params, (String)"true");
        } else {
            StatsSetupConst.setBasicStatsState(params, (String)"false");
        }
    }

    public static void populateQuickStats(List<FileStatus> fileStatus, Map<String, String> params) {
        LOG.trace("Populating quick stats based on {} files", (Object)fileStatus.size());
        int numFiles = 0;
        long tableSize = 0L;
        int numErasureCodedFiles = 0;
        for (FileStatus status : fileStatus) {
            if (status.isDir()) continue;
            tableSize += status.getLen();
            ++numFiles;
            if (!status.isErasureCoded()) continue;
            ++numErasureCodedFiles;
        }
        params.put("numFiles", Integer.toString(numFiles));
        params.put("totalSize", Long.toString(tableSize));
        params.put("numFilesErasureCoded", Integer.toString(numErasureCodedFiles));
    }

    public static void clearQuickStats(Map<String, String> params) {
        params.remove("numFiles");
        params.remove("totalSize");
        params.remove("numFilesErasureCoded");
    }

    public static void updateTableStatsForCreateTable(Warehouse wh, Database db, Table tbl, EnvironmentContext envContext, Configuration conf, Path tblPath, boolean newDir) throws MetaException {
        ByteBuffer buffer;
        List values;
        if (MetaStoreUtils.isView((Table)tbl)) {
            return;
        }
        assert (tblPath != null);
        if (tbl.isSetDictionary() && tbl.getDictionary().getValues() != null && (values = (List)tbl.getDictionary().getValues().remove("setStatsStateForCreateTable")) != null && values.size() > 0 && (buffer = (ByteBuffer)values.get(0)).hasArray()) {
            String val = new String(buffer.array(), StandardCharsets.UTF_8);
            StatsSetupConst.ColumnStatsSetup statsSetup = StatsSetupConst.ColumnStatsSetup.parseStatsSetup((String)val);
            if (statsSetup.enabled) {
                try {
                    if (newDir || statsSetup.isIcebergTable || wh.isEmptyDir(tblPath, FileUtils.HIDDEN_FILES_PATH_FILTER)) {
                        List<String> columns = statsSetup.columnNames;
                        if (columns == null || columns.isEmpty()) {
                            columns = MetaStoreServerUtils.getColumnNames(tbl.getSd().getCols());
                        }
                        StatsSetupConst.setStatsStateForCreateTable((Map)tbl.getParameters(), columns, (String)"true");
                    }
                }
                catch (IOException e) {
                    LOG.error("Error while checking the table directory: " + String.valueOf(tblPath), (Throwable)e);
                    throw ExceptionHandler.newMetaException(e);
                }
            }
        }
        if (MetastoreConf.getBoolVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.STATS_AUTO_GATHER) && !MetaStoreServerUtils.getBooleanEnvProp(envContext, "DO_NOT_UPDATE_STATS")) {
            LOG.debug("Calling updateTableStatsSlow for table {}.{}.{}", new Object[]{tbl.getCatName(), tbl.getDbName(), tbl.getTableName()});
            MetaStoreServerUtils.updateTableStatsSlow(db, tbl, wh, newDir, false, envContext);
        }
    }

    public static boolean getBooleanEnvProp(EnvironmentContext envContext, String key) {
        return Optional.ofNullable(envContext).map(EnvironmentContext::getProperties).map(props -> props.getOrDefault(key, "false")).map(Boolean::parseBoolean).orElse(false);
    }

    public static boolean areSameColumns(List<FieldSchema> oldCols, List<FieldSchema> newCols) {
        if (oldCols == newCols) {
            return true;
        }
        if (oldCols == null || newCols == null || oldCols.size() != newCols.size()) {
            return false;
        }
        List transformedOldCols = oldCols.stream().map(col -> new FieldSchema(col.getName().toLowerCase(), col.getType(), col.getComment())).collect(Collectors.toList());
        List transformedNewCols = newCols.stream().map(col -> new FieldSchema(col.getName().toLowerCase(), col.getType(), col.getComment())).collect(Collectors.toList());
        return ListUtils.isEqualList(transformedOldCols, transformedNewCols);
    }

    public static boolean arePrefixColumns(List<FieldSchema> p, List<FieldSchema> s) {
        if (p == s) {
            return true;
        }
        if (p == null || s == null || p.size() > s.size()) {
            return false;
        }
        return MetaStoreServerUtils.areSameColumns(p, s.subList(0, p.size()));
    }

    public static void updateBasicState(EnvironmentContext environmentContext, Map<String, String> params) {
        if (params == null) {
            return;
        }
        if (environmentContext != null && environmentContext.isSetProperties() && "TASK".equals(environmentContext.getProperties().get("STATS_GENERATED"))) {
            StatsSetupConst.setBasicStatsState(params, (String)"true");
        } else {
            StatsSetupConst.setBasicStatsState(params, (String)"false");
        }
    }

    public static boolean updatePartitionStatsFast(Partition part, Table tbl, Warehouse wh, boolean madeDir, boolean forceRecompute, EnvironmentContext environmentContext, boolean isCreate) throws MetaException {
        return MetaStoreServerUtils.updatePartitionStatsFast((PartitionSpecProxy.PartitionIterator)new PartitionSpecProxy.SimplePartitionWrapperIterator(part), tbl, wh, madeDir, forceRecompute, environmentContext, isCreate);
    }

    public static boolean updatePartitionStatsFast(PartitionSpecProxy.PartitionIterator part, Table table, Warehouse wh, boolean madeDir, boolean forceRecompute, EnvironmentContext environmentContext, boolean isCreate) throws MetaException {
        HashMap<String, String> params = part.getParameters();
        if (!forceRecompute && params != null && MetaStoreServerUtils.containsAllFastStats((Map<String, String>)params)) {
            return false;
        }
        if (params == null) {
            params = new HashMap<String, String>();
        }
        if (!isCreate && MetaStoreServerUtils.isTransactionalTable(table.getParameters())) {
            LOG.warn("Not updating fast stats for a transactional table " + table.getTableName());
            part.setParameters(params);
            return true;
        }
        if (!madeDir) {
            LOG.info("Updating partition stats fast for: catalog: {} database: {} table: {} partition: {}", new Object[]{part.getCatName(), part.getDbName(), part.getTableName(), part.getCurrent().getValues()});
            List fileStatus = wh.getFileStatusesForLocation(part.getLocation());
            MetaStoreServerUtils.populateQuickStats(fileStatus, params);
            LOG.info("Updated size to {}", params.get("totalSize"));
            MetaStoreServerUtils.updateBasicState(environmentContext, params);
        }
        part.setParameters(params);
        return true;
    }

    public static List<String> findStaleColumns(List<FieldSchema> oldCols, List<FieldSchema> newCols) {
        HashMap<String, String> columnNameTypePairMap = new HashMap<String, String>(newCols.size());
        for (FieldSchema newCol : newCols) {
            columnNameTypePairMap.put(newCol.getName().toLowerCase(), newCol.getType());
        }
        ArrayList<String> changedCols = new ArrayList<String>();
        for (FieldSchema oldCol : oldCols) {
            if (columnNameTypePairMap.containsKey(oldCol.getName()) && ((String)columnNameTypePairMap.get(oldCol.getName())).equalsIgnoreCase(oldCol.getType())) continue;
            changedCols.add(oldCol.getName());
        }
        return changedCols;
    }

    public static boolean isTransactionalTable(Map<String, String> params) {
        String transactionalProp = params.get("transactional");
        return "true".equalsIgnoreCase(transactionalProp);
    }

    public static <T> List<T> getMetaStoreListeners(Class<T> clazz, Configuration conf, String listenerImplList) throws MetaException {
        String[] listenerImpls;
        ArrayList listeners = new ArrayList();
        if (StringUtils.isBlank((CharSequence)listenerImplList)) {
            return listeners;
        }
        for (String listenerImpl : listenerImpls = listenerImplList.split(",")) {
            try {
                Object listener = Class.forName(listenerImpl.trim(), true, JavaUtils.getClassLoader()).getConstructor(Configuration.class).newInstance(conf);
                listeners.add(listener);
            }
            catch (InvocationTargetException ie) {
                LOG.error("Got InvocationTargetException", (Throwable)ie);
                throw new MetaException("Failed to instantiate listener named: " + listenerImpl + ", reason: " + String.valueOf(ie.getCause()));
            }
            catch (Exception e) {
                LOG.error("Got Exception", (Throwable)e);
                throw new MetaException("Failed to instantiate listener named: " + listenerImpl + ", reason: " + String.valueOf(e));
            }
        }
        return listeners;
    }

    public static String validateSkewedColNames(List<String> cols) {
        if (CollectionUtils.isEmpty(cols)) {
            return null;
        }
        for (String col : cols) {
            if (MetaStoreServerUtils.validateColumnName(col)) continue;
            return col;
        }
        return null;
    }

    public static String validateSkewedColNamesSubsetCol(List<String> skewedColNames, List<FieldSchema> cols) {
        if (CollectionUtils.isEmpty(skewedColNames)) {
            return null;
        }
        ArrayList<String> colNames = new ArrayList<String>(cols.size());
        for (FieldSchema fieldSchema : cols) {
            colNames.add(fieldSchema.getName());
        }
        ArrayList<String> copySkewedColNames = new ArrayList<String>(skewedColNames);
        copySkewedColNames.removeAll(colNames);
        if (copySkewedColNames.isEmpty()) {
            return null;
        }
        return ((Object)copySkewedColNames).toString();
    }

    public static boolean partitionNameHasValidCharacters(List<String> partVals, Configuration conf) {
        return MetaStoreServerUtils.getPartitionValWithInvalidCharacter(partVals, MetaStoreServerUtils.getPartitionValidationRegex(conf)) == null;
    }

    public static void getMergableCols(ColumnStatistics csNew, Map<String, String> parameters) {
        ArrayList<ColumnStatisticsObj> list = new ArrayList<ColumnStatisticsObj>();
        for (int index = 0; index < csNew.getStatsObj().size(); ++index) {
            ColumnStatisticsObj statsObjNew = (ColumnStatisticsObj)csNew.getStatsObj().get(index);
            if (!StatsSetupConst.canColumnStatsMerge(parameters, (String)statsObjNew.getColName())) continue;
            list.add(statsObjNew);
        }
        csNew.setStatsObj(list);
    }

    public static void mergeColStats(ColumnStatistics csNew, ColumnStatistics csOld) throws InvalidObjectException {
        ArrayList<ColumnStatisticsObj> list = new ArrayList<ColumnStatisticsObj>();
        if (csNew.getStatsObj().size() != csOld.getStatsObjSize()) {
            LOG.debug("New ColumnStats size is {}, but old ColumnStats size is {}", (Object)csNew.getStatsObj().size(), (Object)csOld.getStatsObjSize());
        }
        HashMap<String, ColumnStatisticsObj> map = new HashMap<String, ColumnStatisticsObj>();
        for (ColumnStatisticsObj obj : csOld.getStatsObj()) {
            map.put(obj.getColName(), obj);
        }
        for (int index = 0; index < csNew.getStatsObj().size(); ++index) {
            ColumnStatisticsObj statsObjNew = (ColumnStatisticsObj)csNew.getStatsObj().get(index);
            ColumnStatisticsObj statsObjOld = (ColumnStatisticsObj)map.get(statsObjNew.getColName());
            if (statsObjOld != null) {
                assert (statsObjNew.getStatsData().getSetField() == statsObjOld.getStatsData().getSetField());
                ColumnStatsMerger<?> merger = ColumnStatsMergerFactory.getColumnStatsMerger(statsObjNew, statsObjOld);
                merger.merge(statsObjNew, statsObjOld);
            }
            list.add(statsObjNew);
        }
        csNew.setStatsObj(list);
    }

    public static boolean checkUserHasHostProxyPrivileges(String user, Configuration conf, String ipAddress) {
        DefaultImpersonationProvider sip = ProxyUsers.getDefaultImpersonationProvider();
        if (sip == null) {
            ProxyUsers.refreshSuperUserGroupsConfiguration((Configuration)conf);
            sip = ProxyUsers.getDefaultImpersonationProvider();
        }
        Map proxyHosts = sip.getProxyHosts();
        Collection hostEntries = (Collection)proxyHosts.get(sip.getProxySuperuserIpConfKey(user));
        MachineList machineList = new MachineList(hostEntries);
        if (ipAddress == null) {
            try {
                ipAddress = InetAddress.getLocalHost().getHostAddress();
            }
            catch (UnknownHostException e) {
                ipAddress = "";
            }
        }
        return machineList.includes(ipAddress);
    }

    public static int startMetaStore() throws Exception {
        return MetaStoreServerUtils.startMetaStore(HadoopThriftAuthBridge.getBridge(), null);
    }

    public static int startMetaStore(HadoopThriftAuthBridge bridge, Configuration conf) throws Exception {
        int port = MetaStoreServerUtils.findFreePort();
        MetaStoreServerUtils.startMetaStore(port, bridge, conf);
        return port;
    }

    public static int startMetaStore(Configuration conf) throws Exception {
        return MetaStoreServerUtils.startMetaStore(HadoopThriftAuthBridge.getBridge(), conf);
    }

    public static void startMetaStore(int port, HadoopThriftAuthBridge bridge) throws Exception {
        MetaStoreServerUtils.startMetaStore(port, bridge, null);
    }

    public static void startMetaStore(final int port, final HadoopThriftAuthBridge bridge, Configuration hiveConf) throws Exception {
        if (hiveConf == null) {
            hiveConf = MetastoreConf.newMetastoreConf();
        }
        final Configuration finalHiveConf = hiveConf;
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    HiveMetaStore.startMetaStore(port, bridge, finalHiveConf);
                }
                catch (Throwable e) {
                    LOG.error("Metastore Thrift Server threw an exception...", e);
                }
            }
        });
        thread.setDaemon(true);
        thread.start();
        MetaStoreServerUtils.loopUntilHMSReady(port);
    }

    private static void loopUntilHMSReady(int port) throws Exception {
        int retries = 0;
        while (true) {
            try {
                Socket socket = new Socket();
                socket.connect(new InetSocketAddress(port), 5000);
                socket.close();
                return;
            }
            catch (Exception e) {
                if (retries++ <= 60) {
                    Thread.sleep(1000L);
                    continue;
                }
                Exception exc = e;
                LOG.error("Unable to connect to metastore server: " + exc.getMessage());
                LOG.info("Printing all thread stack traces for debugging before throwing exception.");
                LOG.info(MetaStoreServerUtils.getAllThreadStacksAsString());
                throw exc;
            }
            break;
        }
    }

    private static String getAllThreadStacksAsString() {
        Map<Thread, StackTraceElement[]> threadStacks = Thread.getAllStackTraces();
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<Thread, StackTraceElement[]> entry : threadStacks.entrySet()) {
            Thread t = entry.getKey();
            sb.append(System.lineSeparator());
            sb.append("Name: ").append(t.getName()).append(" State: ").append((Object)t.getState());
            MetaStoreServerUtils.addStackString(entry.getValue(), sb);
        }
        return sb.toString();
    }

    private static void addStackString(StackTraceElement[] stackElems, StringBuilder sb) {
        sb.append(System.lineSeparator());
        for (StackTraceElement stackElem : stackElems) {
            sb.append(stackElem).append(System.lineSeparator());
        }
    }

    public static int findFreePort() throws IOException {
        ServerSocket socket = new ServerSocket(0);
        int port = socket.getLocalPort();
        socket.close();
        return port;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int findFreePortExcepting(int portToExclude) throws IOException {
        ServerSocket socket1 = null;
        ServerSocket socket2 = null;
        try {
            socket1 = new ServerSocket(0);
            socket2 = new ServerSocket(0);
            if (socket1.getLocalPort() != portToExclude) {
                int n = socket1.getLocalPort();
                return n;
            }
            int n = socket2.getLocalPort();
            return n;
        }
        finally {
            if (socket1 != null) {
                socket1.close();
            }
            if (socket2 != null) {
                socket2.close();
            }
        }
    }

    public static String validateTblColumns(List<FieldSchema> cols) {
        for (FieldSchema fieldSchema : cols) {
            String typeError = MetaStoreServerUtils.validateColumnType(fieldSchema.getType());
            if (typeError == null) continue;
            return typeError;
        }
        return null;
    }

    private static String validateColumnType(String type) {
        if (type.equals("<derived from deserializer>")) {
            return null;
        }
        int last = 0;
        boolean lastAlphaDigit = MetaStoreServerUtils.isValidTypeChar(type.charAt(last));
        for (int i = 1; i <= type.length(); ++i) {
            if (i != type.length() && MetaStoreServerUtils.isValidTypeChar(type.charAt(i)) == lastAlphaDigit) continue;
            String token = type.substring(last, i);
            last = i;
            if (ColumnType.AllTypes.contains(token)) break;
            return "type: " + type;
        }
        return null;
    }

    private static boolean isValidTypeChar(char c) {
        return Character.isLetterOrDigit(c) || c == '_';
    }

    public static boolean requireCalStats(Partition oldPart, Partition newPart, Table tbl, EnvironmentContext environmentContext) {
        String statsType;
        if (environmentContext != null && environmentContext.isSetProperties() && "true".equals(environmentContext.getProperties().get("DO_NOT_UPDATE_STATS"))) {
            return false;
        }
        if (MetaStoreUtils.isView((Table)tbl)) {
            return false;
        }
        if (oldPart == null && newPart == null) {
            return true;
        }
        if (newPart == null || newPart.getParameters() == null || !MetaStoreServerUtils.containsAllFastStats(newPart.getParameters())) {
            return true;
        }
        if (environmentContext != null && environmentContext.isSetProperties() && ("TASK".equals(statsType = (String)environmentContext.getProperties().get("STATS_GENERATED")) || "USER".equals(statsType))) {
            return true;
        }
        return !MetaStoreServerUtils.isFastStatsSame(oldPart, newPart);
    }

    public static String getTokenStoreClassName(Configuration conf) {
        String tokenStoreClass = conf.get(DELEGATION_TOKEN_STORE_CLS, "");
        if (StringUtils.isBlank((CharSequence)tokenStoreClass)) {
            return MemoryTokenStore.class.getName();
        }
        switch (tokenStoreClass) {
            case "org.apache.hadoop.hive.thrift.DBTokenStore": {
                return DBTokenStore.class.getName();
            }
            case "org.apache.hadoop.hive.thrift.MemoryTokenStore": {
                return MemoryTokenStore.class.getName();
            }
            case "org.apache.hadoop.hive.thrift.ZooKeeperTokenStore": {
                return ZooKeeperTokenStore.class.getName();
            }
        }
        return tokenStoreClass;
    }

    public static List<PartitionSpec> getPartitionspecsGroupedByStorageDescriptor(Table table, Collection<Partition> partitions) {
        String tablePath = table.getSd().getLocation();
        ImmutableListMultimap partitionsWithinTableDirectory = Multimaps.index(partitions, input -> {
            if (input.getSd() == null) {
                return StorageDescriptorKey.UNSET_KEY;
            }
            if (input.getSd().getSkewedInfo() != null && input.getSd().getSkewedInfo().getSkewedColNames() != null && !input.getSd().getSkewedInfo().getSkewedColNames().isEmpty()) {
                return new StorageDescriptorKey(input.getSd());
            }
            if (input.getSd().getNumBuckets() != ((Partition)partitions.iterator().next()).getSd().getNumBuckets()) {
                return new StorageDescriptorKey(input.getSd());
            }
            if (input.getSd().getLocation() != null && input.getSd().getLocation().startsWith(tablePath)) {
                return new StorageDescriptorKey(tablePath, input.getSd());
            }
            return new StorageDescriptorKey(input.getSd());
        });
        ArrayList<PartitionSpec> partSpecs = new ArrayList<PartitionSpec>();
        HashMap sdToPartList = new HashMap();
        ArrayList partitionsOutsideTableDir = new ArrayList(0);
        for (StorageDescriptorKey storageDescriptorKey : partitionsWithinTableDirectory.keySet()) {
            boolean isUnsetKey = storageDescriptorKey.equals(StorageDescriptorKey.UNSET_KEY);
            if (isUnsetKey || storageDescriptorKey.baseLocation == null || storageDescriptorKey.baseLocation.equals(tablePath)) {
                for (Partition partition : partitionsWithinTableDirectory.get((Object)storageDescriptorKey)) {
                    PartitionWithoutSD partitionWithoutSD = new PartitionWithoutSD();
                    partitionWithoutSD.setValues(partition.getValues());
                    partitionWithoutSD.setCreateTime(partition.getCreateTime());
                    partitionWithoutSD.setLastAccessTime(partition.getLastAccessTime());
                    partitionWithoutSD.setRelativePath(isUnsetKey || !partition.getSd().isSetLocation() ? null : partition.getSd().getLocation().substring(tablePath.length()));
                    partitionWithoutSD.setParameters(partition.getParameters());
                    if (!sdToPartList.containsKey(storageDescriptorKey)) {
                        sdToPartList.put(storageDescriptorKey, new ArrayList());
                    }
                    ((List)sdToPartList.get(storageDescriptorKey)).add(partitionWithoutSD);
                }
                continue;
            }
            partitionsOutsideTableDir.addAll(partitionsWithinTableDirectory.get((Object)storageDescriptorKey));
        }
        for (Map.Entry entry : sdToPartList.entrySet()) {
            partSpecs.add(MetaStoreServerUtils.getSharedSDPartSpec(table, (StorageDescriptorKey)entry.getKey(), (List)entry.getValue()));
        }
        if (!partitionsOutsideTableDir.isEmpty()) {
            PartitionSpec partListSpec = new PartitionSpec();
            partListSpec.setCatName(table.getCatName());
            partListSpec.setDbName(table.getDbName());
            partListSpec.setTableName(table.getTableName());
            partListSpec.setPartitionList(new PartitionListComposingSpec(partitionsOutsideTableDir));
            partSpecs.add(partListSpec);
        }
        return partSpecs;
    }

    private static PartitionSpec getSharedSDPartSpec(Table table, StorageDescriptorKey sdKey, List<PartitionWithoutSD> partitions) {
        StorageDescriptor sd;
        if (sdKey.getSd() == null) {
            sd = new StorageDescriptor();
        } else {
            sd = new StorageDescriptor(sdKey.getSd());
            sd.setLocation(sdKey.baseLocation);
        }
        PartitionSpecWithSharedSD sharedSDPartSpec = new PartitionSpecWithSharedSD();
        sharedSDPartSpec.setPartitions(partitions);
        sharedSDPartSpec.setSd(sd);
        PartitionSpec ret = new PartitionSpec();
        ret.setRootPath(sd.getLocation());
        ret.setSharedSDPartitionSpec(sharedSDPartSpec);
        ret.setDbName(table.getDbName());
        ret.setTableName(table.getTableName());
        ret.setCatName(table.getCatName());
        return ret;
    }

    public static void setNestedProperty(Object bean, String propertyName, Object value, boolean instantiateMissingFields) throws MetaException {
        try {
            String[] nestedFields = propertyName.split("\\.");
            if (nestedFields.length > 1 && instantiateMissingFields) {
                StringBuilder fieldNameBuilder = new StringBuilder();
                for (int level = 0; level < nestedFields.length - 1; ++level) {
                    fieldNameBuilder.append(nestedFields[level]);
                    String currentFieldName = fieldNameBuilder.toString();
                    Object fieldVal = PropertyUtils.getProperty((Object)bean, (String)currentFieldName);
                    if (fieldVal == null) {
                        PropertyDescriptor fieldDescriptor = PropertyUtils.getPropertyDescriptor((Object)bean, (String)currentFieldName);
                        Object defaultInstance = fieldDescriptor.getPropertyType().newInstance();
                        PropertyUtils.setNestedProperty((Object)bean, (String)currentFieldName, defaultInstance);
                    }
                    fieldNameBuilder.append('.');
                }
            }
            PropertyUtils.setNestedProperty((Object)bean, (String)propertyName, (Object)value);
        }
        catch (Exception e) {
            LOG.error("Failed to set nested property", (Throwable)e);
            throw new MetaException(e.getMessage());
        }
    }

    public static String anonymizeConnectionURL(String connectionURL) {
        if (connectionURL == null) {
            return null;
        }
        CharSequence[] sensitiveData = new String[]{"user", "password"};
        String regex = "([;,?&\\(]" + String.join((CharSequence)"|", sensitiveData) + ")=.*?([;,&\\)]|$)";
        return connectionURL.replaceAll(regex, "$1=****$2");
    }

    public static Path getPath(Table table) {
        String location = table.getSd().getLocation();
        if (location == null) {
            return null;
        }
        return new Path(location);
    }

    public static List<Partition> getAllPartitionsOf(IMetaStoreClient msc, Table table) throws MetastoreException {
        try {
            return msc.listPartitions(table.getCatName(), table.getDbName(), table.getTableName(), -1);
        }
        catch (Exception e) {
            throw new MetastoreException((Throwable)e);
        }
    }

    public static List<Partition> getPartitionsByProjectSpec(IMetaStoreClient msc, GetPartitionsRequest request) throws MetastoreException {
        try {
            GetPartitionsResponse response = msc.getPartitionsWithSpecs(request);
            List partitionSpecList = response.getPartitionSpec();
            ArrayList<Partition> result = new ArrayList<Partition>();
            for (PartitionSpec spec : partitionSpecList) {
                PartitionSpecWithSharedSD pSpecWithSharedSD;
                if (spec.getPartitionList() != null && spec.getPartitionList().getPartitions() != null) {
                    spec.getPartitionList().getPartitions().forEach(partition -> {
                        partition.setCatName(spec.getCatName());
                        partition.setDbName(spec.getDbName());
                        partition.setTableName(spec.getTableName());
                        result.add((Partition)partition);
                    });
                }
                if ((pSpecWithSharedSD = spec.getSharedSDPartitionSpec()) == null) continue;
                List withoutSDList = pSpecWithSharedSD.getPartitions();
                StorageDescriptor descriptor = pSpecWithSharedSD.getSd();
                if (withoutSDList == null) continue;
                for (PartitionWithoutSD psd : withoutSDList) {
                    StorageDescriptor newSD = new StorageDescriptor(descriptor);
                    Partition partition2 = new Partition(psd.getValues(), spec.getDbName(), spec.getTableName(), psd.getCreateTime(), psd.getLastAccessTime(), newSD, psd.getParameters());
                    partition2.getSd().setLocation(newSD.getLocation() + psd.getRelativePath());
                    result.add(partition2);
                }
            }
            return result;
        }
        catch (Exception e) {
            throw new MetastoreException((Throwable)e);
        }
    }

    public static void getPartitionListByFilterExp(IMetaStoreClient msc, Table table, byte[] filterExp, String defaultPartName, List<Partition> results) throws MetastoreException {
        try {
            msc.listPartitionsByExpr(table.getCatName(), table.getDbName(), table.getTableName(), filterExp, defaultPartName, -1, results);
        }
        catch (Exception e) {
            throw new MetastoreException((Throwable)e);
        }
    }

    public static boolean isPartitioned(Table table) {
        if (MetaStoreServerUtils.getPartCols(table) == null) {
            return false;
        }
        return MetaStoreServerUtils.getPartCols(table).size() != 0;
    }

    public static List<FieldSchema> getPartCols(Table table) {
        ArrayList partKeys = table.getPartitionKeys();
        if (partKeys == null) {
            partKeys = new ArrayList();
            table.setPartitionKeys(partKeys);
        }
        return partKeys;
    }

    public static List<String> getPartColNames(Table table) {
        ArrayList<String> partColNames = new ArrayList<String>();
        for (FieldSchema key : MetaStoreServerUtils.getPartCols(table)) {
            partColNames.add(key.getName());
        }
        return partColNames;
    }

    public static Path getDataLocation(Table table, Partition partition) {
        if (MetaStoreServerUtils.isPartitioned(table)) {
            if (partition.getSd() == null) {
                return null;
            }
            return new Path(partition.getSd().getLocation());
        }
        if (table.getSd() == null) {
            return null;
        }
        return MetaStoreServerUtils.getPath(table);
    }

    public static String getPartitionName(Table table, Partition partition) {
        try {
            return Warehouse.makePartName(MetaStoreServerUtils.getPartCols(table), (List)partition.getValues());
        }
        catch (MetaException e) {
            throw new RuntimeException("Invalid partition found, location: " + String.valueOf(MetaStoreServerUtils.getDataLocation(table, partition)), e);
        }
    }

    public static Map<String, String> getPartitionSpec(Table table, Partition partition) {
        return Warehouse.makeSpecFromValues(MetaStoreServerUtils.getPartCols(table), (List)partition.getValues());
    }

    public static Partition getPartition(IMetaStoreClient msc, Table tbl, Map<String, String> partSpec) throws MetastoreException {
        ArrayList<String> pvals = new ArrayList<String>();
        for (FieldSchema field : MetaStoreServerUtils.getPartCols(tbl)) {
            String val = partSpec.get(field.getName());
            pvals.add(val);
        }
        Partition tpart = null;
        try {
            tpart = msc.getPartition(tbl.getCatName(), tbl.getDbName(), tbl.getTableName(), pvals);
        }
        catch (NoSuchObjectException field) {
        }
        catch (Exception e) {
            LOG.error("Failed to get partition", (Throwable)e);
            throw new MetastoreException((Throwable)e);
        }
        return tpart;
    }

    public static String getPartitionName(Path tablePath, Path partitionPath, Set<String> partCols, Map<String, String> partitionColToTypeMap, Configuration conf) {
        StringBuilder result = null;
        LOG.debug("tablePath:" + String.valueOf(tablePath) + ", partCols: " + String.valueOf(partCols));
        for (Path currPath = partitionPath; currPath != null && !tablePath.equals((Object)currPath); currPath = currPath.getParent()) {
            String[] parts = currPath.getName().split("=");
            if (parts.length > 0) {
                if (parts.length != 2) {
                    LOG.warn(currPath.getName() + " is not a valid partition name");
                    return result.toString();
                }
                String partitionName = parts[0].toLowerCase();
                String partitionValue = parts[1];
                if (partCols.contains(partitionName)) {
                    String normalisedPartitionValue = MetaStoreServerUtils.getNormalisedPartitionValue(partitionValue, partitionColToTypeMap.get(partitionName), conf);
                    if (normalisedPartitionValue == null) {
                        return null;
                    }
                    if (result == null) {
                        result = new StringBuilder(partitionName + "=" + normalisedPartitionValue);
                    } else {
                        result.insert(0, partitionName + "=" + normalisedPartitionValue + "/");
                    }
                }
            }
            LOG.debug("currPath=" + String.valueOf(currPath));
        }
        return result == null ? null : result.toString();
    }

    public static String getNormalisedPartitionValue(String partitionValue, String type, Configuration conf) {
        block22: {
            if (type == null) {
                return partitionValue;
            }
            if (Objects.equals(partitionValue, MetastoreConf.getVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.DEFAULTPARTITIONNAME))) {
                return partitionValue;
            }
            String colType = ColumnType.getTypeName((String)type);
            if (!ColumnType.NumericTypes.contains(colType)) {
                return partitionValue;
            }
            LOG.debug("Normalizing partition value '{}' for type '{}'.", (Object)partitionValue, (Object)type);
            try {
                switch (colType) {
                    case "tinyint": 
                    case "smallint": 
                    case "int": {
                        return Integer.toString(Integer.parseInt(partitionValue));
                    }
                    case "bigint": {
                        return Long.toString(Long.parseLong(partitionValue));
                    }
                    case "float": {
                        return Float.toString(Float.parseFloat(partitionValue));
                    }
                    case "double": {
                        return Double.toString(Double.parseDouble(partitionValue));
                    }
                    case "decimal": {
                        return new BigDecimal(partitionValue).stripTrailingZeros().toPlainString();
                    }
                }
            }
            catch (NumberFormatException e) {
                String validationMode = MetastoreConf.getVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.MSCK_PATH_VALIDATION);
                if ("throw".equals(validationMode)) {
                    LOG.error("Invalid partition value: Cannot parse '{}' as type '{}'. Failing MSCK. Set hive.msck.path.validation=skip to ignore invalid partitions.", (Object)partitionValue, (Object)type);
                    throw e;
                }
                if (!"skip".equals(validationMode)) break block22;
                LOG.warn("Skipping invalid partition value '{}' for type '{}' due to parsing error.", (Object)partitionValue, (Object)type);
                return null;
            }
        }
        return partitionValue;
    }

    public static Map<String, String> getPartitionColtoTypeMap(List<FieldSchema> partitionCols) {
        HashMap<String, String> typeMap = new HashMap<String, String>();
        if (partitionCols != null) {
            for (FieldSchema fSchema : partitionCols) {
                typeMap.put(fSchema.getName(), fSchema.getType());
            }
        }
        return typeMap;
    }

    public static Partition createMetaPartitionObject(Table tbl, Map<String, String> partSpec, Path location) throws MetastoreException {
        ArrayList<String> pvals = new ArrayList<String>();
        for (FieldSchema field : MetaStoreServerUtils.getPartCols(tbl)) {
            String val = partSpec.get(field.getName());
            if (val == null || val.isEmpty()) {
                throw new MetastoreException("partition spec is invalid; field " + field.getName() + " does not exist or is empty");
            }
            pvals.add(val);
        }
        Partition tpart = new Partition();
        tpart.setCatName(tbl.getCatName());
        tpart.setDbName(tbl.getDbName());
        tpart.setTableName(tbl.getTableName());
        tpart.setValues(pvals);
        if (!MetaStoreUtils.isView((Table)tbl)) {
            tpart.setSd(tbl.getSd().deepCopy());
            tpart.getSd().setLocation(location != null ? location.toString() : null);
        }
        return tpart;
    }

    public static List<String> validateBucketColumns(StorageDescriptor sd) {
        List bucketColumnNames = null;
        if (CollectionUtils.isNotEmpty((Collection)sd.getBucketCols())) {
            bucketColumnNames = sd.getBucketCols().stream().map(String::toLowerCase).collect(Collectors.toList());
            List<String> columnNames = MetaStoreServerUtils.getColumnNames(sd.getCols());
            if (CollectionUtils.isNotEmpty(columnNames)) {
                bucketColumnNames.removeAll(columnNames);
            }
        }
        return bucketColumnNames;
    }

    public static List<String> getColumnNames(List<FieldSchema> cols) {
        if (CollectionUtils.isNotEmpty(cols)) {
            return cols.stream().map(FieldSchema::getName).map(String::toLowerCase).collect(Collectors.toList());
        }
        return null;
    }

    public static boolean isCompactionTxn(TxnType txnType) {
        return TxnType.COMPACTION.equals((Object)txnType) || TxnType.REBALANCE_COMPACTION.equals((Object)txnType);
    }

    public static class ColStatsObjWithSourceInfo {
        private final ColumnStatisticsObj colStatsObj;
        private final String catName;
        private final String dbName;
        private final String tblName;
        private final String partName;

        public ColStatsObjWithSourceInfo(ColumnStatisticsObj colStatsObj, String catName, String dbName, String tblName, String partName) {
            this.colStatsObj = colStatsObj;
            this.catName = catName;
            this.dbName = dbName;
            this.tblName = tblName;
            this.partName = partName;
        }

        public ColumnStatisticsObj getColStatsObj() {
            return this.colStatsObj;
        }

        public String getCatName() {
            return this.catName;
        }

        public String getDbName() {
            return this.dbName;
        }

        public String getTblName() {
            return this.tblName;
        }

        public String getPartName() {
            return this.partName;
        }
    }

    @VisibleForTesting
    static class StorageDescriptorKey {
        private final StorageDescriptor sd;
        private final String baseLocation;
        private final int hashCode;
        @VisibleForTesting
        static final StorageDescriptorKey UNSET_KEY = new StorageDescriptorKey();

        StorageDescriptorKey(StorageDescriptor sd) {
            this(sd.getLocation(), sd);
        }

        StorageDescriptorKey(String baseLocation, StorageDescriptor sd) {
            this.sd = sd;
            this.baseLocation = baseLocation;
            this.hashCode = sd == null ? Objects.hashCode(baseLocation) : Objects.hash(sd.getSerdeInfo() == null ? null : sd.getSerdeInfo().getSerializationLib(), sd.getInputFormat(), sd.getOutputFormat(), baseLocation, sd.getCols());
        }

        StorageDescriptorKey() {
            this.baseLocation = null;
            this.sd = null;
            this.hashCode = 0;
        }

        StorageDescriptor getSd() {
            return this.sd;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            StorageDescriptorKey that = (StorageDescriptorKey)o;
            if (!Objects.equals(this.baseLocation, that.baseLocation)) {
                return false;
            }
            if (this.sd == null && that.sd == null) {
                return true;
            }
            if (this.sd == null || that.sd == null) {
                return false;
            }
            if (!Objects.equals(this.sd.getOutputFormat(), that.sd.getOutputFormat())) {
                return false;
            }
            if (!Objects.equals(this.sd.getCols(), that.sd.getCols())) {
                return false;
            }
            if (!Objects.equals(this.sd.getInputFormat(), that.sd.getInputFormat())) {
                return false;
            }
            if (!Objects.equals(this.sd.getSerdeInfo(), that.sd.getSerdeInfo())) {
                return false;
            }
            if (this.sd.getSerdeInfo() != null && that.sd.getSerdeInfo() == null) {
                return false;
            }
            if (this.sd.getSerdeInfo() == null && that.sd.getSerdeInfo() != null) {
                return false;
            }
            return this.sd.getSerdeInfo() == null || that.sd.getSerdeInfo() == null || Objects.equals(this.sd.getSerdeInfo().getSerializationLib(), that.sd.getSerdeInfo().getSerializationLib());
        }

        public int hashCode() {
            return this.hashCode;
        }
    }
}

