/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io.parquet.serde;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.ql.ErrorMsg;
import org.apache.hadoop.hive.ql.io.parquet.serde.ArrayWritableObjectInspector;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.optimizer.FieldNode;
import org.apache.hadoop.hive.serde2.AbstractSerDe;
import org.apache.hadoop.hive.serde2.SchemaInference;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.hive.serde2.SerDeSpec;
import org.apache.hadoop.hive.serde2.io.ParquetHiveRecord;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.StructTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;
import org.apache.hadoop.io.ArrayWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.parquet.hadoop.ParquetFileReader;
import org.apache.parquet.hadoop.metadata.FileMetaData;
import org.apache.parquet.hadoop.util.HadoopInputFile;
import org.apache.parquet.io.InputFile;
import org.apache.parquet.schema.GroupType;
import org.apache.parquet.schema.LogicalTypeAnnotation;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.PrimitiveType;
import org.apache.parquet.schema.Type;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SerDeSpec(schemaProps={"columns", "columns.types", "parquet.compression"})
public class ParquetHiveSerDe
extends AbstractSerDe
implements SchemaInference {
    private static final Logger LOG = LoggerFactory.getLogger(ParquetHiveSerDe.class);
    public static final Text MAP_KEY = new Text("key");
    public static final Text MAP_VALUE = new Text("value");
    public static final Text MAP = new Text("map");
    public static final Text ARRAY = new Text("bag");
    public static final Text LIST = new Text("list");
    public static final int[] PRECISION_TO_BYTE_COUNT = new int[38];
    private ObjectInspector objInspector;
    private ParquetHiveRecord parquetRow = new ParquetHiveRecord();

    public void initialize(Configuration configuration, Properties tableProperties, Properties partitionProperties) throws SerDeException {
        Configuration conf;
        String rawPrunedColumnPaths;
        super.initialize(configuration, tableProperties, partitionProperties);
        StructTypeInfo completeTypeInfo = (StructTypeInfo)TypeInfoFactory.getStructTypeInfo((List)this.getColumnNames(), (List)this.getColumnTypes());
        StructTypeInfo prunedTypeInfo = null;
        if (this.configuration.isPresent() && (rawPrunedColumnPaths = (conf = (Configuration)this.configuration.get()).get("hive.io.file.readNestedColumn.paths")) != null) {
            List<String> prunedColumnPaths = ParquetHiveSerDe.processRawPrunedPaths(rawPrunedColumnPaths);
            prunedTypeInfo = ParquetHiveSerDe.pruneFromPaths(completeTypeInfo, prunedColumnPaths);
        }
        this.objInspector = new ArrayWritableObjectInspector(completeTypeInfo, prunedTypeInfo);
    }

    public Object deserialize(Writable blob) throws SerDeException {
        if (blob instanceof ArrayWritable) {
            return blob;
        }
        return null;
    }

    public ObjectInspector getObjectInspector() throws SerDeException {
        return this.objInspector;
    }

    public Class<? extends Writable> getSerializedClass() {
        return ParquetHiveRecord.class;
    }

    public Writable serialize(Object obj, ObjectInspector objInspector) throws SerDeException {
        if (!objInspector.getCategory().equals((Object)ObjectInspector.Category.STRUCT)) {
            throw new SerDeException("Cannot serialize " + String.valueOf(objInspector.getCategory()) + ". Can only serialize a struct");
        }
        this.parquetRow.value = obj;
        this.parquetRow.inspector = (StructObjectInspector)objInspector;
        return this.parquetRow;
    }

    public static boolean isParquetTable(Table table) {
        return table == null ? false : ParquetHiveSerDe.class.getName().equals(table.getSerializationLib());
    }

    private static List<String> processRawPrunedPaths(String prunedPaths) {
        List<FieldNode> fieldNodes = new ArrayList<FieldNode>();
        for (String p : prunedPaths.split(",")) {
            fieldNodes = FieldNode.mergeFieldNodes(fieldNodes, FieldNode.fromPath(p));
        }
        ArrayList<String> prunedPathList = new ArrayList<String>();
        for (FieldNode fn : fieldNodes) {
            prunedPathList.addAll(fn.toPaths());
        }
        return prunedPathList;
    }

    private static StructTypeInfo pruneFromPaths(StructTypeInfo originalTypeInfo, List<String> prunedPaths) {
        PrunedStructTypeInfo prunedTypeInfo = new PrunedStructTypeInfo(originalTypeInfo);
        for (String path : prunedPaths) {
            ParquetHiveSerDe.pruneFromSinglePath(prunedTypeInfo, path);
        }
        return prunedTypeInfo.prune();
    }

    private static void pruneFromSinglePath(PrunedStructTypeInfo prunedInfo, String path) {
        Preconditions.checkArgument((prunedInfo != null ? 1 : 0) != 0, (Object)("PrunedStructTypeInfo for path '" + path + "' should not be null"));
        int index = path.indexOf(46);
        if (index < 0) {
            index = path.length();
        }
        String fieldName = path.substring(0, index);
        prunedInfo.markSelected(fieldName);
        if (index < path.length()) {
            ParquetHiveSerDe.pruneFromSinglePath(prunedInfo.getChild(fieldName), path.substring(index + 1));
        }
    }

    private String convertGroupType(GroupType group, boolean inferBinaryAsString) throws SerDeException {
        boolean first = true;
        StringBuilder sb = new StringBuilder("struct<");
        for (Type field : group.getFields()) {
            if (first) {
                first = false;
            } else {
                sb.append(",");
            }
            sb.append(field.getName()).append(":").append(this.convertParquetTypeToFieldType(field, inferBinaryAsString));
        }
        sb.append(">");
        return sb.toString();
    }

    private String convertPrimitiveType(PrimitiveType primitive, boolean inferBinaryAsString) throws SerDeException {
        switch (primitive.getPrimitiveTypeName()) {
            case INT96: {
                return "timestamp";
            }
            case INT32: {
                return "int";
            }
            case INT64: {
                return "bigint";
            }
            case BOOLEAN: {
                return "boolean";
            }
            case FLOAT: {
                return "float";
            }
            case DOUBLE: {
                return "double";
            }
            case BINARY: {
                if (inferBinaryAsString) {
                    return "string";
                }
                return "binary";
            }
        }
        throw new SerDeException(ErrorMsg.PARQUET_UNHANDLED_TYPE.getErrorCodedMsg(new String[]{primitive.getPrimitiveTypeName().name()}));
    }

    private String convertParquetIntLogicalType(Type parquetType) throws SerDeException {
        LogicalTypeAnnotation.IntLogicalTypeAnnotation intLogicalType = (LogicalTypeAnnotation.IntLogicalTypeAnnotation)parquetType.getLogicalTypeAnnotation();
        PrimitiveType primitiveType = parquetType.asPrimitiveType();
        switch (primitiveType.getPrimitiveTypeName()) {
            case INT32: 
            case INT64: {
                break;
            }
            default: {
                throw new SerDeException(ErrorMsg.PARQUET_UNHANDLED_TYPE.getErrorCodedMsg(new String[]{intLogicalType.toString()}));
            }
        }
        if (!intLogicalType.isSigned()) {
            throw new SerDeException(ErrorMsg.PARQUET_UNHANDLED_TYPE.getErrorCodedMsg(new String[]{intLogicalType.toString()}));
        }
        switch (intLogicalType.getBitWidth()) {
            case 8: {
                return "tinyint";
            }
            case 16: {
                return "smallint";
            }
            case 32: {
                return "int";
            }
            case 64: {
                return "bigint";
            }
        }
        throw new SerDeException(ErrorMsg.PARQUET_UNHANDLED_TYPE.getErrorCodedMsg(new String[]{intLogicalType.toString()}));
    }

    private String createMapType(String keyType, String valueType) {
        return "map<" + keyType + "," + valueType + ">";
    }

    private String convertParquetMapLogicalTypeAnnotation(Type parquetType, boolean inferBinaryAsString) throws SerDeException {
        LogicalTypeAnnotation.MapLogicalTypeAnnotation mType = (LogicalTypeAnnotation.MapLogicalTypeAnnotation)parquetType.getLogicalTypeAnnotation();
        GroupType gType = parquetType.asGroupType();
        Type innerField = gType.getType(0);
        GroupType innerGroup = innerField.asGroupType();
        Type key = innerGroup.getType(0);
        Type value = innerGroup.getType(1);
        return this.createMapType(this.convertParquetTypeToFieldType(key, inferBinaryAsString), this.convertParquetTypeToFieldType(value, inferBinaryAsString));
    }

    private String createArrayType(String fieldType) {
        return "array<" + fieldType + ">";
    }

    private String convertParquetListLogicalTypeAnnotation(Type parquetType, boolean inferBinaryAsString) throws SerDeException {
        LogicalTypeAnnotation.ListLogicalTypeAnnotation mType = (LogicalTypeAnnotation.ListLogicalTypeAnnotation)parquetType.getLogicalTypeAnnotation();
        GroupType gType = parquetType.asGroupType();
        Type innerField = gType.getType(0);
        if (innerField.isPrimitive() || innerField.getOriginalType() != null) {
            return this.createArrayType(this.convertParquetTypeToFieldType(innerField, inferBinaryAsString));
        }
        GroupType innerGroup = innerField.asGroupType();
        if (innerGroup.getFieldCount() != 1) {
            return this.createArrayType(this.convertGroupType(innerGroup, inferBinaryAsString));
        }
        return this.createArrayType(this.convertParquetTypeToFieldType(innerGroup.getType(0), inferBinaryAsString));
    }

    private String createDecimalType(int precision, int scale) {
        return "decimal(" + precision + "," + scale + ")";
    }

    private String convertLogicalType(Type type, boolean inferBinaryAsString) throws SerDeException {
        LogicalTypeAnnotation lType = type.getLogicalTypeAnnotation();
        if (lType instanceof LogicalTypeAnnotation.IntLogicalTypeAnnotation) {
            return this.convertParquetIntLogicalType(type);
        }
        if (lType instanceof LogicalTypeAnnotation.StringLogicalTypeAnnotation) {
            return "string";
        }
        if (lType instanceof LogicalTypeAnnotation.DecimalLogicalTypeAnnotation) {
            LogicalTypeAnnotation.DecimalLogicalTypeAnnotation dType = (LogicalTypeAnnotation.DecimalLogicalTypeAnnotation)lType;
            return this.createDecimalType(dType.getPrecision(), dType.getScale());
        }
        if (lType instanceof LogicalTypeAnnotation.MapLogicalTypeAnnotation) {
            return this.convertParquetMapLogicalTypeAnnotation(type, inferBinaryAsString);
        }
        if (lType instanceof LogicalTypeAnnotation.ListLogicalTypeAnnotation) {
            return this.convertParquetListLogicalTypeAnnotation(type, inferBinaryAsString);
        }
        if (lType instanceof LogicalTypeAnnotation.DateLogicalTypeAnnotation) {
            return "date";
        }
        throw new SerDeException(ErrorMsg.PARQUET_UNHANDLED_TYPE.getErrorCodedMsg(new String[]{lType.toString()}));
    }

    private String convertParquetTypeToFieldType(Type type, boolean inferBinaryAsString) throws SerDeException {
        if (type.getLogicalTypeAnnotation() != null) {
            return this.convertLogicalType(type, inferBinaryAsString);
        }
        if (type.isPrimitive()) {
            return this.convertPrimitiveType(type.asPrimitiveType(), inferBinaryAsString);
        }
        return this.convertGroupType(type.asGroupType(), inferBinaryAsString);
    }

    private FieldSchema convertParquetTypeToFieldSchema(Type type, boolean inferBinaryAsString) throws SerDeException {
        String columnName = type.getName();
        String typeName = this.convertParquetTypeToFieldType(type, inferBinaryAsString);
        return new FieldSchema(columnName, typeName, "Inferred from Parquet file.");
    }

    public List<FieldSchema> readSchema(Configuration conf, String file) throws SerDeException {
        FileMetaData metadata;
        try {
            HadoopInputFile inputFile = HadoopInputFile.fromPath((Path)new Path(file), (Configuration)conf);
            try (ParquetFileReader reader = ParquetFileReader.open((InputFile)inputFile);){
                metadata = reader.getFileMetaData();
            }
        }
        catch (Exception e) {
            throw new SerDeException(ErrorMsg.PARQUET_FOOTER_ERROR.getErrorCodedMsg(), (Throwable)e);
        }
        MessageType msg = metadata.getSchema();
        ArrayList<FieldSchema> schema = new ArrayList<FieldSchema>();
        String inferBinaryAsStringValue = conf.get(HiveConf.ConfVars.HIVE_PARQUET_INFER_BINARY_AS.varname);
        boolean inferBinaryAsString = "string".equalsIgnoreCase(inferBinaryAsStringValue);
        for (Type field : msg.getFields()) {
            FieldSchema fieldSchema = this.convertParquetTypeToFieldSchema(field, inferBinaryAsString);
            schema.add(fieldSchema);
            LOG.debug("Inferred field schema {}", (Object)fieldSchema);
        }
        return schema;
    }

    static {
        for (int prec = 1; prec <= 38; ++prec) {
            ParquetHiveSerDe.PRECISION_TO_BYTE_COUNT[prec - 1] = (int)Math.ceil((Math.log(Math.pow(10.0, prec) - 1.0) / Math.log(2.0) + 1.0) / 8.0);
        }
    }

    private static class PrunedStructTypeInfo {
        final StructTypeInfo typeInfo;
        final Map<String, PrunedStructTypeInfo> children;
        final boolean[] selected;

        PrunedStructTypeInfo(StructTypeInfo typeInfo) {
            this.typeInfo = typeInfo;
            this.children = new HashMap<String, PrunedStructTypeInfo>();
            this.selected = new boolean[typeInfo.getAllStructFieldTypeInfos().size()];
            for (int i = 0; i < typeInfo.getAllStructFieldTypeInfos().size(); ++i) {
                TypeInfo ti = (TypeInfo)typeInfo.getAllStructFieldTypeInfos().get(i);
                if (ti.getCategory() != ObjectInspector.Category.STRUCT) continue;
                this.children.put(((String)typeInfo.getAllStructFieldNames().get(i)).toLowerCase(), new PrunedStructTypeInfo((StructTypeInfo)ti));
            }
        }

        PrunedStructTypeInfo getChild(String fieldName) {
            return this.children.get(fieldName.toLowerCase());
        }

        void markSelected(String fieldName) {
            for (int i = 0; i < this.typeInfo.getAllStructFieldNames().size(); ++i) {
                if (!((String)this.typeInfo.getAllStructFieldNames().get(i)).equalsIgnoreCase(fieldName)) continue;
                this.selected[i] = true;
                break;
            }
        }

        StructTypeInfo prune() {
            ArrayList<String> newNames = new ArrayList<String>();
            ArrayList<Object> newTypes = new ArrayList<Object>();
            List oldNames = this.typeInfo.getAllStructFieldNames();
            List oldTypes = this.typeInfo.getAllStructFieldTypeInfos();
            for (int i = 0; i < oldNames.size(); ++i) {
                String fn = (String)oldNames.get(i);
                if (!this.selected[i]) continue;
                newNames.add(fn);
                if (this.children.containsKey(fn.toLowerCase())) {
                    newTypes.add(this.children.get(fn.toLowerCase()).prune());
                    continue;
                }
                newTypes.add((TypeInfo)oldTypes.get(i));
            }
            return (StructTypeInfo)TypeInfoFactory.getStructTypeInfo(newNames, newTypes);
        }
    }
}

