/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.key;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.datanucleus.exceptions.NucleusException;
import org.datanucleus.store.rdbms.table.Column;
import org.datanucleus.store.rdbms.table.Table;

abstract class Key {
    protected String name;
    protected Table table;
    protected List<Column> columns = new ArrayList<Column>();

    protected Key(Table table) {
        this.table = table;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public Table getTable() {
        return this.table;
    }

    public List<Column> getColumns() {
        return Collections.unmodifiableList(this.columns);
    }

    public String getColumnList() {
        return Key.getColumnList(this.columns);
    }

    public int getNumberOfColumns() {
        return this.columns.size();
    }

    public void addColumn(Column col) {
        this.assertSameDatastoreObject(col);
        this.columns.add(col);
    }

    public void setColumn(int seq, Column col) {
        this.assertSameDatastoreObject(col);
        Key.setListMinimumSize(this.columns, seq + 1);
        if (this.columns.get(seq) != null) {
            throw new NucleusException("Key position #" + seq + " for " + this.table + " already set").setFatal();
        }
        this.columns.set(seq, col);
    }

    protected void assertSameDatastoreObject(Column col) {
        if (!this.table.equals(col.getTable())) {
            throw new NucleusException("Cannot add " + col + " as key column for " + this.table).setFatal();
        }
    }

    public int hashCode() {
        return this.columns.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Key)) {
            return false;
        }
        Key key = (Key)obj;
        return this.columns.containsAll(key.columns) && this.columns.size() == key.columns.size();
    }

    protected static void setListMinimumSize(List<?> list, int size) {
        while (list.size() < size) {
            list.add(null);
        }
    }

    public static String getColumnList(List<Column> cols) {
        StringBuilder s = new StringBuilder("(");
        Iterator<Column> i = cols.iterator();
        while (i.hasNext()) {
            Column col = i.next();
            if (col == null) {
                s.append('?');
            } else {
                s.append(col.getIdentifier());
            }
            if (!i.hasNext()) continue;
            s.append(',');
        }
        s.append(')');
        return s.toString();
    }
}

