/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.manager.controller;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.validation.Valid;
import java.util.List;
import org.apache.hertzbeat.common.entity.dto.Message;
import org.apache.hertzbeat.common.entity.manager.StatusPageComponent;
import org.apache.hertzbeat.common.entity.manager.StatusPageIncident;
import org.apache.hertzbeat.common.entity.manager.StatusPageOrg;
import org.apache.hertzbeat.manager.service.StatusPageService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Tag(name="Status Page API")
@RestController
@RequestMapping(value={"/api/status/page"}, produces={"application/json"})
public class StatusPageController {
    @Autowired
    private StatusPageService statusPageService;

    @GetMapping(value={"/org"})
    @Operation(summary="Query Status Page Organization")
    public ResponseEntity<Message<StatusPageOrg>> queryStatusPageOrg() {
        StatusPageOrg statusPageOrg = this.statusPageService.queryStatusPageOrg();
        if (statusPageOrg == null) {
            return ResponseEntity.ok(Message.fail((byte)15, "Status Page Organization Not Found"));
        }
        return ResponseEntity.ok(Message.success(statusPageOrg));
    }

    @PostMapping(value={"/org"})
    @Operation(summary="Save and Update Query Status Page Organization")
    public ResponseEntity<Message<StatusPageOrg>> saveStatusPageOrg(@Valid @RequestBody StatusPageOrg statusPageOrg) {
        StatusPageOrg org = this.statusPageService.saveStatusPageOrg(statusPageOrg);
        return ResponseEntity.ok(Message.success(org));
    }

    @GetMapping(value={"/component"})
    @Operation(summary="Query Status Page Components")
    public ResponseEntity<Message<List<StatusPageComponent>>> queryStatusPageComponent() {
        List<StatusPageComponent> statusPageComponents = this.statusPageService.queryStatusPageComponents();
        return ResponseEntity.ok(Message.success(statusPageComponents));
    }

    @PostMapping(value={"/component"})
    @Operation(summary="Save Status Page Component")
    public ResponseEntity<Message<Void>> newStatusPageComponent(@Valid @RequestBody StatusPageComponent statusPageComponent) {
        this.statusPageService.newStatusPageComponent(statusPageComponent);
        return ResponseEntity.ok(Message.success("Add success"));
    }

    @PutMapping(value={"/component"})
    @Operation(summary="Update Status Page Component")
    public ResponseEntity<Message<Void>> updateStatusPageComponent(@Valid @RequestBody StatusPageComponent statusPageComponent) {
        this.statusPageService.updateStatusPageComponent(statusPageComponent);
        return ResponseEntity.ok(Message.success("Update success"));
    }

    @DeleteMapping(value={"/component/{id}"})
    @Operation(summary="Delete Status Page Component")
    public ResponseEntity<Message<Void>> deleteStatusPageComponent(@PathVariable(value="id") long id) {
        this.statusPageService.deleteStatusPageComponent(id);
        return ResponseEntity.ok(Message.success("Delete success"));
    }

    @GetMapping(value={"/component/{id}"})
    @Operation(summary="Query Status Page Component")
    public ResponseEntity<Message<StatusPageComponent>> queryStatusPageComponent(@PathVariable(value="id") long id) {
        StatusPageComponent statusPageComponent = this.statusPageService.queryStatusPageComponent(id);
        return ResponseEntity.ok(Message.success(statusPageComponent));
    }

    @PostMapping(value={"/incident"})
    @Operation(summary="Save Status Page Incident")
    public ResponseEntity<Message<Void>> newStatusPageIncident(@Valid @RequestBody StatusPageIncident incident) {
        this.statusPageService.newStatusPageIncident(incident);
        return ResponseEntity.ok(Message.success("Add success"));
    }

    @PutMapping(value={"/incident"})
    @Operation(summary="Update Status Page Incident")
    public ResponseEntity<Message<Void>> updateStatusPageIncident(@Valid @RequestBody StatusPageIncident incident) {
        this.statusPageService.updateStatusPageIncident(incident);
        return ResponseEntity.ok(Message.success("Update success"));
    }

    @DeleteMapping(value={"/incident/{id}"})
    @Operation(summary="Delete Status Page Incident")
    public ResponseEntity<Message<Void>> deleteStatusPageIncident(@PathVariable(value="id") long id) {
        this.statusPageService.deleteStatusPageIncident(id);
        return ResponseEntity.ok(Message.success("Delete success"));
    }

    @GetMapping(value={"/incident/{id}"})
    @Operation(summary="Get Status Page Incident")
    public ResponseEntity<Message<StatusPageIncident>> queryStatusPageIncident(@PathVariable(value="id") long id) {
        StatusPageIncident incident = this.statusPageService.queryStatusPageIncident(id);
        return ResponseEntity.ok(Message.success(incident));
    }

    @GetMapping(value={"/incident"})
    @Operation(summary="Query Status Page Incidents")
    public ResponseEntity<Message<Page<StatusPageIncident>>> queryStatusPageIncident(@Parameter(description="Search-Target", example="x") @RequestParam(required=false) String search, @Parameter(description="Start Time", example="1756384301907") @RequestParam(required=false) Long startTime, @Parameter(description="End Time", example="1756384301907") @RequestParam(required=false) Long endTime, @Parameter(description="List current page", example="0") @RequestParam(defaultValue="0") int pageIndex, @Parameter(description="Number of list pages", example="8") @RequestParam(defaultValue="8") int pageSize) {
        Page<StatusPageIncident> incidents = this.statusPageService.queryStatusPageIncidents(search, startTime, endTime, pageIndex, pageSize);
        return ResponseEntity.ok(Message.success(incidents));
    }
}

