/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.trino.connector.catalog.hive;

import io.trino.spi.session.PropertyMetadata;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.gravitino.catalog.property.PropertyConverter;
import org.apache.gravitino.trino.connector.catalog.CatalogConnectorAdapter;
import org.apache.gravitino.trino.connector.catalog.CatalogConnectorMetadataAdapter;
import org.apache.gravitino.trino.connector.catalog.HasPropertyMeta;
import org.apache.gravitino.trino.connector.catalog.hive.HiveCatalogPropertyConverter;
import org.apache.gravitino.trino.connector.catalog.hive.HiveMetadataAdapter;
import org.apache.gravitino.trino.connector.catalog.hive.HivePropertyMeta;
import org.apache.gravitino.trino.connector.metadata.GravitinoCatalog;

public class HiveConnectorAdapter
implements CatalogConnectorAdapter {
    private static final String CONNECTOR_HIVE = "hive";
    private final HasPropertyMeta propertyMetadata = new HivePropertyMeta();
    private final PropertyConverter catalogConverter = new HiveCatalogPropertyConverter();

    @Override
    public Map<String, String> buildInternalConnectorConfig(GravitinoCatalog catalog) throws Exception {
        HashMap<String, String> config = new HashMap<String, String>();
        config.put("hive.metastore.uri", catalog.getRequiredProperty("metastore.uris"));
        config.put("hive.security", "allow-all");
        Map trinoProperty = this.catalogConverter.gravitinoToEngineProperties(catalog.getProperties());
        config.putAll(trinoProperty);
        return config;
    }

    @Override
    public String internalConnectorName() {
        return CONNECTOR_HIVE;
    }

    @Override
    public List<PropertyMetadata<?>> getTableProperties() {
        return this.propertyMetadata.getTablePropertyMetadata();
    }

    @Override
    public List<PropertyMetadata<?>> getSchemaProperties() {
        return this.propertyMetadata.getSchemaPropertyMetadata();
    }

    @Override
    public CatalogConnectorMetadataAdapter getMetadataAdapter() {
        return new HiveMetadataAdapter(this.getSchemaProperties(), this.getTableProperties(), this.getColumnProperties());
    }

    @Override
    public List<PropertyMetadata<?>> getColumnProperties() {
        return Collections.emptyList();
    }
}

