/*
 * Decompiled with CFR 0.152.
 */
package javax.management;

import java.io.Serializable;
import java.lang.reflect.Method;
import javax.management.IntrospectionException;
import javax.management.MBeanFeatureInfo;
import mx4j.util.Utils;

public class MBeanAttributeInfo
extends MBeanFeatureInfo
implements Cloneable,
Serializable {
    private static final long serialVersionUID = 8644704819898565848L;
    private String attributeType;
    private boolean isRead;
    private boolean isWrite;
    private boolean is;

    public MBeanAttributeInfo(String name, String description, Method getter, Method setter) throws IntrospectionException {
        super(name, description);
        String getterType = null;
        String setterType = null;
        if (getter != null) {
            if (Utils.isAttributeGetter(getter)) {
                this.isRead = true;
                if (getter.getName().startsWith("is")) {
                    this.is = true;
                }
                getterType = getter.getReturnType().getName();
            } else {
                throw new IntrospectionException("Bad getter method");
            }
        }
        if (setter != null) {
            if (Utils.isAttributeSetter(setter)) {
                this.isWrite = true;
                setterType = setter.getParameterTypes()[0].getName();
            } else {
                throw new IntrospectionException("Bad setter method");
            }
        }
        this.attributeType = this.reconcileAttributeType(getterType, setterType);
    }

    public MBeanAttributeInfo(String name, String className, String description, boolean isReadable, boolean isWritable, boolean isIs) throws IllegalArgumentException {
        super(name, description);
        this.attributeType = className;
        this.isRead = isReadable;
        this.isWrite = isWritable;
        this.is = isIs;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException ignored) {
            return null;
        }
    }

    public String getType() {
        return this.attributeType;
    }

    public boolean isReadable() {
        return this.isRead;
    }

    public boolean isWritable() {
        return this.isWrite;
    }

    public boolean isIs() {
        return this.is;
    }

    public int hashCode() {
        int hash = super.hashCode();
        String t = this.getType();
        if (t != null) {
            hash = 29 * hash + t.hashCode();
        }
        hash = 29 * hash + 3 * (this.isReadable() ? Boolean.TRUE.hashCode() : Boolean.FALSE.hashCode());
        hash = 29 * hash + 5 * (this.isWritable() ? Boolean.TRUE.hashCode() : Boolean.FALSE.hashCode());
        hash = 29 * hash + 7 * (this.isIs() ? Boolean.TRUE.hashCode() : Boolean.FALSE.hashCode());
        return hash;
    }

    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof MBeanAttributeInfo)) {
            return false;
        }
        MBeanAttributeInfo other = (MBeanAttributeInfo)obj;
        String thisType = this.getType();
        String otherType = other.getType();
        if (thisType != null ? !thisType.equals(otherType) : otherType != null) {
            return false;
        }
        if (this.isReadable() ^ other.isReadable()) {
            return false;
        }
        if (this.isWritable() ^ other.isWritable()) {
            return false;
        }
        return !(this.isIs() ^ other.isIs());
    }

    private String reconcileAttributeType(String getterType, String setterType) throws IntrospectionException {
        String result = null;
        if (getterType == null && setterType != null) {
            result = setterType;
        } else if (getterType != null && setterType == null) {
            result = getterType;
        } else if (getterType != null && setterType != null) {
            if (getterType.compareToIgnoreCase(setterType) == 0) {
                result = getterType;
            } else {
                throw new IntrospectionException("Attribute setter/getter types don't match");
            }
        }
        return result;
    }
}

