/*
 * Decompiled with CFR 0.152.
 */
package com.qcloud.cos.internal.crypto;

import com.qcloud.cos.auth.COSCredentialsProvider;
import com.qcloud.cos.exception.CosClientException;
import com.qcloud.cos.internal.COSDirect;
import com.qcloud.cos.internal.crypto.AdjustedRangeInputStream;
import com.qcloud.cos.internal.crypto.COSCryptoModuleBase;
import com.qcloud.cos.internal.crypto.COSObjectWrapper;
import com.qcloud.cos.internal.crypto.CipherLite;
import com.qcloud.cos.internal.crypto.CipherLiteInputStream;
import com.qcloud.cos.internal.crypto.ContentCryptoMaterial;
import com.qcloud.cos.internal.crypto.ContentCryptoScheme;
import com.qcloud.cos.internal.crypto.CryptoConfiguration;
import com.qcloud.cos.internal.crypto.CryptoRuntime;
import com.qcloud.cos.internal.crypto.EncryptionMaterialsProvider;
import com.qcloud.cos.internal.crypto.MultipartUploadCryptoContext;
import com.qcloud.cos.internal.crypto.QCLOUDKMS;
import com.qcloud.cos.model.COSObject;
import com.qcloud.cos.model.COSObjectId;
import com.qcloud.cos.model.COSObjectInputStream;
import com.qcloud.cos.model.EncryptedGetObjectRequest;
import com.qcloud.cos.model.GetObjectRequest;
import com.qcloud.cos.model.InitiateMultipartUploadRequest;
import com.qcloud.cos.model.ObjectMetadata;
import com.qcloud.cos.model.UploadPartRequest;
import com.qcloud.cos.utils.IOUtils;
import com.qcloud.cos.utils.Jackson;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collections;
import java.util.Map;

public class COSCryptoModuleAE
extends COSCryptoModuleBase {
    public COSCryptoModuleAE(COSDirect cos, COSCredentialsProvider credentialsProvider, EncryptionMaterialsProvider kekMaterialsProvider, CryptoConfiguration cryptoConfig) {
        this(null, cos, credentialsProvider, kekMaterialsProvider, cryptoConfig);
    }

    public COSCryptoModuleAE(QCLOUDKMS kms, COSDirect cos, COSCredentialsProvider credentialsProvider, EncryptionMaterialsProvider kekMaterialsProvider, CryptoConfiguration cryptoConfig) {
        super(kms, cos, credentialsProvider, kekMaterialsProvider, cryptoConfig);
    }

    protected boolean isStrict() {
        return false;
    }

    @Override
    public COSObject getObjectSecurely(GetObjectRequest req) {
        COSObject retrieved;
        long[] desiredRange = req.getRange();
        if (this.isStrict() && desiredRange != null) {
            throw new SecurityException("Range get and getting a part are not allowed in strict crypto mode");
        }
        long[] adjustedCryptoRange = COSCryptoModuleAE.getAdjustedCryptoRange(desiredRange);
        if (adjustedCryptoRange != null) {
            req.setRange(adjustedCryptoRange[0], adjustedCryptoRange[1]);
        }
        if ((retrieved = this.cos.getObject(req)) == null) {
            return null;
        }
        String suffix = null;
        if (req instanceof EncryptedGetObjectRequest) {
            EncryptedGetObjectRequest ereq = (EncryptedGetObjectRequest)req;
            suffix = ereq.getInstructionFileSuffix();
        }
        try {
            return suffix == null || suffix.trim().isEmpty() ? this.decipher(req, desiredRange, adjustedCryptoRange, retrieved) : this.decipherWithInstFileSuffix(req, desiredRange, adjustedCryptoRange, retrieved, suffix);
        }
        catch (RuntimeException ex) {
            IOUtils.closeQuietly(retrieved, this.log);
            throw ex;
        }
        catch (Error error) {
            IOUtils.closeQuietly(retrieved, this.log);
            throw error;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private COSObject decipher(GetObjectRequest req, long[] desiredRange, long[] cryptoRange, COSObject retrieved) {
        COSObjectWrapper wrapped = new COSObjectWrapper(retrieved, req.getCOSObjectId());
        if (wrapped.hasEncryptionInfo()) {
            return this.decipherWithMetadata(req, desiredRange, cryptoRange, wrapped);
        }
        COSObjectWrapper ifile = this.fetchInstructionFile(req.getCOSObjectId(), null);
        if (ifile != null) {
            try {
                COSObject cOSObject = this.decipherWithInstructionFile(req, desiredRange, cryptoRange, wrapped, ifile);
                return cOSObject;
            }
            finally {
                IOUtils.closeQuietly(ifile, this.log);
            }
        }
        if (this.isStrict() || !this.cryptoConfig.isIgnoreMissingInstructionFile()) {
            IOUtils.closeQuietly(wrapped, this.log);
            throw new SecurityException("Instruction file not found for COS object with bucket name: " + retrieved.getBucketName() + ", key: " + retrieved.getKey());
        }
        this.log.warn(String.format("Unable to detect encryption information for object '%s' in bucket '%s'. Returning object without decryption.", retrieved.getKey(), retrieved.getBucketName()));
        COSObjectWrapper adjusted = this.adjustToDesiredRange(wrapped, desiredRange, null);
        return adjusted.getCOSObject();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private COSObject decipherWithInstFileSuffix(GetObjectRequest req, long[] desiredRange, long[] cryptoRange, COSObject retrieved, String instFileSuffix) {
        COSObjectId id = req.getCOSObjectId();
        COSObjectWrapper ifile = this.fetchInstructionFile(id, instFileSuffix);
        if (ifile == null) {
            throw new CosClientException("Instruction file with suffix " + instFileSuffix + " is not found for " + retrieved);
        }
        try {
            COSObject cOSObject = this.decipherWithInstructionFile(req, desiredRange, cryptoRange, new COSObjectWrapper(retrieved, id), ifile);
            return cOSObject;
        }
        finally {
            IOUtils.closeQuietly(ifile, this.log);
        }
    }

    private COSObject decipherWithInstructionFile(GetObjectRequest req, long[] desiredRange, long[] cryptoRange, COSObjectWrapper retrieved, COSObjectWrapper instructionFile) {
        boolean keyWrapExpected = this.isStrict();
        if (req instanceof EncryptedGetObjectRequest) {
            EncryptedGetObjectRequest ereq = (EncryptedGetObjectRequest)req;
            if (!keyWrapExpected) {
                keyWrapExpected = ereq.isKeyWrapExpected();
            }
        }
        String json = instructionFile.toJsonString();
        Map<String, String> matdesc = Collections.unmodifiableMap(Jackson.fromJsonString(json, Map.class));
        ContentCryptoMaterial cekMaterial = ContentCryptoMaterial.fromInstructionFile(matdesc, this.kekMaterialsProvider, this.cryptoConfig.getCryptoProvider(), cryptoRange, keyWrapExpected, this.kms);
        this.securityCheck(cekMaterial, retrieved);
        COSObjectWrapper decrypted = this.decrypt(retrieved, cekMaterial, cryptoRange);
        COSObjectWrapper adjusted = this.adjustToDesiredRange(decrypted, desiredRange, matdesc);
        return adjusted.getCOSObject();
    }

    private COSObject decipherWithMetadata(GetObjectRequest req, long[] desiredRange, long[] cryptoRange, COSObjectWrapper retrieved) {
        boolean keyWrapExpected = this.isStrict();
        if (req instanceof EncryptedGetObjectRequest) {
            EncryptedGetObjectRequest ereq = (EncryptedGetObjectRequest)req;
            if (!keyWrapExpected) {
                keyWrapExpected = ereq.isKeyWrapExpected();
            }
        }
        ContentCryptoMaterial cekMaterial = ContentCryptoMaterial.fromObjectMetadata(retrieved.getObjectMetadata(), this.kekMaterialsProvider, this.cryptoConfig.getCryptoProvider(), cryptoRange, keyWrapExpected, this.kms);
        this.securityCheck(cekMaterial, retrieved);
        COSObjectWrapper decrypted = this.decrypt(retrieved, cekMaterial, cryptoRange);
        COSObjectWrapper adjusted = this.adjustToDesiredRange(decrypted, desiredRange, null);
        return adjusted.getCOSObject();
    }

    protected final COSObjectWrapper adjustToDesiredRange(COSObjectWrapper cosObject, long[] range, Map<String, String> instruction) {
        if (range == null) {
            return cosObject;
        }
        ContentCryptoScheme encryptionScheme = cosObject.encryptionSchemeOf(instruction);
        long instanceLen = cosObject.getObjectMetadata().getInstanceLength();
        long maxOffset = instanceLen - (long)(encryptionScheme.getTagLengthInBits() / 8) - 1L;
        if (range[1] > maxOffset) {
            range[1] = maxOffset;
            if (range[0] > range[1]) {
                IOUtils.closeQuietly(cosObject.getObjectContent(), this.log);
                cosObject.setObjectContent(new ByteArrayInputStream(new byte[0]));
                return cosObject;
            }
        }
        if (range[0] > range[1]) {
            return cosObject;
        }
        try {
            COSObjectInputStream objectContent = cosObject.getObjectContent();
            AdjustedRangeInputStream adjustedRangeContents = new AdjustedRangeInputStream(objectContent, range[0], range[1]);
            cosObject.setObjectContent(new COSObjectInputStream(adjustedRangeContents, objectContent.getHttpRequest()));
            return cosObject;
        }
        catch (IOException e) {
            throw new CosClientException("Error adjusting output to desired byte range: " + e.getMessage());
        }
    }

    @Override
    public ObjectMetadata getObjectSecurely(GetObjectRequest getObjectRequest, File destinationFile) {
        this.assertParameterNotNull(destinationFile, "The destination file parameter must be specified when downloading an object directly to a file");
        COSObject cosObject = this.getObjectSecurely(getObjectRequest);
        if (cosObject == null) {
            return null;
        }
        BufferedOutputStream outputStream = null;
        try {
            int bytesRead;
            outputStream = new BufferedOutputStream(new FileOutputStream(destinationFile));
            byte[] buffer = new byte[10240];
            while ((bytesRead = cosObject.getObjectContent().read(buffer)) > -1) {
                ((OutputStream)outputStream).write(buffer, 0, bytesRead);
            }
        }
        catch (IOException e) {
            try {
                throw new CosClientException("Unable to store object contents to disk: " + e.getMessage(), e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(outputStream, this.log);
                IOUtils.closeQuietly(cosObject.getObjectContent(), this.log);
                throw throwable;
            }
        }
        IOUtils.closeQuietly(outputStream, this.log);
        IOUtils.closeQuietly(cosObject.getObjectContent(), this.log);
        return cosObject.getObjectMetadata();
    }

    @Override
    final MultipartUploadCryptoContext newUploadContext(InitiateMultipartUploadRequest req, ContentCryptoMaterial cekMaterial) {
        return new MultipartUploadCryptoContext(req.getBucketName(), req.getKey(), cekMaterial);
    }

    @Override
    final CipherLite cipherLiteForNextPart(MultipartUploadCryptoContext uploadContext) {
        return uploadContext.getCipherLite();
    }

    @Override
    final long computeLastPartSize(UploadPartRequest req) {
        return req.getPartSize() + (long)(this.contentCryptoScheme.getTagLengthInBits() / 8);
    }

    private COSObjectWrapper decrypt(COSObjectWrapper wrapper, ContentCryptoMaterial cekMaterial, long[] range) {
        COSObjectInputStream objectContent = wrapper.getObjectContent();
        wrapper.setObjectContent(new COSObjectInputStream(new CipherLiteInputStream(objectContent, cekMaterial.getCipherLite(), 2048), objectContent.getHttpRequest()));
        return wrapper;
    }

    private void assertParameterNotNull(Object parameterValue, String errorMessage) {
        if (parameterValue == null) {
            throw new IllegalArgumentException(errorMessage);
        }
    }

    @Override
    protected long ciphertextLength(long originalContentLength) {
        return originalContentLength + (long)(this.contentCryptoScheme.getTagLengthInBits() / 8);
    }

    static {
        CryptoRuntime.enableBouncyCastle();
    }
}

