/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.privatedns.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.Patch;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.management.polling.PollResult;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.polling.SyncPoller;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.privatedns.fluent.VirtualNetworkLinksClient;
import com.azure.resourcemanager.privatedns.fluent.models.VirtualNetworkLinkInner;
import com.azure.resourcemanager.privatedns.implementation.PrivateDnsManagementClientImpl;
import com.azure.resourcemanager.privatedns.models.VirtualNetworkLinkListResult;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public final class VirtualNetworkLinksClientImpl
implements VirtualNetworkLinksClient {
    private final VirtualNetworkLinksService service;
    private final PrivateDnsManagementClientImpl client;

    VirtualNetworkLinksClientImpl(PrivateDnsManagementClientImpl client) {
        this.service = (VirtualNetworkLinksService)RestProxy.create(VirtualNetworkLinksService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> createOrUpdateWithResponseAsync(String resourceGroupName, String privateZoneName, String virtualNetworkLinkName, VirtualNetworkLinkInner parameters, String ifMatch, String ifNoneMatch) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (privateZoneName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter privateZoneName is required and cannot be null."));
        }
        if (virtualNetworkLinkName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter virtualNetworkLinkName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.createOrUpdate(this.client.getEndpoint(), resourceGroupName, privateZoneName, virtualNetworkLinkName, ifMatch, ifNoneMatch, this.client.getApiVersion(), this.client.getSubscriptionId(), parameters, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> createOrUpdateWithResponseAsync(String resourceGroupName, String privateZoneName, String virtualNetworkLinkName, VirtualNetworkLinkInner parameters, String ifMatch, String ifNoneMatch, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (privateZoneName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter privateZoneName is required and cannot be null."));
        }
        if (virtualNetworkLinkName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter virtualNetworkLinkName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.createOrUpdate(this.client.getEndpoint(), resourceGroupName, privateZoneName, virtualNetworkLinkName, ifMatch, ifNoneMatch, this.client.getApiVersion(), this.client.getSubscriptionId(), parameters, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<VirtualNetworkLinkInner>, VirtualNetworkLinkInner> beginCreateOrUpdateAsync(String resourceGroupName, String privateZoneName, String virtualNetworkLinkName, VirtualNetworkLinkInner parameters, String ifMatch, String ifNoneMatch) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.createOrUpdateWithResponseAsync(resourceGroupName, privateZoneName, virtualNetworkLinkName, parameters, ifMatch, ifNoneMatch);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)VirtualNetworkLinkInner.class), (Type)((Object)VirtualNetworkLinkInner.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<VirtualNetworkLinkInner>, VirtualNetworkLinkInner> beginCreateOrUpdateAsync(String resourceGroupName, String privateZoneName, String virtualNetworkLinkName, VirtualNetworkLinkInner parameters, String ifMatch, String ifNoneMatch, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.createOrUpdateWithResponseAsync(resourceGroupName, privateZoneName, virtualNetworkLinkName, parameters, ifMatch, ifNoneMatch, context);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)VirtualNetworkLinkInner.class), (Type)((Object)VirtualNetworkLinkInner.class), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<VirtualNetworkLinkInner>, VirtualNetworkLinkInner> beginCreateOrUpdate(String resourceGroupName, String privateZoneName, String virtualNetworkLinkName, VirtualNetworkLinkInner parameters, String ifMatch, String ifNoneMatch) {
        return this.beginCreateOrUpdateAsync(resourceGroupName, privateZoneName, virtualNetworkLinkName, parameters, ifMatch, ifNoneMatch).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<VirtualNetworkLinkInner>, VirtualNetworkLinkInner> beginCreateOrUpdate(String resourceGroupName, String privateZoneName, String virtualNetworkLinkName, VirtualNetworkLinkInner parameters, String ifMatch, String ifNoneMatch, Context context) {
        return this.beginCreateOrUpdateAsync(resourceGroupName, privateZoneName, virtualNetworkLinkName, parameters, ifMatch, ifNoneMatch, context).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<VirtualNetworkLinkInner> createOrUpdateAsync(String resourceGroupName, String privateZoneName, String virtualNetworkLinkName, VirtualNetworkLinkInner parameters, String ifMatch, String ifNoneMatch) {
        return this.beginCreateOrUpdateAsync(resourceGroupName, privateZoneName, virtualNetworkLinkName, parameters, ifMatch, ifNoneMatch).last().flatMap(arg_0 -> ((PrivateDnsManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<VirtualNetworkLinkInner> createOrUpdateAsync(String resourceGroupName, String privateZoneName, String virtualNetworkLinkName, VirtualNetworkLinkInner parameters) {
        String ifMatch = null;
        String ifNoneMatch = null;
        return this.beginCreateOrUpdateAsync(resourceGroupName, privateZoneName, virtualNetworkLinkName, parameters, ifMatch, ifNoneMatch).last().flatMap(arg_0 -> ((PrivateDnsManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<VirtualNetworkLinkInner> createOrUpdateAsync(String resourceGroupName, String privateZoneName, String virtualNetworkLinkName, VirtualNetworkLinkInner parameters, String ifMatch, String ifNoneMatch, Context context) {
        return this.beginCreateOrUpdateAsync(resourceGroupName, privateZoneName, virtualNetworkLinkName, parameters, ifMatch, ifNoneMatch, context).last().flatMap(arg_0 -> ((PrivateDnsManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public VirtualNetworkLinkInner createOrUpdate(String resourceGroupName, String privateZoneName, String virtualNetworkLinkName, VirtualNetworkLinkInner parameters, String ifMatch, String ifNoneMatch) {
        return (VirtualNetworkLinkInner)((Object)this.createOrUpdateAsync(resourceGroupName, privateZoneName, virtualNetworkLinkName, parameters, ifMatch, ifNoneMatch).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public VirtualNetworkLinkInner createOrUpdate(String resourceGroupName, String privateZoneName, String virtualNetworkLinkName, VirtualNetworkLinkInner parameters) {
        String ifMatch = null;
        String ifNoneMatch = null;
        return (VirtualNetworkLinkInner)((Object)this.createOrUpdateAsync(resourceGroupName, privateZoneName, virtualNetworkLinkName, parameters, ifMatch, ifNoneMatch).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public VirtualNetworkLinkInner createOrUpdate(String resourceGroupName, String privateZoneName, String virtualNetworkLinkName, VirtualNetworkLinkInner parameters, String ifMatch, String ifNoneMatch, Context context) {
        return (VirtualNetworkLinkInner)((Object)this.createOrUpdateAsync(resourceGroupName, privateZoneName, virtualNetworkLinkName, parameters, ifMatch, ifNoneMatch, context).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> updateWithResponseAsync(String resourceGroupName, String privateZoneName, String virtualNetworkLinkName, VirtualNetworkLinkInner parameters, String ifMatch) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (privateZoneName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter privateZoneName is required and cannot be null."));
        }
        if (virtualNetworkLinkName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter virtualNetworkLinkName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.update(this.client.getEndpoint(), resourceGroupName, privateZoneName, virtualNetworkLinkName, ifMatch, this.client.getApiVersion(), this.client.getSubscriptionId(), parameters, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> updateWithResponseAsync(String resourceGroupName, String privateZoneName, String virtualNetworkLinkName, VirtualNetworkLinkInner parameters, String ifMatch, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (privateZoneName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter privateZoneName is required and cannot be null."));
        }
        if (virtualNetworkLinkName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter virtualNetworkLinkName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.update(this.client.getEndpoint(), resourceGroupName, privateZoneName, virtualNetworkLinkName, ifMatch, this.client.getApiVersion(), this.client.getSubscriptionId(), parameters, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<VirtualNetworkLinkInner>, VirtualNetworkLinkInner> beginUpdateAsync(String resourceGroupName, String privateZoneName, String virtualNetworkLinkName, VirtualNetworkLinkInner parameters, String ifMatch) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.updateWithResponseAsync(resourceGroupName, privateZoneName, virtualNetworkLinkName, parameters, ifMatch);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)VirtualNetworkLinkInner.class), (Type)((Object)VirtualNetworkLinkInner.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<VirtualNetworkLinkInner>, VirtualNetworkLinkInner> beginUpdateAsync(String resourceGroupName, String privateZoneName, String virtualNetworkLinkName, VirtualNetworkLinkInner parameters, String ifMatch, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.updateWithResponseAsync(resourceGroupName, privateZoneName, virtualNetworkLinkName, parameters, ifMatch, context);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)VirtualNetworkLinkInner.class), (Type)((Object)VirtualNetworkLinkInner.class), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<VirtualNetworkLinkInner>, VirtualNetworkLinkInner> beginUpdate(String resourceGroupName, String privateZoneName, String virtualNetworkLinkName, VirtualNetworkLinkInner parameters, String ifMatch) {
        return this.beginUpdateAsync(resourceGroupName, privateZoneName, virtualNetworkLinkName, parameters, ifMatch).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<VirtualNetworkLinkInner>, VirtualNetworkLinkInner> beginUpdate(String resourceGroupName, String privateZoneName, String virtualNetworkLinkName, VirtualNetworkLinkInner parameters, String ifMatch, Context context) {
        return this.beginUpdateAsync(resourceGroupName, privateZoneName, virtualNetworkLinkName, parameters, ifMatch, context).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<VirtualNetworkLinkInner> updateAsync(String resourceGroupName, String privateZoneName, String virtualNetworkLinkName, VirtualNetworkLinkInner parameters, String ifMatch) {
        return this.beginUpdateAsync(resourceGroupName, privateZoneName, virtualNetworkLinkName, parameters, ifMatch).last().flatMap(arg_0 -> ((PrivateDnsManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<VirtualNetworkLinkInner> updateAsync(String resourceGroupName, String privateZoneName, String virtualNetworkLinkName, VirtualNetworkLinkInner parameters) {
        String ifMatch = null;
        return this.beginUpdateAsync(resourceGroupName, privateZoneName, virtualNetworkLinkName, parameters, ifMatch).last().flatMap(arg_0 -> ((PrivateDnsManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<VirtualNetworkLinkInner> updateAsync(String resourceGroupName, String privateZoneName, String virtualNetworkLinkName, VirtualNetworkLinkInner parameters, String ifMatch, Context context) {
        return this.beginUpdateAsync(resourceGroupName, privateZoneName, virtualNetworkLinkName, parameters, ifMatch, context).last().flatMap(arg_0 -> ((PrivateDnsManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public VirtualNetworkLinkInner update(String resourceGroupName, String privateZoneName, String virtualNetworkLinkName, VirtualNetworkLinkInner parameters, String ifMatch) {
        return (VirtualNetworkLinkInner)((Object)this.updateAsync(resourceGroupName, privateZoneName, virtualNetworkLinkName, parameters, ifMatch).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public VirtualNetworkLinkInner update(String resourceGroupName, String privateZoneName, String virtualNetworkLinkName, VirtualNetworkLinkInner parameters) {
        String ifMatch = null;
        return (VirtualNetworkLinkInner)((Object)this.updateAsync(resourceGroupName, privateZoneName, virtualNetworkLinkName, parameters, ifMatch).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public VirtualNetworkLinkInner update(String resourceGroupName, String privateZoneName, String virtualNetworkLinkName, VirtualNetworkLinkInner parameters, String ifMatch, Context context) {
        return (VirtualNetworkLinkInner)((Object)this.updateAsync(resourceGroupName, privateZoneName, virtualNetworkLinkName, parameters, ifMatch, context).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> deleteWithResponseAsync(String resourceGroupName, String privateZoneName, String virtualNetworkLinkName, String ifMatch) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (privateZoneName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter privateZoneName is required and cannot be null."));
        }
        if (virtualNetworkLinkName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter virtualNetworkLinkName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.delete(this.client.getEndpoint(), resourceGroupName, privateZoneName, virtualNetworkLinkName, ifMatch, this.client.getApiVersion(), this.client.getSubscriptionId(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> deleteWithResponseAsync(String resourceGroupName, String privateZoneName, String virtualNetworkLinkName, String ifMatch, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (privateZoneName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter privateZoneName is required and cannot be null."));
        }
        if (virtualNetworkLinkName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter virtualNetworkLinkName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.delete(this.client.getEndpoint(), resourceGroupName, privateZoneName, virtualNetworkLinkName, ifMatch, this.client.getApiVersion(), this.client.getSubscriptionId(), "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<Void>, Void> beginDeleteAsync(String resourceGroupName, String privateZoneName, String virtualNetworkLinkName, String ifMatch) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.deleteWithResponseAsync(resourceGroupName, privateZoneName, virtualNetworkLinkName, ifMatch);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<Void>, Void> beginDeleteAsync(String resourceGroupName, String privateZoneName, String virtualNetworkLinkName, String ifMatch, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.deleteWithResponseAsync(resourceGroupName, privateZoneName, virtualNetworkLinkName, ifMatch, context);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginDelete(String resourceGroupName, String privateZoneName, String virtualNetworkLinkName, String ifMatch) {
        return this.beginDeleteAsync(resourceGroupName, privateZoneName, virtualNetworkLinkName, ifMatch).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginDelete(String resourceGroupName, String privateZoneName, String virtualNetworkLinkName, String ifMatch, Context context) {
        return this.beginDeleteAsync(resourceGroupName, privateZoneName, virtualNetworkLinkName, ifMatch, context).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> deleteAsync(String resourceGroupName, String privateZoneName, String virtualNetworkLinkName, String ifMatch) {
        return this.beginDeleteAsync(resourceGroupName, privateZoneName, virtualNetworkLinkName, ifMatch).last().flatMap(arg_0 -> ((PrivateDnsManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> deleteAsync(String resourceGroupName, String privateZoneName, String virtualNetworkLinkName) {
        String ifMatch = null;
        return this.beginDeleteAsync(resourceGroupName, privateZoneName, virtualNetworkLinkName, ifMatch).last().flatMap(arg_0 -> ((PrivateDnsManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Void> deleteAsync(String resourceGroupName, String privateZoneName, String virtualNetworkLinkName, String ifMatch, Context context) {
        return this.beginDeleteAsync(resourceGroupName, privateZoneName, virtualNetworkLinkName, ifMatch, context).last().flatMap(arg_0 -> ((PrivateDnsManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void delete(String resourceGroupName, String privateZoneName, String virtualNetworkLinkName, String ifMatch) {
        this.deleteAsync(resourceGroupName, privateZoneName, virtualNetworkLinkName, ifMatch).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void delete(String resourceGroupName, String privateZoneName, String virtualNetworkLinkName) {
        String ifMatch = null;
        this.deleteAsync(resourceGroupName, privateZoneName, virtualNetworkLinkName, ifMatch).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void delete(String resourceGroupName, String privateZoneName, String virtualNetworkLinkName, String ifMatch, Context context) {
        this.deleteAsync(resourceGroupName, privateZoneName, virtualNetworkLinkName, ifMatch, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<VirtualNetworkLinkInner>> getWithResponseAsync(String resourceGroupName, String privateZoneName, String virtualNetworkLinkName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (privateZoneName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter privateZoneName is required and cannot be null."));
        }
        if (virtualNetworkLinkName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter virtualNetworkLinkName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.get(this.client.getEndpoint(), resourceGroupName, privateZoneName, virtualNetworkLinkName, this.client.getApiVersion(), this.client.getSubscriptionId(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<VirtualNetworkLinkInner>> getWithResponseAsync(String resourceGroupName, String privateZoneName, String virtualNetworkLinkName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (privateZoneName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter privateZoneName is required and cannot be null."));
        }
        if (virtualNetworkLinkName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter virtualNetworkLinkName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.get(this.client.getEndpoint(), resourceGroupName, privateZoneName, virtualNetworkLinkName, this.client.getApiVersion(), this.client.getSubscriptionId(), "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<VirtualNetworkLinkInner> getAsync(String resourceGroupName, String privateZoneName, String virtualNetworkLinkName) {
        return this.getWithResponseAsync(resourceGroupName, privateZoneName, virtualNetworkLinkName).flatMap(res -> Mono.justOrEmpty((Object)((Object)((VirtualNetworkLinkInner)((Object)((Object)res.getValue()))))));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public VirtualNetworkLinkInner get(String resourceGroupName, String privateZoneName, String virtualNetworkLinkName) {
        return (VirtualNetworkLinkInner)((Object)this.getAsync(resourceGroupName, privateZoneName, virtualNetworkLinkName).block());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<VirtualNetworkLinkInner> getWithResponse(String resourceGroupName, String privateZoneName, String virtualNetworkLinkName, Context context) {
        return (Response)this.getWithResponseAsync(resourceGroupName, privateZoneName, virtualNetworkLinkName, context).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<VirtualNetworkLinkInner>> listSinglePageAsync(String resourceGroupName, String privateZoneName, Integer top) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (privateZoneName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter privateZoneName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.list(this.client.getEndpoint(), resourceGroupName, privateZoneName, top, this.client.getApiVersion(), this.client.getSubscriptionId(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((VirtualNetworkLinkListResult)res.getValue()).value(), ((VirtualNetworkLinkListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<VirtualNetworkLinkInner>> listSinglePageAsync(String resourceGroupName, String privateZoneName, Integer top, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (privateZoneName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter privateZoneName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.list(this.client.getEndpoint(), resourceGroupName, privateZoneName, top, this.client.getApiVersion(), this.client.getSubscriptionId(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((VirtualNetworkLinkListResult)res.getValue()).value(), ((VirtualNetworkLinkListResult)res.getValue()).nextLink(), null));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<VirtualNetworkLinkInner> listAsync(String resourceGroupName, String privateZoneName, Integer top) {
        return new PagedFlux(() -> this.listSinglePageAsync(resourceGroupName, privateZoneName, top), nextLink -> this.listNextSinglePageAsync((String)nextLink));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<VirtualNetworkLinkInner> listAsync(String resourceGroupName, String privateZoneName) {
        Integer top = null;
        return new PagedFlux(() -> this.listSinglePageAsync(resourceGroupName, privateZoneName, top), nextLink -> this.listNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<VirtualNetworkLinkInner> listAsync(String resourceGroupName, String privateZoneName, Integer top, Context context) {
        return new PagedFlux(() -> this.listSinglePageAsync(resourceGroupName, privateZoneName, top, context), nextLink -> this.listNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<VirtualNetworkLinkInner> list(String resourceGroupName, String privateZoneName) {
        Integer top = null;
        return new PagedIterable(this.listAsync(resourceGroupName, privateZoneName, top));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<VirtualNetworkLinkInner> list(String resourceGroupName, String privateZoneName, Integer top, Context context) {
        return new PagedIterable(this.listAsync(resourceGroupName, privateZoneName, top, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<VirtualNetworkLinkInner>> listNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((VirtualNetworkLinkListResult)res.getValue()).value(), ((VirtualNetworkLinkListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<VirtualNetworkLinkInner>> listNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listNext(nextLink, this.client.getEndpoint(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((VirtualNetworkLinkListResult)res.getValue()).value(), ((VirtualNetworkLinkListResult)res.getValue()).nextLink(), null));
    }

    @Host(value="{$host}")
    @ServiceInterface(name="PrivateDnsManagement")
    private static interface VirtualNetworkLinksService {
        @Headers(value={"Content-Type: application/json"})
        @Put(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/privateDnsZones/{privateZoneName}/virtualNetworkLinks/{virtualNetworkLinkName}")
        @ExpectedResponses(value={200, 201, 202})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> createOrUpdate(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="privateZoneName") String var3, @PathParam(value="virtualNetworkLinkName") String var4, @HeaderParam(value="If-Match") String var5, @HeaderParam(value="If-None-Match") String var6, @QueryParam(value="api-version") String var7, @PathParam(value="subscriptionId") String var8, @BodyParam(value="application/json") VirtualNetworkLinkInner var9, @HeaderParam(value="Accept") String var10, Context var11);

        @Headers(value={"Content-Type: application/json"})
        @Patch(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/privateDnsZones/{privateZoneName}/virtualNetworkLinks/{virtualNetworkLinkName}")
        @ExpectedResponses(value={200, 202})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> update(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="privateZoneName") String var3, @PathParam(value="virtualNetworkLinkName") String var4, @HeaderParam(value="If-Match") String var5, @QueryParam(value="api-version") String var6, @PathParam(value="subscriptionId") String var7, @BodyParam(value="application/json") VirtualNetworkLinkInner var8, @HeaderParam(value="Accept") String var9, Context var10);

        @Headers(value={"Content-Type: application/json"})
        @Delete(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/privateDnsZones/{privateZoneName}/virtualNetworkLinks/{virtualNetworkLinkName}")
        @ExpectedResponses(value={200, 202, 204})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> delete(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="privateZoneName") String var3, @PathParam(value="virtualNetworkLinkName") String var4, @HeaderParam(value="If-Match") String var5, @QueryParam(value="api-version") String var6, @PathParam(value="subscriptionId") String var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/privateDnsZones/{privateZoneName}/virtualNetworkLinks/{virtualNetworkLinkName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<VirtualNetworkLinkInner>> get(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="privateZoneName") String var3, @PathParam(value="virtualNetworkLinkName") String var4, @QueryParam(value="api-version") String var5, @PathParam(value="subscriptionId") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/privateDnsZones/{privateZoneName}/virtualNetworkLinks")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<VirtualNetworkLinkListResult>> list(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="privateZoneName") String var3, @QueryParam(value="$top") Integer var4, @QueryParam(value="api-version") String var5, @PathParam(value="subscriptionId") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<VirtualNetworkLinkListResult>> listNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="$host") String var2, @HeaderParam(value="Accept") String var3, Context var4);
    }
}

