/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.models;

import com.azure.resourcemanager.datafactory.fluent.models.FactoryUpdateProperties;
import com.azure.resourcemanager.datafactory.models.FactoryIdentity;
import com.azure.resourcemanager.datafactory.models.PublicNetworkAccess;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Map;

public final class FactoryUpdateParameters {
    @JsonProperty(value="tags")
    @JsonInclude(value=JsonInclude.Include.NON_NULL, content=JsonInclude.Include.ALWAYS)
    private Map<String, String> tags;
    @JsonProperty(value="identity")
    private FactoryIdentity identity;
    @JsonProperty(value="properties")
    private FactoryUpdateProperties innerProperties;

    public Map<String, String> tags() {
        return this.tags;
    }

    public FactoryUpdateParameters withTags(Map<String, String> tags) {
        this.tags = tags;
        return this;
    }

    public FactoryIdentity identity() {
        return this.identity;
    }

    public FactoryUpdateParameters withIdentity(FactoryIdentity identity) {
        this.identity = identity;
        return this;
    }

    private FactoryUpdateProperties innerProperties() {
        return this.innerProperties;
    }

    public PublicNetworkAccess publicNetworkAccess() {
        return this.innerProperties() == null ? null : this.innerProperties().publicNetworkAccess();
    }

    public FactoryUpdateParameters withPublicNetworkAccess(PublicNetworkAccess publicNetworkAccess) {
        if (this.innerProperties() == null) {
            this.innerProperties = new FactoryUpdateProperties();
        }
        this.innerProperties().withPublicNetworkAccess(publicNetworkAccess);
        return this;
    }

    public void validate() {
        if (this.identity() != null) {
            this.identity().validate();
        }
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }
}

