/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.sql.implementation;

import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.management.Region;
import com.azure.resourcemanager.resources.fluentcore.arm.Manager;
import com.azure.resourcemanager.resources.fluentcore.arm.collection.implementation.TopLevelModifiableResourcesImpl;
import com.azure.resourcemanager.resources.fluentcore.collection.InnerSupportsListing;
import com.azure.resourcemanager.resources.fluentcore.utils.PagedConverter;
import com.azure.resourcemanager.sql.SqlServerManager;
import com.azure.resourcemanager.sql.fluent.ServersClient;
import com.azure.resourcemanager.sql.fluent.SqlManagementClient;
import com.azure.resourcemanager.sql.fluent.models.LocationCapabilitiesInner;
import com.azure.resourcemanager.sql.fluent.models.ServerInner;
import com.azure.resourcemanager.sql.fluent.models.SubscriptionUsageInner;
import com.azure.resourcemanager.sql.implementation.CheckNameAvailabilityResultImpl;
import com.azure.resourcemanager.sql.implementation.RegionCapabilitiesImpl;
import com.azure.resourcemanager.sql.implementation.SqlDatabaseOperationsImpl;
import com.azure.resourcemanager.sql.implementation.SqlElasticPoolOperationsImpl;
import com.azure.resourcemanager.sql.implementation.SqlEncryptionProtectorOperationsImpl;
import com.azure.resourcemanager.sql.implementation.SqlFailoverGroupOperationsImpl;
import com.azure.resourcemanager.sql.implementation.SqlFirewallRuleOperationsImpl;
import com.azure.resourcemanager.sql.implementation.SqlServerDnsAliasOperationsImpl;
import com.azure.resourcemanager.sql.implementation.SqlServerImpl;
import com.azure.resourcemanager.sql.implementation.SqlServerKeyOperationsImpl;
import com.azure.resourcemanager.sql.implementation.SqlServerSecurityAlertPolicyOperationsImpl;
import com.azure.resourcemanager.sql.implementation.SqlSubscriptionUsageMetricImpl;
import com.azure.resourcemanager.sql.implementation.SqlSyncGroupOperationsImpl;
import com.azure.resourcemanager.sql.implementation.SqlSyncMemberOperationsImpl;
import com.azure.resourcemanager.sql.implementation.SqlVirtualNetworkRuleOperationsImpl;
import com.azure.resourcemanager.sql.models.CheckNameAvailabilityRequest;
import com.azure.resourcemanager.sql.models.CheckNameAvailabilityResult;
import com.azure.resourcemanager.sql.models.RegionCapabilities;
import com.azure.resourcemanager.sql.models.SqlDatabaseOperations;
import com.azure.resourcemanager.sql.models.SqlElasticPoolOperations;
import com.azure.resourcemanager.sql.models.SqlEncryptionProtectorOperations;
import com.azure.resourcemanager.sql.models.SqlFirewallRuleOperations;
import com.azure.resourcemanager.sql.models.SqlServer;
import com.azure.resourcemanager.sql.models.SqlServerKeyOperations;
import com.azure.resourcemanager.sql.models.SqlServerSecurityAlertPolicyOperations;
import com.azure.resourcemanager.sql.models.SqlServers;
import com.azure.resourcemanager.sql.models.SqlSubscriptionUsageMetric;
import com.azure.resourcemanager.sql.models.SqlSyncGroupOperations;
import com.azure.resourcemanager.sql.models.SqlSyncMemberOperations;
import com.azure.resourcemanager.sql.models.SqlVirtualNetworkRuleOperations;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import reactor.core.publisher.Mono;

public class SqlServersImpl
extends TopLevelModifiableResourcesImpl<SqlServer, SqlServerImpl, ServerInner, ServersClient, SqlServerManager>
implements SqlServers {
    private SqlFirewallRuleOperations firewallRules;
    private SqlVirtualNetworkRuleOperations virtualNetworkRules;
    private SqlElasticPoolOperations elasticPools;
    private SqlDatabaseOperations databases;
    private SqlServerDnsAliasOperationsImpl dnsAliases;
    private SqlFailoverGroupOperationsImpl failoverGroups;
    private SqlServerKeyOperationsImpl serverKeys;
    private SqlEncryptionProtectorOperationsImpl encryptionProtectors;
    private SqlSyncGroupOperationsImpl syncGroups;
    private SqlSyncMemberOperationsImpl syncMembers;
    private SqlServerSecurityAlertPolicyOperationsImpl serverSecurityAlertPolicies;

    public SqlServersImpl(SqlServerManager manager) {
        super((InnerSupportsListing)((SqlManagementClient)manager.serviceClient()).getServers(), (Manager)manager);
    }

    protected SqlServerImpl wrapModel(String name) {
        ServerInner inner = new ServerInner();
        return new SqlServerImpl(name, inner, (SqlServerManager)this.manager());
    }

    protected SqlServerImpl wrapModel(ServerInner inner) {
        if (inner == null) {
            return null;
        }
        return new SqlServerImpl(inner.name(), inner, (SqlServerManager)this.manager());
    }

    public SqlServer.DefinitionStages.Blank define(String name) {
        return this.wrapModel(name);
    }

    @Override
    public SqlFirewallRuleOperations firewallRules() {
        if (this.firewallRules == null) {
            this.firewallRules = new SqlFirewallRuleOperationsImpl((SqlServerManager)this.manager());
        }
        return this.firewallRules;
    }

    @Override
    public SqlVirtualNetworkRuleOperations virtualNetworkRules() {
        if (this.virtualNetworkRules == null) {
            this.virtualNetworkRules = new SqlVirtualNetworkRuleOperationsImpl((SqlServerManager)this.manager());
        }
        return this.virtualNetworkRules;
    }

    @Override
    public SqlServerDnsAliasOperationsImpl dnsAliases() {
        if (this.dnsAliases == null) {
            this.dnsAliases = new SqlServerDnsAliasOperationsImpl((SqlServerManager)this.manager());
        }
        return this.dnsAliases;
    }

    @Override
    public SqlFailoverGroupOperationsImpl failoverGroups() {
        if (this.failoverGroups == null) {
            this.failoverGroups = new SqlFailoverGroupOperationsImpl((SqlServerManager)this.manager());
        }
        return this.failoverGroups;
    }

    @Override
    public SqlServerKeyOperations serverKeys() {
        if (this.serverKeys == null) {
            this.serverKeys = new SqlServerKeyOperationsImpl((SqlServerManager)this.manager());
        }
        return this.serverKeys;
    }

    @Override
    public SqlEncryptionProtectorOperations encryptionProtectors() {
        if (this.encryptionProtectors == null) {
            this.encryptionProtectors = new SqlEncryptionProtectorOperationsImpl((SqlServerManager)this.manager());
        }
        return this.encryptionProtectors;
    }

    @Override
    public SqlServerSecurityAlertPolicyOperations serverSecurityAlertPolicies() {
        if (this.serverSecurityAlertPolicies == null) {
            this.serverSecurityAlertPolicies = new SqlServerSecurityAlertPolicyOperationsImpl((SqlServerManager)this.manager());
        }
        return this.serverSecurityAlertPolicies;
    }

    @Override
    public SqlSyncGroupOperations syncGroups() {
        if (this.syncGroups == null) {
            this.syncGroups = new SqlSyncGroupOperationsImpl((SqlServerManager)this.manager());
        }
        return this.syncGroups;
    }

    @Override
    public SqlSyncMemberOperations syncMembers() {
        if (this.syncMembers == null) {
            this.syncMembers = new SqlSyncMemberOperationsImpl((SqlServerManager)this.manager());
        }
        return this.syncMembers;
    }

    @Override
    public SqlElasticPoolOperations elasticPools() {
        if (this.elasticPools == null) {
            this.elasticPools = new SqlElasticPoolOperationsImpl((SqlServerManager)this.manager());
        }
        return this.elasticPools;
    }

    @Override
    public SqlDatabaseOperations databases() {
        if (this.databases == null) {
            this.databases = new SqlDatabaseOperationsImpl((SqlServerManager)this.manager());
        }
        return this.databases;
    }

    @Override
    public CheckNameAvailabilityResult checkNameAvailability(String name) {
        return new CheckNameAvailabilityResultImpl(((ServersClient)this.inner()).checkNameAvailability(new CheckNameAvailabilityRequest().withName(name)));
    }

    @Override
    public Mono<CheckNameAvailabilityResult> checkNameAvailabilityAsync(String name) {
        return ((ServersClient)this.inner()).checkNameAvailabilityAsync(new CheckNameAvailabilityRequest().withName(name)).map(CheckNameAvailabilityResultImpl::new);
    }

    @Override
    public RegionCapabilities getCapabilitiesByRegion(Region region) {
        LocationCapabilitiesInner capabilitiesInner = ((SqlManagementClient)((SqlServerManager)this.manager()).serviceClient()).getCapabilities().listByLocation(region.name());
        return capabilitiesInner != null ? new RegionCapabilitiesImpl(capabilitiesInner) : null;
    }

    @Override
    public Mono<RegionCapabilities> getCapabilitiesByRegionAsync(Region region) {
        return ((SqlManagementClient)((SqlServerManager)this.manager()).serviceClient()).getCapabilities().listByLocationAsync(region.name()).map(RegionCapabilitiesImpl::new);
    }

    @Override
    public List<SqlSubscriptionUsageMetric> listUsageByRegion(Region region) {
        Objects.requireNonNull(region);
        ArrayList<SqlSubscriptionUsageMetricImpl> subscriptionUsages = new ArrayList<SqlSubscriptionUsageMetricImpl>();
        PagedIterable<SubscriptionUsageInner> subscriptionUsageInners = ((SqlManagementClient)((SqlServerManager)this.manager()).serviceClient()).getSubscriptionUsages().listByLocation(region.name());
        for (SubscriptionUsageInner inner : subscriptionUsageInners) {
            subscriptionUsages.add(new SqlSubscriptionUsageMetricImpl(region.name(), inner, (SqlServerManager)this.manager()));
        }
        return Collections.unmodifiableList(subscriptionUsages);
    }

    @Override
    public PagedFlux<SqlSubscriptionUsageMetric> listUsageByRegionAsync(Region region) {
        Objects.requireNonNull(region);
        SqlServersImpl self = this;
        return PagedConverter.mapPage(((SqlManagementClient)((SqlServerManager)this.manager()).serviceClient()).getSubscriptionUsages().listByLocationAsync(region.name()), subscriptionUsageInner -> new SqlSubscriptionUsageMetricImpl(region.name(), (SubscriptionUsageInner)((Object)subscriptionUsageInner), (SqlServerManager)((Object)((Object)self.manager()))));
    }
}

