/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.sql.implementation;

import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.sql.fluent.TransparentDataEncryptionActivitiesClient;
import com.azure.resourcemanager.sql.fluent.models.TransparentDataEncryptionActivityInner;
import com.azure.resourcemanager.sql.implementation.SqlManagementClientImpl;
import com.azure.resourcemanager.sql.models.TransparentDataEncryptionActivityListResult;
import com.azure.resourcemanager.sql.models.TransparentDataEncryptionName;
import reactor.core.publisher.Mono;

public final class TransparentDataEncryptionActivitiesClientImpl
implements TransparentDataEncryptionActivitiesClient {
    private final TransparentDataEncryptionActivitiesService service;
    private final SqlManagementClientImpl client;

    TransparentDataEncryptionActivitiesClientImpl(SqlManagementClientImpl client) {
        this.service = (TransparentDataEncryptionActivitiesService)RestProxy.create(TransparentDataEncryptionActivitiesService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<TransparentDataEncryptionActivityInner>> listByConfigurationSinglePageAsync(String resourceGroupName, String serverName, String databaseName, TransparentDataEncryptionName transparentDataEncryptionName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serverName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serverName is required and cannot be null."));
        }
        if (databaseName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter databaseName is required and cannot be null."));
        }
        if (transparentDataEncryptionName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter transparentDataEncryptionName is required and cannot be null."));
        }
        String apiVersion = "2014-04-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listByConfiguration(this.client.getEndpoint(), "2014-04-01", this.client.getSubscriptionId(), resourceGroupName, serverName, databaseName, transparentDataEncryptionName, "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((TransparentDataEncryptionActivityListResult)res.getValue()).value(), null, null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<TransparentDataEncryptionActivityInner>> listByConfigurationSinglePageAsync(String resourceGroupName, String serverName, String databaseName, TransparentDataEncryptionName transparentDataEncryptionName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (serverName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter serverName is required and cannot be null."));
        }
        if (databaseName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter databaseName is required and cannot be null."));
        }
        if (transparentDataEncryptionName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter transparentDataEncryptionName is required and cannot be null."));
        }
        String apiVersion = "2014-04-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listByConfiguration(this.client.getEndpoint(), "2014-04-01", this.client.getSubscriptionId(), resourceGroupName, serverName, databaseName, transparentDataEncryptionName, "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((TransparentDataEncryptionActivityListResult)res.getValue()).value(), null, null));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<TransparentDataEncryptionActivityInner> listByConfigurationAsync(String resourceGroupName, String serverName, String databaseName, TransparentDataEncryptionName transparentDataEncryptionName) {
        return new PagedFlux(() -> this.listByConfigurationSinglePageAsync(resourceGroupName, serverName, databaseName, transparentDataEncryptionName));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<TransparentDataEncryptionActivityInner> listByConfigurationAsync(String resourceGroupName, String serverName, String databaseName, TransparentDataEncryptionName transparentDataEncryptionName, Context context) {
        return new PagedFlux(() -> this.listByConfigurationSinglePageAsync(resourceGroupName, serverName, databaseName, transparentDataEncryptionName, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<TransparentDataEncryptionActivityInner> listByConfiguration(String resourceGroupName, String serverName, String databaseName, TransparentDataEncryptionName transparentDataEncryptionName) {
        return new PagedIterable(this.listByConfigurationAsync(resourceGroupName, serverName, databaseName, transparentDataEncryptionName));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<TransparentDataEncryptionActivityInner> listByConfiguration(String resourceGroupName, String serverName, String databaseName, TransparentDataEncryptionName transparentDataEncryptionName, Context context) {
        return new PagedIterable(this.listByConfigurationAsync(resourceGroupName, serverName, databaseName, transparentDataEncryptionName, context));
    }

    @Host(value="{$host}")
    @ServiceInterface(name="SqlManagementClientT")
    private static interface TransparentDataEncryptionActivitiesService {
        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/transparentDataEncryption/{transparentDataEncryptionName}/operationResults")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<TransparentDataEncryptionActivityListResult>> listByConfiguration(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="resourceGroupName") String var4, @PathParam(value="serverName") String var5, @PathParam(value="databaseName") String var6, @PathParam(value="transparentDataEncryptionName") TransparentDataEncryptionName var7, @HeaderParam(value="Accept") String var8, Context var9);
    }
}

