/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.sagemaker.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.sagemaker.model.ParallelismConfiguration;
import com.amazonaws.services.sagemaker.model.Parameter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class StartPipelineExecutionRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String pipelineName;
    private String pipelineExecutionDisplayName;
    private List<Parameter> pipelineParameters;
    private String pipelineExecutionDescription;
    private String clientRequestToken;
    private ParallelismConfiguration parallelismConfiguration;

    public void setPipelineName(String pipelineName) {
        this.pipelineName = pipelineName;
    }

    public String getPipelineName() {
        return this.pipelineName;
    }

    public StartPipelineExecutionRequest withPipelineName(String pipelineName) {
        this.setPipelineName(pipelineName);
        return this;
    }

    public void setPipelineExecutionDisplayName(String pipelineExecutionDisplayName) {
        this.pipelineExecutionDisplayName = pipelineExecutionDisplayName;
    }

    public String getPipelineExecutionDisplayName() {
        return this.pipelineExecutionDisplayName;
    }

    public StartPipelineExecutionRequest withPipelineExecutionDisplayName(String pipelineExecutionDisplayName) {
        this.setPipelineExecutionDisplayName(pipelineExecutionDisplayName);
        return this;
    }

    public List<Parameter> getPipelineParameters() {
        return this.pipelineParameters;
    }

    public void setPipelineParameters(Collection<Parameter> pipelineParameters) {
        if (pipelineParameters == null) {
            this.pipelineParameters = null;
            return;
        }
        this.pipelineParameters = new ArrayList<Parameter>(pipelineParameters);
    }

    public StartPipelineExecutionRequest withPipelineParameters(Parameter ... pipelineParameters) {
        if (this.pipelineParameters == null) {
            this.setPipelineParameters(new ArrayList<Parameter>(pipelineParameters.length));
        }
        for (Parameter ele : pipelineParameters) {
            this.pipelineParameters.add(ele);
        }
        return this;
    }

    public StartPipelineExecutionRequest withPipelineParameters(Collection<Parameter> pipelineParameters) {
        this.setPipelineParameters(pipelineParameters);
        return this;
    }

    public void setPipelineExecutionDescription(String pipelineExecutionDescription) {
        this.pipelineExecutionDescription = pipelineExecutionDescription;
    }

    public String getPipelineExecutionDescription() {
        return this.pipelineExecutionDescription;
    }

    public StartPipelineExecutionRequest withPipelineExecutionDescription(String pipelineExecutionDescription) {
        this.setPipelineExecutionDescription(pipelineExecutionDescription);
        return this;
    }

    public void setClientRequestToken(String clientRequestToken) {
        this.clientRequestToken = clientRequestToken;
    }

    public String getClientRequestToken() {
        return this.clientRequestToken;
    }

    public StartPipelineExecutionRequest withClientRequestToken(String clientRequestToken) {
        this.setClientRequestToken(clientRequestToken);
        return this;
    }

    public void setParallelismConfiguration(ParallelismConfiguration parallelismConfiguration) {
        this.parallelismConfiguration = parallelismConfiguration;
    }

    public ParallelismConfiguration getParallelismConfiguration() {
        return this.parallelismConfiguration;
    }

    public StartPipelineExecutionRequest withParallelismConfiguration(ParallelismConfiguration parallelismConfiguration) {
        this.setParallelismConfiguration(parallelismConfiguration);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getPipelineName() != null) {
            sb.append("PipelineName: ").append(this.getPipelineName()).append(",");
        }
        if (this.getPipelineExecutionDisplayName() != null) {
            sb.append("PipelineExecutionDisplayName: ").append(this.getPipelineExecutionDisplayName()).append(",");
        }
        if (this.getPipelineParameters() != null) {
            sb.append("PipelineParameters: ").append(this.getPipelineParameters()).append(",");
        }
        if (this.getPipelineExecutionDescription() != null) {
            sb.append("PipelineExecutionDescription: ").append(this.getPipelineExecutionDescription()).append(",");
        }
        if (this.getClientRequestToken() != null) {
            sb.append("ClientRequestToken: ").append(this.getClientRequestToken()).append(",");
        }
        if (this.getParallelismConfiguration() != null) {
            sb.append("ParallelismConfiguration: ").append(this.getParallelismConfiguration());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartPipelineExecutionRequest)) {
            return false;
        }
        StartPipelineExecutionRequest other = (StartPipelineExecutionRequest)obj;
        if (other.getPipelineName() == null ^ this.getPipelineName() == null) {
            return false;
        }
        if (other.getPipelineName() != null && !other.getPipelineName().equals(this.getPipelineName())) {
            return false;
        }
        if (other.getPipelineExecutionDisplayName() == null ^ this.getPipelineExecutionDisplayName() == null) {
            return false;
        }
        if (other.getPipelineExecutionDisplayName() != null && !other.getPipelineExecutionDisplayName().equals(this.getPipelineExecutionDisplayName())) {
            return false;
        }
        if (other.getPipelineParameters() == null ^ this.getPipelineParameters() == null) {
            return false;
        }
        if (other.getPipelineParameters() != null && !other.getPipelineParameters().equals(this.getPipelineParameters())) {
            return false;
        }
        if (other.getPipelineExecutionDescription() == null ^ this.getPipelineExecutionDescription() == null) {
            return false;
        }
        if (other.getPipelineExecutionDescription() != null && !other.getPipelineExecutionDescription().equals(this.getPipelineExecutionDescription())) {
            return false;
        }
        if (other.getClientRequestToken() == null ^ this.getClientRequestToken() == null) {
            return false;
        }
        if (other.getClientRequestToken() != null && !other.getClientRequestToken().equals(this.getClientRequestToken())) {
            return false;
        }
        if (other.getParallelismConfiguration() == null ^ this.getParallelismConfiguration() == null) {
            return false;
        }
        return other.getParallelismConfiguration() == null || other.getParallelismConfiguration().equals(this.getParallelismConfiguration());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getPipelineName() == null ? 0 : this.getPipelineName().hashCode());
        hashCode = 31 * hashCode + (this.getPipelineExecutionDisplayName() == null ? 0 : this.getPipelineExecutionDisplayName().hashCode());
        hashCode = 31 * hashCode + (this.getPipelineParameters() == null ? 0 : this.getPipelineParameters().hashCode());
        hashCode = 31 * hashCode + (this.getPipelineExecutionDescription() == null ? 0 : this.getPipelineExecutionDescription().hashCode());
        hashCode = 31 * hashCode + (this.getClientRequestToken() == null ? 0 : this.getClientRequestToken().hashCode());
        hashCode = 31 * hashCode + (this.getParallelismConfiguration() == null ? 0 : this.getParallelismConfiguration().hashCode());
        return hashCode;
    }

    public StartPipelineExecutionRequest clone() {
        return (StartPipelineExecutionRequest)super.clone();
    }
}

