/*
 * Decompiled with CFR 0.152.
 */
package com.qcloud.cos.utils;

import com.qcloud.cos.exception.CosClientException;
import java.io.UnsupportedEncodingException;

public enum CodecUtils {


    static int sanitize(String singleOctets, byte[] dest) {
        int capacity = dest.length;
        char[] src = singleOctets.toCharArray();
        int limit = 0;
        for (int i = 0; i < capacity; ++i) {
            char c = src[i];
            if (c == '\r' || c == '\n' || c == ' ') continue;
            if (c > '\u007f') {
                throw new IllegalArgumentException("Invalid character found at position " + i + " for " + singleOctets);
            }
            dest[limit++] = (byte)c;
        }
        return limit;
    }

    public static byte[] toBytesDirect(String singleOctets) {
        char[] src = singleOctets.toCharArray();
        byte[] dest = new byte[src.length];
        for (int i = 0; i < dest.length; ++i) {
            char c = src[i];
            if (c > '\u007f') {
                throw new IllegalArgumentException("Invalid character found at position " + i + " for " + singleOctets);
            }
            dest[i] = (byte)c;
        }
        return dest;
    }

    public static String toStringDirect(byte[] bytes) {
        char[] dest = new char[bytes.length];
        int i = 0;
        for (byte b : bytes) {
            dest[i++] = (char)b;
        }
        return new String(dest);
    }

    public static String convertFromUtf8ToIso88591(String value) {
        if (value == null) {
            return null;
        }
        try {
            return new String(value.getBytes("UTF-8"), "ISO-8859-1");
        }
        catch (UnsupportedEncodingException e) {
            throw new CosClientException("Invalid charset name: " + e.getMessage(), e);
        }
    }

    public static String convertFromIso88591ToUtf8(String value) {
        if (value == null) {
            return null;
        }
        try {
            return new String(value.getBytes("ISO-8859-1"), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new CosClientException("Invalid charset name: " + e.getMessage(), e);
        }
    }
}

