/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.api.audit.operator;

import com.google.common.base.Strings;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.dolphinscheduler.api.audit.OperatorLog;
import org.apache.dolphinscheduler.api.audit.OperatorLogAspect;
import org.apache.dolphinscheduler.api.audit.OperatorUtils;
import org.apache.dolphinscheduler.api.audit.enums.AuditType;
import org.apache.dolphinscheduler.api.audit.operator.AuditOperator;
import org.apache.dolphinscheduler.api.service.AuditService;
import org.apache.dolphinscheduler.api.utils.Result;
import org.apache.dolphinscheduler.dao.entity.AuditLog;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public abstract class BaseAuditOperator
implements AuditOperator {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BaseAuditOperator.class);
    @Autowired
    private AuditService auditService;

    @Override
    public void recordAudit(OperatorLogAspect.AuditContext auditContext, Object returnValue) {
        Result result = new Result();
        if (returnValue instanceof Result && OperatorUtils.resultFail(result = (Result)returnValue)) {
            log.error("request fail, code {}", (Object)result.getCode());
            return;
        }
        long latency = System.currentTimeMillis() - auditContext.getBeginTime();
        List<AuditLog> auditLogList = auditContext.getAuditLogList();
        Map<String, Object> paramsMap = auditContext.getParamsMap();
        OperatorLog operatorLog = auditContext.getOperatorLog();
        AuditType auditType = operatorLog.auditType();
        this.setObjectIdentityFromReturnObject(auditType, result, auditLogList);
        this.modifyAuditOperationType(auditType, paramsMap, auditLogList);
        this.modifyAuditObjectType(auditType, paramsMap, auditLogList);
        auditLogList.forEach(auditLog -> auditLog.setLatency(latency));
        auditLogList.forEach(auditLog -> this.auditService.addAudit((AuditLog)auditLog));
    }

    @Override
    public void setRequestParam(AuditType auditType, List<AuditLog> auditLogList, Map<String, Object> paramsMap) {
        String[] paramNameArr = auditType.getRequestParamName();
        if (paramNameArr.length == 0) {
            return;
        }
        this.modifyRequestParams(paramNameArr, paramsMap, auditLogList);
        this.setObjectByParam(paramNameArr, paramsMap, auditLogList);
        if (auditLogList.get(0).getModelId() == null) {
            auditLogList.get(0).setModelId(Long.valueOf(OperatorUtils.getObjectIdentityByParam(paramNameArr, paramsMap)));
        }
    }

    protected void setObjectByParam(String[] paramNameArr, Map<String, Object> paramsMap, List<AuditLog> auditLogList) {
        String name = paramNameArr[0];
        Object value = paramsMap.get(name);
        if (value == null) {
            return;
        }
        String objName = this.getObjectNameFromIdentity(value);
        if (Strings.isNullOrEmpty((String)objName)) {
            auditLogList.get(0).setModelName(value.toString());
            return;
        }
        try {
            long objectId = Long.parseLong(value.toString());
            auditLogList.get(0).setModelId(Long.valueOf(objectId));
        }
        catch (NumberFormatException e) {
            log.error("value is not long, value: {}", value);
        }
        auditLogList.get(0).setModelName(objName);
    }

    protected void setObjectByParamArr(String[] paramNameArr, Map<String, Object> paramsMap, List<AuditLog> auditLogList) {
        AuditLog auditLog = auditLogList.get(0);
        for (String param : paramNameArr) {
            String[] identityArr;
            if (!paramsMap.containsKey(param)) continue;
            for (String identityString : identityArr = ((String)paramsMap.get(param)).split(",")) {
                long identity = this.toLong(identityString);
                String value = this.getObjectNameFromIdentity(identity);
                if (value == null) continue;
                auditLog.setModelId(Long.valueOf(identity));
                auditLog.setModelName(value);
                auditLogList.add(auditLog);
                auditLog = AuditLog.copyNewOne((AuditLog)auditLog);
            }
        }
        auditLogList.remove(0);
    }

    protected void setObjectIdentityFromReturnObject(AuditType auditType, Result<?> result, List<AuditLog> auditLogList) {
        String[] returnObjectFieldNameArr = auditType.getReturnObjectFieldName();
        if (returnObjectFieldNameArr.length == 0) {
            return;
        }
        Map<String, Object> returnObjectMap = OperatorUtils.getObjectIfFromReturnObject(result.getData(), returnObjectFieldNameArr);
        this.modifyObjectFromReturnObject(returnObjectFieldNameArr, returnObjectMap, auditLogList);
        this.setObjectNameFromReturnIdentity(auditLogList);
    }

    protected void setObjectNameFromReturnIdentity(List<AuditLog> auditLogList) {
        auditLogList.forEach(auditLog -> auditLog.setModelName(this.getObjectNameFromIdentity(auditLog.getModelId())));
    }

    protected void modifyObjectFromReturnObject(String[] params, Map<String, Object> returnObjectMap, List<AuditLog> auditLogList) {
        if (returnObjectMap.isEmpty() || returnObjectMap.get(params[0]) == null) {
            return;
        }
        Long objId = this.toLong(returnObjectMap.get(params[0]));
        if (objId != -1L) {
            auditLogList.get(0).setModelId(objId);
        }
    }

    protected Long toLong(Object str) {
        if (str == null) {
            return -1L;
        }
        return NumberUtils.toLong((String)str.toString(), (long)-1L);
    }

    protected String getObjectNameFromIdentity(Object identity) {
        return identity.toString();
    }

    protected void modifyRequestParams(String[] paramNameArr, Map<String, Object> paramsMap, List<AuditLog> auditLogList) {
    }

    protected void modifyAuditObjectType(AuditType auditType, Map<String, Object> paramsMap, List<AuditLog> auditLogList) {
    }

    protected void modifyAuditOperationType(AuditType auditType, Map<String, Object> paramsMap, List<AuditLog> auditLogList) {
    }
}

