/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.api.audit;

import io.swagger.v3.oas.annotations.Operation;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.apache.dolphinscheduler.api.audit.OperatorLog;
import org.apache.dolphinscheduler.api.audit.OperatorUtils;
import org.apache.dolphinscheduler.api.audit.enums.AuditType;
import org.apache.dolphinscheduler.api.audit.operator.AuditOperator;
import org.apache.dolphinscheduler.dao.entity.AuditLog;
import org.apache.dolphinscheduler.dao.entity.User;
import org.apache.dolphinscheduler.service.bean.SpringApplicationContext;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.AfterReturning;
import org.aspectj.lang.annotation.AfterThrowing;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class OperatorLogAspect {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(OperatorLogAspect.class);
    private static final ThreadLocal<AuditContext> auditThreadLocal = new ThreadLocal();

    @Pointcut(value="@annotation(org.apache.dolphinscheduler.api.audit.OperatorLog)")
    public void logPointCut() {
    }

    @Before(value="logPointCut()")
    public void before(JoinPoint point) {
        MethodSignature signature = (MethodSignature)point.getSignature();
        Method method = signature.getMethod();
        OperatorLog operatorLog = method.getAnnotation(OperatorLog.class);
        Operation operation = method.getAnnotation(Operation.class);
        if (operation == null) {
            log.warn("Operation is null of method: {}", (Object)method.getName());
            return;
        }
        Map<String, Object> paramsMap = OperatorUtils.getParamsMap(point, signature);
        User user = OperatorUtils.getUser(paramsMap);
        if (user == null) {
            log.error("user is null");
            return;
        }
        AuditType auditType = operatorLog.auditType();
        try {
            AuditOperator operator = (AuditOperator)SpringApplicationContext.getBean(operatorLog.auditType().getOperatorClass());
            List<AuditLog> auditLogList = OperatorUtils.buildAuditLogList(operation.description(), auditType, user);
            operator.setRequestParam(auditType, auditLogList, paramsMap);
            AuditContext auditContext = new AuditContext(auditLogList, paramsMap, operatorLog, System.currentTimeMillis(), operator);
            auditThreadLocal.set(auditContext);
        }
        catch (Throwable throwable) {
            log.error("Record audit log error", throwable);
        }
    }

    @AfterReturning(value="logPointCut()", returning="returnValue")
    public void afterReturning(Object returnValue) {
        try {
            AuditContext auditContext = auditThreadLocal.get();
            if (auditContext == null) {
                return;
            }
            auditContext.getOperator().recordAudit(auditContext, returnValue);
        }
        catch (Throwable throwable) {
            log.error("Record audit log error", throwable);
        }
        finally {
            auditThreadLocal.remove();
        }
    }

    @AfterThrowing(value="logPointCut()")
    public void afterThrowing() {
        auditThreadLocal.remove();
    }

    public static class AuditContext {
        List<AuditLog> auditLogList;
        Map<String, Object> paramsMap;
        OperatorLog operatorLog;
        long beginTime;
        AuditOperator operator;

        @Generated
        public List<AuditLog> getAuditLogList() {
            return this.auditLogList;
        }

        @Generated
        public Map<String, Object> getParamsMap() {
            return this.paramsMap;
        }

        @Generated
        public OperatorLog getOperatorLog() {
            return this.operatorLog;
        }

        @Generated
        public long getBeginTime() {
            return this.beginTime;
        }

        @Generated
        public AuditOperator getOperator() {
            return this.operator;
        }

        @Generated
        public void setAuditLogList(List<AuditLog> auditLogList) {
            this.auditLogList = auditLogList;
        }

        @Generated
        public void setParamsMap(Map<String, Object> paramsMap) {
            this.paramsMap = paramsMap;
        }

        @Generated
        public void setOperatorLog(OperatorLog operatorLog) {
            this.operatorLog = operatorLog;
        }

        @Generated
        public void setBeginTime(long beginTime) {
            this.beginTime = beginTime;
        }

        @Generated
        public void setOperator(AuditOperator operator) {
            this.operator = operator;
        }

        @Generated
        public AuditContext(List<AuditLog> auditLogList, Map<String, Object> paramsMap, OperatorLog operatorLog, long beginTime, AuditOperator operator) {
            this.auditLogList = auditLogList;
            this.paramsMap = paramsMap;
            this.operatorLog = operatorLog;
            this.beginTime = beginTime;
            this.operator = operator;
        }
    }
}

