/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.authorization.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.authorization.fluent.RoleEligibilityScheduleRequestsClient;
import com.azure.resourcemanager.authorization.fluent.models.RoleEligibilityScheduleRequestInner;
import com.azure.resourcemanager.authorization.implementation.AuthorizationManagementClientImpl;
import com.azure.resourcemanager.authorization.models.RoleEligibilityScheduleRequestListResult;
import reactor.core.publisher.Mono;

public final class RoleEligibilityScheduleRequestsClientImpl
implements RoleEligibilityScheduleRequestsClient {
    private final RoleEligibilityScheduleRequestsService service;
    private final AuthorizationManagementClientImpl client;

    RoleEligibilityScheduleRequestsClientImpl(AuthorizationManagementClientImpl client) {
        this.service = (RoleEligibilityScheduleRequestsService)RestProxy.create(RoleEligibilityScheduleRequestsService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<RoleEligibilityScheduleRequestInner>> createWithResponseAsync(String scope, String roleEligibilityScheduleRequestName, RoleEligibilityScheduleRequestInner parameters) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (scope == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter scope is required and cannot be null."));
        }
        if (roleEligibilityScheduleRequestName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter roleEligibilityScheduleRequestName is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String apiVersion = "2020-10-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.create(this.client.getEndpoint(), scope, roleEligibilityScheduleRequestName, "2020-10-01", parameters, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<RoleEligibilityScheduleRequestInner>> createWithResponseAsync(String scope, String roleEligibilityScheduleRequestName, RoleEligibilityScheduleRequestInner parameters, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (scope == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter scope is required and cannot be null."));
        }
        if (roleEligibilityScheduleRequestName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter roleEligibilityScheduleRequestName is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String apiVersion = "2020-10-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.create(this.client.getEndpoint(), scope, roleEligibilityScheduleRequestName, "2020-10-01", parameters, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<RoleEligibilityScheduleRequestInner> createAsync(String scope, String roleEligibilityScheduleRequestName, RoleEligibilityScheduleRequestInner parameters) {
        return this.createWithResponseAsync(scope, roleEligibilityScheduleRequestName, parameters).flatMap(res -> Mono.justOrEmpty((Object)((RoleEligibilityScheduleRequestInner)res.getValue())));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<RoleEligibilityScheduleRequestInner> createWithResponse(String scope, String roleEligibilityScheduleRequestName, RoleEligibilityScheduleRequestInner parameters, Context context) {
        return (Response)this.createWithResponseAsync(scope, roleEligibilityScheduleRequestName, parameters, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public RoleEligibilityScheduleRequestInner create(String scope, String roleEligibilityScheduleRequestName, RoleEligibilityScheduleRequestInner parameters) {
        return (RoleEligibilityScheduleRequestInner)this.createWithResponse(scope, roleEligibilityScheduleRequestName, parameters, Context.NONE).getValue();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<RoleEligibilityScheduleRequestInner>> getWithResponseAsync(String scope, String roleEligibilityScheduleRequestName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (scope == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter scope is required and cannot be null."));
        }
        if (roleEligibilityScheduleRequestName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter roleEligibilityScheduleRequestName is required and cannot be null."));
        }
        String apiVersion = "2020-10-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.get(this.client.getEndpoint(), scope, roleEligibilityScheduleRequestName, "2020-10-01", "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<RoleEligibilityScheduleRequestInner>> getWithResponseAsync(String scope, String roleEligibilityScheduleRequestName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (scope == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter scope is required and cannot be null."));
        }
        if (roleEligibilityScheduleRequestName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter roleEligibilityScheduleRequestName is required and cannot be null."));
        }
        String apiVersion = "2020-10-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.get(this.client.getEndpoint(), scope, roleEligibilityScheduleRequestName, "2020-10-01", "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<RoleEligibilityScheduleRequestInner> getAsync(String scope, String roleEligibilityScheduleRequestName) {
        return this.getWithResponseAsync(scope, roleEligibilityScheduleRequestName).flatMap(res -> Mono.justOrEmpty((Object)((RoleEligibilityScheduleRequestInner)res.getValue())));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<RoleEligibilityScheduleRequestInner> getWithResponse(String scope, String roleEligibilityScheduleRequestName, Context context) {
        return (Response)this.getWithResponseAsync(scope, roleEligibilityScheduleRequestName, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public RoleEligibilityScheduleRequestInner get(String scope, String roleEligibilityScheduleRequestName) {
        return (RoleEligibilityScheduleRequestInner)this.getWithResponse(scope, roleEligibilityScheduleRequestName, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<RoleEligibilityScheduleRequestInner>> listForScopeSinglePageAsync(String scope, String filter) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (scope == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter scope is required and cannot be null."));
        }
        String apiVersion = "2020-10-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listForScope(this.client.getEndpoint(), scope, filter, "2020-10-01", "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((RoleEligibilityScheduleRequestListResult)res.getValue()).value(), ((RoleEligibilityScheduleRequestListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<RoleEligibilityScheduleRequestInner>> listForScopeSinglePageAsync(String scope, String filter, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (scope == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter scope is required and cannot be null."));
        }
        String apiVersion = "2020-10-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listForScope(this.client.getEndpoint(), scope, filter, "2020-10-01", "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((RoleEligibilityScheduleRequestListResult)res.getValue()).value(), ((RoleEligibilityScheduleRequestListResult)res.getValue()).nextLink(), null));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<RoleEligibilityScheduleRequestInner> listForScopeAsync(String scope, String filter) {
        return new PagedFlux(() -> this.listForScopeSinglePageAsync(scope, filter), nextLink -> this.listForScopeNextSinglePageAsync((String)nextLink));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<RoleEligibilityScheduleRequestInner> listForScopeAsync(String scope) {
        String filter = null;
        return new PagedFlux(() -> this.listForScopeSinglePageAsync(scope, filter), nextLink -> this.listForScopeNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<RoleEligibilityScheduleRequestInner> listForScopeAsync(String scope, String filter, Context context) {
        return new PagedFlux(() -> this.listForScopeSinglePageAsync(scope, filter, context), nextLink -> this.listForScopeNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<RoleEligibilityScheduleRequestInner> listForScope(String scope) {
        String filter = null;
        return new PagedIterable(this.listForScopeAsync(scope, filter));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<RoleEligibilityScheduleRequestInner> listForScope(String scope, String filter, Context context) {
        return new PagedIterable(this.listForScopeAsync(scope, filter, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> cancelWithResponseAsync(String scope, String roleEligibilityScheduleRequestName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (scope == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter scope is required and cannot be null."));
        }
        if (roleEligibilityScheduleRequestName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter roleEligibilityScheduleRequestName is required and cannot be null."));
        }
        String apiVersion = "2020-10-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.cancel(this.client.getEndpoint(), scope, roleEligibilityScheduleRequestName, "2020-10-01", "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Void>> cancelWithResponseAsync(String scope, String roleEligibilityScheduleRequestName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (scope == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter scope is required and cannot be null."));
        }
        if (roleEligibilityScheduleRequestName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter roleEligibilityScheduleRequestName is required and cannot be null."));
        }
        String apiVersion = "2020-10-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.cancel(this.client.getEndpoint(), scope, roleEligibilityScheduleRequestName, "2020-10-01", "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> cancelAsync(String scope, String roleEligibilityScheduleRequestName) {
        return this.cancelWithResponseAsync(scope, roleEligibilityScheduleRequestName).flatMap(ignored -> Mono.empty());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> cancelWithResponse(String scope, String roleEligibilityScheduleRequestName, Context context) {
        return (Response)this.cancelWithResponseAsync(scope, roleEligibilityScheduleRequestName, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void cancel(String scope, String roleEligibilityScheduleRequestName) {
        this.cancelWithResponse(scope, roleEligibilityScheduleRequestName, Context.NONE);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<RoleEligibilityScheduleRequestInner>> validateWithResponseAsync(String scope, String roleEligibilityScheduleRequestName, RoleEligibilityScheduleRequestInner parameters) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (scope == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter scope is required and cannot be null."));
        }
        if (roleEligibilityScheduleRequestName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter roleEligibilityScheduleRequestName is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String apiVersion = "2020-10-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.validate(this.client.getEndpoint(), scope, roleEligibilityScheduleRequestName, "2020-10-01", parameters, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<RoleEligibilityScheduleRequestInner>> validateWithResponseAsync(String scope, String roleEligibilityScheduleRequestName, RoleEligibilityScheduleRequestInner parameters, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (scope == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter scope is required and cannot be null."));
        }
        if (roleEligibilityScheduleRequestName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter roleEligibilityScheduleRequestName is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String apiVersion = "2020-10-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.validate(this.client.getEndpoint(), scope, roleEligibilityScheduleRequestName, "2020-10-01", parameters, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<RoleEligibilityScheduleRequestInner> validateAsync(String scope, String roleEligibilityScheduleRequestName, RoleEligibilityScheduleRequestInner parameters) {
        return this.validateWithResponseAsync(scope, roleEligibilityScheduleRequestName, parameters).flatMap(res -> Mono.justOrEmpty((Object)((RoleEligibilityScheduleRequestInner)res.getValue())));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<RoleEligibilityScheduleRequestInner> validateWithResponse(String scope, String roleEligibilityScheduleRequestName, RoleEligibilityScheduleRequestInner parameters, Context context) {
        return (Response)this.validateWithResponseAsync(scope, roleEligibilityScheduleRequestName, parameters, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public RoleEligibilityScheduleRequestInner validate(String scope, String roleEligibilityScheduleRequestName, RoleEligibilityScheduleRequestInner parameters) {
        return (RoleEligibilityScheduleRequestInner)this.validateWithResponse(scope, roleEligibilityScheduleRequestName, parameters, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<RoleEligibilityScheduleRequestInner>> listForScopeNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listForScopeNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((RoleEligibilityScheduleRequestListResult)res.getValue()).value(), ((RoleEligibilityScheduleRequestListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<RoleEligibilityScheduleRequestInner>> listForScopeNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listForScopeNext(nextLink, this.client.getEndpoint(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((RoleEligibilityScheduleRequestListResult)res.getValue()).value(), ((RoleEligibilityScheduleRequestListResult)res.getValue()).nextLink(), null));
    }

    @Host(value="{$host}")
    @ServiceInterface(name="AuthorizationManagem")
    public static interface RoleEligibilityScheduleRequestsService {
        @Headers(value={"Content-Type: application/json"})
        @Put(value="/{scope}/providers/Microsoft.Authorization/roleEligibilityScheduleRequests/{roleEligibilityScheduleRequestName}")
        @ExpectedResponses(value={201})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<RoleEligibilityScheduleRequestInner>> create(@HostParam(value="$host") String var1, @PathParam(value="scope", encoded=true) String var2, @PathParam(value="roleEligibilityScheduleRequestName") String var3, @QueryParam(value="api-version") String var4, @BodyParam(value="application/json") RoleEligibilityScheduleRequestInner var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/{scope}/providers/Microsoft.Authorization/roleEligibilityScheduleRequests/{roleEligibilityScheduleRequestName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<RoleEligibilityScheduleRequestInner>> get(@HostParam(value="$host") String var1, @PathParam(value="scope", encoded=true) String var2, @PathParam(value="roleEligibilityScheduleRequestName") String var3, @QueryParam(value="api-version") String var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/{scope}/providers/Microsoft.Authorization/roleEligibilityScheduleRequests")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<RoleEligibilityScheduleRequestListResult>> listForScope(@HostParam(value="$host") String var1, @PathParam(value="scope", encoded=true) String var2, @QueryParam(value="$filter") String var3, @QueryParam(value="api-version") String var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/{scope}/providers/Microsoft.Authorization/roleEligibilityScheduleRequests/{roleEligibilityScheduleRequestName}/cancel")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Void>> cancel(@HostParam(value="$host") String var1, @PathParam(value="scope", encoded=true) String var2, @PathParam(value="roleEligibilityScheduleRequestName") String var3, @QueryParam(value="api-version") String var4, @HeaderParam(value="Accept") String var5, Context var6);

        @Headers(value={"Content-Type: application/json"})
        @Post(value="/{scope}/providers/Microsoft.Authorization/roleEligibilityScheduleRequests/{roleEligibilityScheduleRequestName}/validate")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<RoleEligibilityScheduleRequestInner>> validate(@HostParam(value="$host") String var1, @PathParam(value="scope", encoded=true) String var2, @PathParam(value="roleEligibilityScheduleRequestName") String var3, @QueryParam(value="api-version") String var4, @BodyParam(value="application/json") RoleEligibilityScheduleRequestInner var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<RoleEligibilityScheduleRequestListResult>> listForScopeNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="$host") String var2, @HeaderParam(value="Accept") String var3, Context var4);
    }
}

