/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.kubernetes.client.config;

import io.kubernetes.client.openapi.apis.CoreV1Api;
import io.kubernetes.client.openapi.models.V1Secret;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.kubernetes.client.config.KubernetesClientConfigUtils;
import org.springframework.cloud.kubernetes.commons.config.SecretsPropertySource;
import org.springframework.util.StringUtils;

public class KubernetesClientSecretsPropertySource
extends SecretsPropertySource {
    private static final Log LOG = LogFactory.getLog(KubernetesClientSecretsPropertySource.class);

    public KubernetesClientSecretsPropertySource(CoreV1Api coreV1Api, String name, String namespace, Map<String, String> labels, boolean failFast) {
        super(KubernetesClientSecretsPropertySource.getSourceName((String)name, (String)KubernetesClientConfigUtils.getApplicationNamespace(namespace, "Secret", null)), KubernetesClientSecretsPropertySource.getSourceData(coreV1Api, name, KubernetesClientConfigUtils.getApplicationNamespace(namespace, "Secret", null), labels, failFast));
    }

    private static Map<String, Object> getSourceData(CoreV1Api api, String name, String namespace, Map<String, String> labels, boolean failFast) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        LOG.debug((Object)("Loading Secret with name '" + name + "' or with labels [" + labels + "] in namespace '" + namespace + "'"));
        try {
            if (StringUtils.hasText((String)name)) {
                Optional<V1Secret> secret = api.listNamespacedSecret(namespace, null, null, null, null, null, null, null, null, null, null).getItems().stream().filter(s -> name.equals(s.getMetadata().getName())).findFirst();
                secret.ifPresent(s -> KubernetesClientSecretsPropertySource.putAll(s, result));
            }
            if (labels != null && !labels.isEmpty()) {
                api.listNamespacedSecret(namespace, null, null, null, null, KubernetesClientSecretsPropertySource.createLabelsSelector(labels), null, null, null, null, null).getItems().forEach(s -> KubernetesClientSecretsPropertySource.putAll(s, result));
            }
        }
        catch (Exception e) {
            if (failFast) {
                throw new IllegalStateException("Unable to read Secret with name '" + name + "' or labels [" + labels + "] in namespace '" + namespace + "'", e);
            }
            LOG.warn((Object)("Can't read secret with name: [" + name + "] or labels [" + labels + "] in namespace:[" + namespace + "] (cause: " + e.getMessage() + "). Ignoring"), (Throwable)e);
        }
        return result;
    }

    private static String createLabelsSelector(Map<String, String> labels) {
        return labels.entrySet().stream().map(e -> (String)e.getKey() + "=" + (String)e.getValue()).collect(Collectors.joining(","));
    }

    private static void putAll(V1Secret secret, Map<String, Object> result) {
        HashMap secretData = new HashMap();
        if (secret.getData() != null) {
            secret.getData().forEach((key, value) -> secretData.put(key, Base64.getEncoder().encodeToString((byte[])value)));
            KubernetesClientSecretsPropertySource.putAll(secretData, result);
        }
    }
}

