/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.tools.datasource.utils;

import com.google.common.base.Strings;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.dolphinscheduler.common.utils.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.ClassPathResource;

public class SchemaUtils {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SchemaUtils.class);

    private SchemaUtils() {
        throw new UnsupportedOperationException("Construct SchemaUtils");
    }

    public static List<String> getAllSchemaList() throws IOException {
        File[] schemaDirArr = new ClassPathResource("sql/upgrade").getFile().listFiles();
        if (schemaDirArr == null || schemaDirArr.length == 0) {
            return Collections.emptyList();
        }
        return Arrays.stream(schemaDirArr).map(File::getName).sorted((o1, o2) -> {
            try {
                String version1 = o1.split("_")[0];
                String version2 = o2.split("_")[0];
                if (version1.equals(version2)) {
                    return 0;
                }
                if (SchemaUtils.isAGreatVersion(version1, version2)) {
                    return 1;
                }
                return -1;
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
                throw new RuntimeException(e);
            }
        }).collect(Collectors.toList());
    }

    public static boolean isAGreatVersion(String schemaVersion, String version) {
        if (Strings.isNullOrEmpty((String)schemaVersion) || Strings.isNullOrEmpty((String)version)) {
            throw new RuntimeException("schemaVersion or version is empty");
        }
        String[] schemaVersionArr = schemaVersion.split("\\.");
        String[] versionArr = version.split("\\.");
        int arrLength = Math.min(schemaVersionArr.length, versionArr.length);
        for (int i = 0; i < arrLength; ++i) {
            if (Integer.parseInt(schemaVersionArr[i]) > Integer.parseInt(versionArr[i])) {
                return true;
            }
            if (Integer.parseInt(schemaVersionArr[i]) >= Integer.parseInt(versionArr[i])) continue;
            return false;
        }
        return schemaVersionArr.length > versionArr.length;
    }

    public static String getSoftVersion() throws IOException {
        String softVersion;
        ClassPathResource softVersionFile = new ClassPathResource("sql/soft_version");
        try (InputStream inputStream = softVersionFile.getInputStream();){
            softVersion = FileUtils.readFile2Str((InputStream)inputStream);
            softVersion = Strings.nullToEmpty((String)softVersion).replaceAll("\\s+|\r|\n", "");
        }
        catch (FileNotFoundException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new RuntimeException("Failed to get the product version description file. The file could not be found", e);
        }
        return softVersion;
    }
}

