/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.jose.jws;

import java.security.SecureRandom;
import java.security.Signature;
import java.security.interfaces.ECPrivateKey;
import java.security.spec.AlgorithmParameterSpec;
import org.apache.cxf.rs.security.jose.common.JoseException;
import org.apache.cxf.rs.security.jose.jwa.AlgorithmUtils;
import org.apache.cxf.rs.security.jose.jwa.SignatureAlgorithm;
import org.apache.cxf.rs.security.jose.jws.EcDsaJwsSignatureVerifier;
import org.apache.cxf.rs.security.jose.jws.JwsSignature;
import org.apache.cxf.rs.security.jose.jws.PrivateKeyJwsSignatureProvider;

public class EcDsaJwsSignatureProvider
extends PrivateKeyJwsSignatureProvider {
    public EcDsaJwsSignatureProvider(ECPrivateKey key, SignatureAlgorithm algo) {
        this(key, null, algo);
    }

    public EcDsaJwsSignatureProvider(ECPrivateKey key, AlgorithmParameterSpec spec, SignatureAlgorithm algo) {
        this(key, null, spec, algo);
    }

    public EcDsaJwsSignatureProvider(ECPrivateKey key, SecureRandom random, AlgorithmParameterSpec spec, SignatureAlgorithm algo) {
        super(key, random, spec, algo);
    }

    @Override
    protected boolean isValidAlgorithmFamily(String algo) {
        return AlgorithmUtils.isEcDsaSign(algo);
    }

    @Override
    protected JwsSignature doCreateJwsSignature(Signature s) {
        return new EcDsaPrivateKeyJwsSignature(s, EcDsaJwsSignatureVerifier.SIGNATURE_LENGTH_MAP.get(super.getAlgorithm().getJwaName()));
    }

    private static byte[] jcaOutputToJoseOutput(int jwsSignatureLen, byte[] jcaDer) {
        int sLength;
        int j;
        int rLength;
        int i;
        int offset;
        if (jcaDer.length < 8 || jcaDer[0] != 48) {
            throw new JoseException("Invalid format of ECDSA signature");
        }
        if (jcaDer[1] > 0) {
            offset = 2;
        } else if (jcaDer[1] == -127) {
            offset = 3;
        } else {
            throw new JoseException("Invalid format of ECDSA signature");
        }
        for (i = rLength = jcaDer[offset + 1]; i > 0 && jcaDer[offset + 2 + rLength - i] == 0; --i) {
        }
        for (j = sLength = jcaDer[offset + 2 + rLength + 1]; j > 0 && jcaDer[offset + 2 + rLength + 2 + sLength - j] == 0; --j) {
        }
        int rawLen = Math.max(i, j);
        rawLen = Math.max(rawLen, jwsSignatureLen / 2);
        if ((jcaDer[offset - 1] & 0xFF) != jcaDer.length - offset || (jcaDer[offset - 1] & 0xFF) != 2 + rLength + 2 + sLength || jcaDer[offset] != 2 || jcaDer[offset + 2 + rLength] != 2) {
            throw new JoseException("Invalid format of ECDSA signature");
        }
        byte[] concatenatedSignatureBytes = new byte[2 * rawLen];
        System.arraycopy(jcaDer, offset + 2 + rLength - i, concatenatedSignatureBytes, rawLen - i, i);
        System.arraycopy(jcaDer, offset + 2 + rLength + 2 + sLength - j, concatenatedSignatureBytes, 2 * rawLen - j, j);
        return concatenatedSignatureBytes;
    }

    protected static class EcDsaPrivateKeyJwsSignature
    extends PrivateKeyJwsSignatureProvider.PrivateKeyJwsSignature {
        private int outLen;

        public EcDsaPrivateKeyJwsSignature(Signature s, int outLen) {
            super(s);
            this.outLen = outLen;
        }

        @Override
        public byte[] sign() {
            byte[] jcaDer = super.sign();
            return EcDsaJwsSignatureProvider.jcaOutputToJoseOutput(this.outLen, jcaDer);
        }
    }
}

