/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.pool2.impl;

import java.lang.reflect.Field;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.commons.pool2.BasePooledObjectFactory;
import org.apache.commons.pool2.PooledObject;
import org.apache.commons.pool2.PooledObjectFactory;
import org.apache.commons.pool2.impl.BaseGenericObjectPool;
import org.apache.commons.pool2.impl.DefaultPooledObject;
import org.apache.commons.pool2.impl.EvictionTimer;
import org.apache.commons.pool2.impl.GenericObjectPool;
import org.junit.Assert;
import org.junit.Test;

public class TestEvictionTimer {
    @Test
    public void testStartStopEvictionTimer() throws Exception {
        try (GenericObjectPool pool = new GenericObjectPool((PooledObjectFactory)new BasePooledObjectFactory<String>(){

            public String create() throws Exception {
                return null;
            }

            public PooledObject<String> wrap(String obj) {
                return new DefaultPooledObject((Object)obj);
            }
        });){
            BaseGenericObjectPool.Evictor evictor1 = new BaseGenericObjectPool.Evictor((BaseGenericObjectPool)pool);
            EvictionTimer.schedule((BaseGenericObjectPool.Evictor)evictor1, (long)60000L, (long)60000L);
            Field evictorTaskFutureField = evictor1.getClass().getDeclaredField("scheduledFuture");
            evictorTaskFutureField.setAccessible(true);
            ScheduledFuture sf = (ScheduledFuture)evictorTaskFutureField.get(evictor1);
            Assert.assertFalse((boolean)sf.isCancelled());
            Field evictorExecutorField = EvictionTimer.class.getDeclaredField("executor");
            evictorExecutorField.setAccessible(true);
            ThreadPoolExecutor evictionExecutor = (ThreadPoolExecutor)evictorExecutorField.get(null);
            Assert.assertEquals((long)1L, (long)evictionExecutor.getQueue().size());
            BaseGenericObjectPool.Evictor evictor2 = new BaseGenericObjectPool.Evictor((BaseGenericObjectPool)pool);
            EvictionTimer.schedule((BaseGenericObjectPool.Evictor)evictor2, (long)60000L, (long)60000L);
            sf = (ScheduledFuture)evictorTaskFutureField.get(evictor2);
            Assert.assertFalse((boolean)sf.isCancelled());
            Assert.assertEquals((long)2L, (long)evictionExecutor.getQueue().size());
            EvictionTimer.cancel((BaseGenericObjectPool.Evictor)evictor1, (long)10000L, (TimeUnit)TimeUnit.MILLISECONDS);
            sf = (ScheduledFuture)evictorTaskFutureField.get(evictor1);
            Assert.assertTrue((boolean)sf.isCancelled());
            ThreadPoolExecutor evictionExecutorOnStop = (ThreadPoolExecutor)evictorExecutorField.get(null);
            Assert.assertEquals((long)1L, (long)evictionExecutorOnStop.getQueue().size());
            EvictionTimer.cancel((BaseGenericObjectPool.Evictor)evictor2, (long)10000L, (TimeUnit)TimeUnit.MILLISECONDS);
            sf = (ScheduledFuture)evictorTaskFutureField.get(evictor2);
            Assert.assertTrue((boolean)sf.isCancelled());
            Assert.assertNull((Object)evictorExecutorField.get(null));
        }
    }
}

