/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.pool2.impl;

import java.lang.reflect.Field;
import java.time.Duration;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadPoolExecutor;
import org.apache.commons.pool2.BasePooledObjectFactory;
import org.apache.commons.pool2.PooledObject;
import org.apache.commons.pool2.PooledObjectFactory;
import org.apache.commons.pool2.impl.BaseGenericObjectPool;
import org.apache.commons.pool2.impl.BaseObjectPoolConfig;
import org.apache.commons.pool2.impl.DefaultPooledObject;
import org.apache.commons.pool2.impl.EvictionTimer;
import org.apache.commons.pool2.impl.GenericObjectPool;
import org.apache.commons.pool2.impl.TestConstants;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestEvictionTimer {
    @Test
    public void testStartStopEvictionTimer() throws Exception {
        try (GenericObjectPool pool = new GenericObjectPool((PooledObjectFactory)new BasePooledObjectFactory<String>(){

            public String create() {
                return null;
            }

            public PooledObject<String> wrap(String obj) {
                return new DefaultPooledObject((Object)obj);
            }
        });){
            BaseGenericObjectPool.Evictor evictor1 = new BaseGenericObjectPool.Evictor((BaseGenericObjectPool)pool);
            EvictionTimer.schedule((BaseGenericObjectPool.Evictor)evictor1, (Duration)TestConstants.ONE_MINUTE_DURATION, (Duration)TestConstants.ONE_MINUTE_DURATION);
            Field evictorTaskFutureField = evictor1.getClass().getDeclaredField("scheduledFuture");
            evictorTaskFutureField.setAccessible(true);
            ScheduledFuture sf = (ScheduledFuture)evictorTaskFutureField.get(evictor1);
            Assertions.assertFalse((boolean)sf.isCancelled());
            Field evictorExecutorField = EvictionTimer.class.getDeclaredField("executor");
            evictorExecutorField.setAccessible(true);
            ThreadPoolExecutor evictionExecutor = (ThreadPoolExecutor)evictorExecutorField.get(null);
            Assertions.assertEquals((int)2, (int)evictionExecutor.getQueue().size());
            Assertions.assertEquals((int)1, (int)EvictionTimer.getNumTasks());
            BaseGenericObjectPool.Evictor evictor2 = new BaseGenericObjectPool.Evictor((BaseGenericObjectPool)pool);
            EvictionTimer.schedule((BaseGenericObjectPool.Evictor)evictor2, (Duration)TestConstants.ONE_MINUTE_DURATION, (Duration)TestConstants.ONE_MINUTE_DURATION);
            sf = (ScheduledFuture)evictorTaskFutureField.get(evictor2);
            Assertions.assertFalse((boolean)sf.isCancelled());
            Assertions.assertEquals((int)3, (int)evictionExecutor.getQueue().size());
            Assertions.assertEquals((int)2, (int)EvictionTimer.getNumTasks());
            EvictionTimer.cancel((BaseGenericObjectPool.Evictor)evictor1, (Duration)BaseObjectPoolConfig.DEFAULT_EVICTOR_SHUTDOWN_TIMEOUT, (boolean)false);
            sf = (ScheduledFuture)evictorTaskFutureField.get(evictor1);
            Assertions.assertTrue((boolean)sf.isCancelled());
            ThreadPoolExecutor evictionExecutorOnStop = (ThreadPoolExecutor)evictorExecutorField.get(null);
            Assertions.assertEquals((int)2, (int)evictionExecutorOnStop.getQueue().size());
            Assertions.assertEquals((int)1, (int)EvictionTimer.getNumTasks());
            EvictionTimer.cancel((BaseGenericObjectPool.Evictor)evictor2, (Duration)BaseObjectPoolConfig.DEFAULT_EVICTOR_SHUTDOWN_TIMEOUT, (boolean)false);
            sf = (ScheduledFuture)evictorTaskFutureField.get(evictor2);
            Assertions.assertTrue((boolean)sf.isCancelled());
            Assertions.assertNull((Object)evictorExecutorField.get(null));
            Assertions.assertEquals((int)0, (int)EvictionTimer.getNumTasks());
        }
    }
}

