/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.iterators;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import java.util.Random;
import org.apache.commons.collections4.Predicate;
import org.apache.commons.collections4.PredicateUtils;
import org.apache.commons.collections4.iterators.FilterListIterator;
import org.apache.commons.collections4.list.GrowthList;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class FilterListIteratorTest {
    private ArrayList<Integer> list;
    private ArrayList<Integer> odds;
    private ArrayList<Integer> evens;
    private ArrayList<Integer> threes;
    private ArrayList<Integer> fours;
    private ArrayList<Integer> sixes;
    private Predicate<Integer> truePred;
    private Predicate<Integer> falsePred;
    private Predicate<Integer> evenPred;
    private Predicate<Integer> oddPred;
    private Predicate<Integer> threePred;
    private Predicate<Integer> fourPred;
    private final Random random = new Random();

    private void nextNextPrevious(ListIterator<?> expected, ListIterator<?> testing) {
        Assertions.assertEquals(expected.next(), testing.next());
        Assertions.assertEquals((Object)expected.hasPrevious(), (Object)testing.hasPrevious());
        Object expecteda = expected.next();
        Object testinga = testing.next();
        Assertions.assertEquals(expecteda, testinga);
        Object expectedb = expected.previous();
        Object testingb = testing.previous();
        Assertions.assertEquals(expecteda, expectedb);
        Assertions.assertEquals(testinga, testingb);
    }

    private void previousPreviousNext(ListIterator<?> expected, ListIterator<?> testing) {
        Assertions.assertEquals(expected.previous(), testing.previous());
        Assertions.assertEquals((Object)expected.hasNext(), (Object)testing.hasNext());
        Object expecteda = expected.previous();
        Object testinga = testing.previous();
        Assertions.assertEquals(expecteda, testinga);
        Object expectedb = expected.next();
        Object testingb = testing.next();
        Assertions.assertEquals(expecteda, testingb);
        Assertions.assertEquals(expecteda, expectedb);
        Assertions.assertEquals(testinga, testingb);
    }

    @BeforeEach
    public void setUp() {
        this.list = new ArrayList();
        this.odds = new ArrayList();
        this.evens = new ArrayList();
        this.threes = new ArrayList();
        this.fours = new ArrayList();
        this.sixes = new ArrayList();
        for (int i = 0; i < 20; ++i) {
            this.list.add(i);
            if (i % 2 == 0) {
                this.evens.add(i);
            }
            if (i % 2 != 0) {
                this.odds.add(i);
            }
            if (i % 3 == 0) {
                this.threes.add(i);
            }
            if (i % 4 == 0) {
                this.fours.add(i);
            }
            if (i % 6 != 0) continue;
            this.sixes.add(i);
        }
        this.truePred = x -> true;
        this.falsePred = x -> true;
        this.evenPred = x -> x % 2 == 0;
        this.oddPred = x -> x % 2 != 0;
        this.threePred = x -> x % 3 == 0;
        this.fourPred = x -> x % 4 == 0;
    }

    @AfterEach
    public void tearDown() throws Exception {
        this.list = null;
        this.odds = null;
        this.evens = null;
        this.threes = null;
        this.fours = null;
        this.sixes = null;
        this.truePred = null;
        this.falsePred = null;
        this.evenPred = null;
        this.oddPred = null;
        this.threePred = null;
        this.fourPred = null;
    }

    @Test
    public void testCollections360() throws Throwable {
        GrowthList var7 = new GrowthList();
        Predicate var9 = PredicateUtils.anyPredicate((Collection)var7);
        FilterListIterator var13 = new FilterListIterator(var9);
        Assertions.assertFalse((boolean)var13.hasNext());
        FilterListIterator var14 = new FilterListIterator(var9);
        Assertions.assertFalse((boolean)var14.hasPrevious());
    }

    @Test
    public void testEvens() {
        FilterListIterator filtered = new FilterListIterator(this.list.listIterator(), this.evenPred);
        this.walkLists(this.evens, (ListIterator)filtered);
    }

    @Test
    public void testFailingHasNextBug() {
        FilterListIterator filtered = new FilterListIterator(this.list.listIterator(), this.fourPred);
        ListIterator<Integer> expected = this.fours.listIterator();
        while (expected.hasNext()) {
            expected.next();
            filtered.next();
        }
        Assertions.assertTrue((boolean)filtered.hasPrevious());
        Assertions.assertFalse((boolean)filtered.hasNext());
        Assertions.assertEquals((Integer)expected.previous(), (Integer)((Integer)filtered.previous()));
    }

    @Test
    public void testFalsePredicate() {
        FilterListIterator filtered = new FilterListIterator(this.list.listIterator(), this.falsePred);
        this.walkLists(new ArrayList(), (ListIterator)filtered);
    }

    @Test
    public void testFours() {
        FilterListIterator filtered = new FilterListIterator(this.list.listIterator(), this.fourPred);
        this.walkLists(this.fours, (ListIterator)filtered);
    }

    @Test
    public void testManual() {
        FilterListIterator filtered = new FilterListIterator(this.list.listIterator(), this.threePred);
        Assertions.assertEquals((Integer)0, (Integer)((Integer)filtered.next()));
        Assertions.assertEquals((Integer)3, (Integer)((Integer)filtered.next()));
        Assertions.assertEquals((Integer)6, (Integer)((Integer)filtered.next()));
        Assertions.assertEquals((Integer)9, (Integer)((Integer)filtered.next()));
        Assertions.assertEquals((Integer)12, (Integer)((Integer)filtered.next()));
        Assertions.assertEquals((Integer)15, (Integer)((Integer)filtered.next()));
        Assertions.assertEquals((Integer)18, (Integer)((Integer)filtered.next()));
        Assertions.assertEquals((Integer)18, (Integer)((Integer)filtered.previous()));
        Assertions.assertEquals((Integer)15, (Integer)((Integer)filtered.previous()));
        Assertions.assertEquals((Integer)12, (Integer)((Integer)filtered.previous()));
        Assertions.assertEquals((Integer)9, (Integer)((Integer)filtered.previous()));
        Assertions.assertEquals((Integer)6, (Integer)((Integer)filtered.previous()));
        Assertions.assertEquals((Integer)3, (Integer)((Integer)filtered.previous()));
        Assertions.assertEquals((Integer)0, (Integer)((Integer)filtered.previous()));
        Assertions.assertFalse((boolean)filtered.hasPrevious());
        Assertions.assertEquals((Integer)0, (Integer)((Integer)filtered.next()));
        Assertions.assertEquals((Integer)3, (Integer)((Integer)filtered.next()));
        Assertions.assertEquals((Integer)6, (Integer)((Integer)filtered.next()));
        Assertions.assertEquals((Integer)9, (Integer)((Integer)filtered.next()));
        Assertions.assertEquals((Integer)12, (Integer)((Integer)filtered.next()));
        Assertions.assertEquals((Integer)15, (Integer)((Integer)filtered.next()));
        Assertions.assertEquals((Integer)18, (Integer)((Integer)filtered.next()));
        Assertions.assertFalse((boolean)filtered.hasNext());
        Assertions.assertEquals((Integer)18, (Integer)((Integer)filtered.previous()));
        Assertions.assertEquals((Integer)15, (Integer)((Integer)filtered.previous()));
        Assertions.assertEquals((Integer)12, (Integer)((Integer)filtered.previous()));
        Assertions.assertEquals((Integer)9, (Integer)((Integer)filtered.previous()));
        Assertions.assertEquals((Integer)6, (Integer)((Integer)filtered.previous()));
        Assertions.assertEquals((Integer)3, (Integer)((Integer)filtered.previous()));
        Assertions.assertEquals((Integer)0, (Integer)((Integer)filtered.previous()));
        Assertions.assertEquals((Integer)0, (Integer)((Integer)filtered.next()));
        Assertions.assertEquals((Integer)0, (Integer)((Integer)filtered.previous()));
        Assertions.assertEquals((Integer)0, (Integer)((Integer)filtered.next()));
        Assertions.assertEquals((Integer)3, (Integer)((Integer)filtered.next()));
        Assertions.assertEquals((Integer)6, (Integer)((Integer)filtered.next()));
        Assertions.assertEquals((Integer)6, (Integer)((Integer)filtered.previous()));
        Assertions.assertEquals((Integer)3, (Integer)((Integer)filtered.previous()));
        Assertions.assertEquals((Integer)3, (Integer)((Integer)filtered.next()));
        Assertions.assertEquals((Integer)6, (Integer)((Integer)filtered.next()));
        Assertions.assertEquals((Integer)9, (Integer)((Integer)filtered.next()));
        Assertions.assertEquals((Integer)12, (Integer)((Integer)filtered.next()));
        Assertions.assertEquals((Integer)15, (Integer)((Integer)filtered.next()));
        Assertions.assertEquals((Integer)15, (Integer)((Integer)filtered.previous()));
        Assertions.assertEquals((Integer)12, (Integer)((Integer)filtered.previous()));
        Assertions.assertEquals((Integer)9, (Integer)((Integer)filtered.previous()));
    }

    @Test
    public void testNestedSixes() {
        FilterListIterator filtered = new FilterListIterator((ListIterator)new FilterListIterator(this.list.listIterator(), this.threePred), this.evenPred);
        this.walkLists(this.sixes, (ListIterator)filtered);
    }

    @Test
    public void testNestedSixes2() {
        FilterListIterator filtered = new FilterListIterator((ListIterator)new FilterListIterator(this.list.listIterator(), this.evenPred), this.threePred);
        this.walkLists(this.sixes, (ListIterator)filtered);
    }

    @Test
    public void testNestedSixes3() {
        FilterListIterator filtered = new FilterListIterator((ListIterator)new FilterListIterator(this.list.listIterator(), this.threePred), this.evenPred);
        this.walkLists(this.sixes, (ListIterator)new FilterListIterator((ListIterator)filtered, this.truePred));
    }

    @Test
    public void testNextChangesPrevious() {
        FilterListIterator filtered = new FilterListIterator(this.list.listIterator(), this.threePred);
        this.nextNextPrevious(this.threes.listIterator(), (ListIterator<?>)filtered);
        filtered = new FilterListIterator(this.list.listIterator(), this.truePred);
        this.nextNextPrevious(this.list.listIterator(), (ListIterator<?>)filtered);
    }

    @Test
    public void testOdds() {
        FilterListIterator filtered = new FilterListIterator(this.list.listIterator(), this.oddPred);
        this.walkLists(this.odds, (ListIterator)filtered);
    }

    @Test
    public void testPreviousChangesNext() {
        FilterListIterator filtered = new FilterListIterator(this.list.listIterator(), this.threePred);
        ListIterator<Integer> expected = this.threes.listIterator();
        this.walkForward(expected, (ListIterator<?>)filtered);
        this.previousPreviousNext(expected, (ListIterator<?>)filtered);
        filtered = new FilterListIterator(this.list.listIterator(), this.truePred);
        expected = this.list.listIterator();
        this.walkForward(expected, (ListIterator<?>)filtered);
        this.previousPreviousNext(expected, (ListIterator<?>)filtered);
    }

    @Test
    public void testThrees() {
        FilterListIterator filtered = new FilterListIterator(this.list.listIterator(), this.threePred);
        this.walkLists(this.threes, (ListIterator)filtered);
    }

    @Test
    public void testTruePredicate() {
        FilterListIterator filtered = new FilterListIterator(this.list.listIterator(), this.truePred);
        this.walkLists(this.list, (ListIterator)filtered);
    }

    @Test
    public void testWalkLists() {
        this.walkLists(this.list, this.list.listIterator());
    }

    private void walkBackward(ListIterator<?> expected, ListIterator<?> testing) {
        while (expected.hasPrevious()) {
            Assertions.assertEquals((int)expected.nextIndex(), (int)testing.nextIndex());
            Assertions.assertEquals((int)expected.previousIndex(), (int)testing.previousIndex());
            Assertions.assertTrue((boolean)testing.hasPrevious());
            Assertions.assertEquals(expected.previous(), testing.previous());
        }
    }

    private void walkForward(ListIterator<?> expected, ListIterator<?> testing) {
        while (expected.hasNext()) {
            Assertions.assertEquals((int)expected.nextIndex(), (int)testing.nextIndex());
            Assertions.assertEquals((int)expected.previousIndex(), (int)testing.previousIndex());
            Assertions.assertTrue((boolean)testing.hasNext());
            Assertions.assertEquals(expected.next(), testing.next());
        }
    }

    private <E> void walkLists(List<E> list, ListIterator<E> testing) {
        ListIterator<E> expected = list.listIterator();
        this.walkForward(expected, testing);
        this.walkBackward(expected, testing);
        while (expected.hasNext()) {
            Assertions.assertEquals((int)expected.nextIndex(), (int)testing.nextIndex());
            Assertions.assertEquals((int)expected.previousIndex(), (int)testing.previousIndex());
            Assertions.assertTrue((boolean)testing.hasNext());
            Assertions.assertEquals(expected.next(), testing.next());
            Assertions.assertTrue((boolean)testing.hasPrevious());
            Assertions.assertEquals(expected.previous(), testing.previous());
            Assertions.assertTrue((boolean)testing.hasNext());
            Assertions.assertEquals(expected.next(), testing.next());
        }
        this.walkBackward(expected, testing);
        for (int i = 0; i < list.size(); ++i) {
            int j;
            for (j = 0; j < i; ++j) {
                Assertions.assertEquals((int)expected.nextIndex(), (int)testing.nextIndex());
                Assertions.assertEquals((int)expected.previousIndex(), (int)testing.previousIndex());
                Assertions.assertTrue((boolean)expected.hasNext());
                Assertions.assertTrue((boolean)testing.hasNext());
                Assertions.assertEquals(expected.next(), testing.next());
            }
            for (j = 0; j < i / 2; ++j) {
                Assertions.assertEquals((int)expected.nextIndex(), (int)testing.nextIndex());
                Assertions.assertEquals((int)expected.previousIndex(), (int)testing.previousIndex());
                Assertions.assertTrue((boolean)expected.hasPrevious());
                Assertions.assertTrue((boolean)testing.hasPrevious());
                Assertions.assertEquals(expected.previous(), testing.previous());
            }
            for (j = 0; j < i / 2; ++j) {
                Assertions.assertEquals((int)expected.nextIndex(), (int)testing.nextIndex());
                Assertions.assertEquals((int)expected.previousIndex(), (int)testing.previousIndex());
                Assertions.assertTrue((boolean)expected.hasNext());
                Assertions.assertTrue((boolean)testing.hasNext());
                Assertions.assertEquals(expected.next(), testing.next());
            }
            for (j = 0; j < i; ++j) {
                Assertions.assertEquals((int)expected.nextIndex(), (int)testing.nextIndex());
                Assertions.assertEquals((int)expected.previousIndex(), (int)testing.previousIndex());
                Assertions.assertTrue((boolean)expected.hasPrevious());
                Assertions.assertTrue((boolean)testing.hasPrevious());
                Assertions.assertEquals(expected.previous(), testing.previous());
            }
        }
        StringBuilder walkdescr = new StringBuilder(500);
        for (int i = 0; i < 500; ++i) {
            if (this.random.nextBoolean()) {
                walkdescr.append("+");
                if (expected.hasNext()) {
                    Assertions.assertEquals(expected.next(), testing.next(), (String)walkdescr.toString());
                }
            } else {
                walkdescr.append("-");
                if (expected.hasPrevious()) {
                    Assertions.assertEquals(expected.previous(), testing.previous(), (String)walkdescr.toString());
                }
            }
            Assertions.assertEquals((int)expected.nextIndex(), (int)testing.nextIndex(), (String)walkdescr.toString());
            Assertions.assertEquals((int)expected.previousIndex(), (int)testing.previousIndex(), (String)walkdescr.toString());
        }
    }
}

