/*
 * Decompiled with CFR 0.152.
 */
package org.apache.celeborn.service.deploy.worker.storage;

import com.google.common.annotations.VisibleForTesting;
import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFutureListener;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.FileChannel;
import java.util.ArrayDeque;
import java.util.Queue;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.concurrent.GuardedBy;
import org.apache.celeborn.common.exception.FileCorruptedException;
import org.apache.celeborn.common.meta.FileInfo;
import org.apache.celeborn.common.network.buffer.ManagedBuffer;
import org.apache.celeborn.common.network.buffer.NioManagedBuffer;
import org.apache.celeborn.common.network.client.TransportClient;
import org.apache.celeborn.common.network.protocol.BacklogAnnouncement;
import org.apache.celeborn.common.network.protocol.ReadData;
import org.apache.celeborn.common.network.protocol.RpcRequest;
import org.apache.celeborn.common.network.protocol.TransportMessage;
import org.apache.celeborn.common.network.protocol.TransportableError;
import org.apache.celeborn.common.network.util.NettyUtils;
import org.apache.celeborn.common.protocol.MessageType;
import org.apache.celeborn.common.protocol.PbBufferStreamEnd;
import org.apache.celeborn.common.protocol.StreamType;
import org.apache.celeborn.common.util.ExceptionUtils;
import org.apache.celeborn.common.util.Utils;
import org.apache.celeborn.service.deploy.worker.memory.BufferQueue;
import org.apache.celeborn.service.deploy.worker.memory.BufferRecycler;
import org.apache.celeborn.service.deploy.worker.memory.RecyclableBuffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MapDataPartitionReader
implements Comparable<MapDataPartitionReader> {
    private static final Logger logger = LoggerFactory.getLogger(MapDataPartitionReader.class);
    private final ByteBuffer indexBuffer;
    private final ByteBuffer headerBuffer;
    private final int startPartitionIndex;
    private final int endPartitionIndex;
    private int numRegions;
    private int numRemainingPartitions;
    private int currentDataRegion = -1;
    private long dataConsumingOffset;
    private volatile long currentPartitionRemainingBytes;
    private FileInfo fileInfo;
    private int INDEX_ENTRY_SIZE = 16;
    private long streamId;
    protected final Object lock = new Object();
    private final AtomicInteger credits = new AtomicInteger();
    @GuardedBy(value="lock")
    protected final Queue<RecyclableBuffer> buffersToSend = new ArrayDeque<RecyclableBuffer>();
    @GuardedBy(value="lock")
    private volatile boolean readFinished;
    @GuardedBy(value="lock")
    protected boolean isReleased;
    @GuardedBy(value="lock")
    protected Throwable errorCause;
    @GuardedBy(value="lock")
    protected boolean errorNotified;
    private FileChannel dataFileChannel;
    private FileChannel indexFileChannel;
    private Channel associatedChannel;
    private Runnable recycleStream;
    private AtomicInteger numInUseBuffers = new AtomicInteger(0);
    private boolean isOpen = false;

    public MapDataPartitionReader(int startPartitionIndex, int endPartitionIndex, FileInfo fileInfo, long streamId, Channel associatedChannel, Runnable recycleStream) {
        this.startPartitionIndex = startPartitionIndex;
        this.endPartitionIndex = endPartitionIndex;
        int indexBufferSize = 16 * (endPartitionIndex - startPartitionIndex + 1);
        this.indexBuffer = ByteBuffer.allocateDirect(indexBufferSize);
        this.headerBuffer = ByteBuffer.allocateDirect(16);
        this.streamId = streamId;
        this.associatedChannel = associatedChannel;
        this.recycleStream = recycleStream;
        this.fileInfo = fileInfo;
        this.readFinished = false;
    }

    public void open(FileChannel dataFileChannel, FileChannel indexFileChannel, long indexSize) throws IOException {
        if (!this.isOpen) {
            this.dataFileChannel = dataFileChannel;
            this.indexFileChannel = indexFileChannel;
            long indexRegionSize = (long)this.fileInfo.getNumSubpartitions() * (long)this.INDEX_ENTRY_SIZE;
            this.numRegions = Utils.checkedDownCast((long)(indexSize / indexRegionSize));
            this.updateConsumingOffset();
            this.isOpen = true;
        }
    }

    public void addCredit(int credit) {
        this.credits.getAndAdd(credit);
    }

    public void readData(BufferQueue bufferQueue, BufferRecycler bufferRecycler) throws IOException {
        ByteBuf buffer;
        boolean hasRemaining;
        boolean continueReading = hasRemaining = this.hasRemaining();
        int numDataBuffers = 0;
        while (continueReading && (buffer = bufferQueue.poll()) != null) {
            buffer.retain();
            this.numInUseBuffers.incrementAndGet();
            try {
                continueReading = this.readBuffer(buffer);
            }
            catch (Throwable throwable) {
                bufferRecycler.recycle(buffer);
                this.numInUseBuffers.decrementAndGet();
                throw throwable;
            }
            hasRemaining = this.hasRemaining();
            this.addBuffer(buffer, bufferRecycler);
            ++numDataBuffers;
        }
        if (!hasRemaining) {
            this.closeReader();
        }
        if (numDataBuffers > 0) {
            this.notifyBacklog(numDataBuffers);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addBuffer(ByteBuf buffer, BufferRecycler bufferRecycler) {
        if (buffer == null) {
            return;
        }
        Object object = this.lock;
        synchronized (object) {
            if (this.isReleased) {
                bufferRecycler.recycle(buffer);
                this.numInUseBuffers.decrementAndGet();
                throw new RuntimeException("Partition reader has been failed or finished.", this.errorCause);
            }
            this.buffersToSend.add(new RecyclableBuffer(buffer, bufferRecycler));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RecyclableBuffer fetchBufferToSend() {
        Object object = this.lock;
        synchronized (object) {
            if (!this.buffersToSend.isEmpty() && this.credits.get() > 0 && !this.isReleased) {
                return this.buffersToSend.poll();
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getNumBuffersToSend() {
        Object object = this.lock;
        synchronized (object) {
            return this.buffersToSend.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void sendData() {
        RecyclableBuffer buffer;
        while (null != (buffer = this.fetchBufferToSend())) {
            RecyclableBuffer wrappedBuffer = buffer;
            int readableBytes = wrappedBuffer.byteBuf.readableBytes();
            if (logger.isDebugEnabled()) {
                logger.debug("send data start: {}, {}, {}", new Object[]{this.streamId, readableBytes, this.getNumBuffersToSend()});
            }
            ReadData readData = new ReadData(this.streamId, wrappedBuffer.byteBuf);
            this.associatedChannel.writeAndFlush((Object)readData).addListener((GenericFutureListener)((ChannelFutureListener)future -> {
                try {
                    if (!future.isSuccess()) {
                        this.recycleOnError(future.cause());
                    }
                }
                finally {
                    logger.debug("send data end: {}, {}", (Object)this.streamId, (Object)readableBytes);
                    wrappedBuffer.recycle();
                    this.numInUseBuffers.decrementAndGet();
                }
            }));
            int currentCredit = this.credits.decrementAndGet();
            logger.debug("stream {} credit {}", (Object)this.streamId, (Object)currentCredit);
        }
        boolean shouldRecycle = false;
        Object object = this.lock;
        synchronized (object) {
            if (this.isReleased) {
                return;
            }
            if (this.readFinished && this.buffersToSend.isEmpty()) {
                shouldRecycle = true;
            }
        }
        if (shouldRecycle) {
            this.recycle();
        }
    }

    private long getIndexRegionSize() {
        return (long)this.fileInfo.getNumSubpartitions() * (long)this.INDEX_ENTRY_SIZE;
    }

    private void readHeaderOrIndexBuffer(FileChannel channel, ByteBuffer buffer, int length) throws IOException {
        Utils.checkFileIntegrity((FileChannel)channel, (int)length);
        buffer.clear();
        buffer.limit(length);
        while (buffer.hasRemaining()) {
            channel.read(buffer);
        }
        buffer.flip();
    }

    private void readBufferIntoReadBuffer(FileChannel channel, ByteBuf buf, int length) throws IOException {
        Utils.checkFileIntegrity((FileChannel)channel, (int)length);
        ByteBuffer tmpBuffer = ByteBuffer.allocate(length);
        while (tmpBuffer.hasRemaining()) {
            channel.read(tmpBuffer);
        }
        tmpBuffer.flip();
        buf.writeBytes(tmpBuffer);
    }

    private int readBuffer(String filename, FileChannel channel, ByteBuffer header, ByteBuf buffer, int headerSize) throws IOException {
        this.readHeaderOrIndexBuffer(channel, header, headerSize);
        int bufferLength = header.getInt(12);
        if (bufferLength <= 0 || bufferLength > buffer.capacity()) {
            logger.error("Incorrect buffer header, buffer length: {}.", (Object)bufferLength);
            throw new FileCorruptedException("File " + filename + " is corrupted");
        }
        buffer.writeBytes(header);
        this.readBufferIntoReadBuffer(channel, buffer, bufferLength);
        return bufferLength + headerSize;
    }

    private void updateConsumingOffset() throws IOException {
        while (this.currentPartitionRemainingBytes == 0L && (this.currentDataRegion < this.numRegions - 1 || this.numRemainingPartitions > 0)) {
            if (this.numRemainingPartitions <= 0) {
                ++this.currentDataRegion;
                this.numRemainingPartitions = this.endPartitionIndex - this.startPartitionIndex + 1;
                this.indexFileChannel.position((long)this.currentDataRegion * this.getIndexRegionSize() + (long)this.startPartitionIndex * (long)this.INDEX_ENTRY_SIZE);
                this.readHeaderOrIndexBuffer(this.indexFileChannel, this.indexBuffer, this.indexBuffer.capacity());
            }
            this.dataConsumingOffset = this.indexBuffer.getLong();
            this.currentPartitionRemainingBytes = this.indexBuffer.getLong();
            --this.numRemainingPartitions;
            logger.debug("readBuffer updateConsumingOffset, {},  {}, {}, {}", new Object[]{this.streamId, this.dataFileChannel.size(), this.dataConsumingOffset, this.currentPartitionRemainingBytes});
            if (this.dataConsumingOffset >= 0L && this.dataConsumingOffset + this.currentPartitionRemainingBytes <= this.dataFileChannel.size() && this.currentPartitionRemainingBytes >= 0L) continue;
            throw new FileCorruptedException("File " + this.fileInfo.getFilePath() + " is corrupted");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean readBuffer(ByteBuf buffer) throws IOException {
        try {
            this.dataFileChannel.position(this.dataConsumingOffset);
            int readSize = this.readBuffer(this.fileInfo.getFilePath(), this.dataFileChannel, this.headerBuffer, buffer, this.headerBuffer.capacity());
            this.currentPartitionRemainingBytes -= (long)readSize;
            logger.debug("readBuffer data: {}, {}, {}, {}, {}, {}", new Object[]{this.streamId, this.currentPartitionRemainingBytes, readSize, this.dataConsumingOffset, this.fileInfo.getFilePath(), System.identityHashCode(buffer)});
            if (this.currentPartitionRemainingBytes < 0L) {
                throw new FileCorruptedException("File is corrupted");
            }
            if (this.currentPartitionRemainingBytes == 0L) {
                logger.debug("readBuffer end, {},  {}, {}, {}", new Object[]{this.streamId, this.dataFileChannel.size(), this.dataConsumingOffset, this.currentPartitionRemainingBytes});
                int prevDataRegion = this.currentDataRegion;
                this.updateConsumingOffset();
                return prevDataRegion == this.currentDataRegion && this.currentPartitionRemainingBytes > 0L;
            }
            this.dataConsumingOffset = this.dataFileChannel.position();
            logger.debug("readBuffer run: {}, {}, {}, {}", new Object[]{this.streamId, this.dataFileChannel.size(), this.dataConsumingOffset, this.currentPartitionRemainingBytes});
            return true;
        }
        catch (Throwable throwable) {
            logger.error("Failed to read partition file.", throwable);
            Object object = this.lock;
            synchronized (object) {
                this.isReleased = true;
            }
            throw throwable;
        }
    }

    public boolean hasRemaining() {
        return this.currentPartitionRemainingBytes > 0L;
    }

    private void notifyBacklog(int backlog) {
        logger.debug("stream manager stream id {} backlog:{}", (Object)this.streamId, (Object)backlog);
        this.associatedChannel.writeAndFlush((Object)new BacklogAnnouncement(this.streamId, backlog)).addListener(future -> {
            if (!future.isSuccess()) {
                logger.error("send backlog {} to stream {} failed", (Object)backlog, (Object)this.streamId);
            }
        });
    }

    private void notifyError(Throwable throwable) {
        logger.error("Read file: {} error from {}, stream id {}", new Object[]{this.fileInfo.getFilePath(), NettyUtils.getRemoteAddress((Channel)this.associatedChannel), this.streamId, throwable});
        if (throwable instanceof ClosedChannelException) {
            return;
        }
        if (this.associatedChannel.isActive()) {
            this.associatedChannel.writeAndFlush((Object)new TransportableError(this.streamId, ExceptionUtils.wrapIOExceptionToUnRetryable((Throwable)throwable)));
        }
    }

    public long getPriority() {
        return this.dataConsumingOffset;
    }

    @Override
    public int compareTo(MapDataPartitionReader that) {
        return Long.compare(this.getPriority(), that.getPriority());
    }

    public FileInfo getFileInfo() {
        return this.fileInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeReader() {
        Object object = this.lock;
        synchronized (object) {
            this.readFinished = true;
        }
        logger.debug("Closed read for stream {}", (Object)this.streamId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void recycle() {
        Object object = this.lock;
        synchronized (object) {
            if (!this.isReleased) {
                this.release();
                this.recycleStream.run();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void recycleOnError(Throwable throwable) {
        Object object = this.lock;
        synchronized (object) {
            if (!this.errorNotified) {
                this.errorNotified = true;
                this.errorCause = throwable;
                this.notifyError(throwable);
                this.recycle();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release() {
        Object object = this.lock;
        synchronized (object) {
            if (!this.isReleased) {
                logger.debug("release reader for stream {}", (Object)this.streamId);
                if (this.fileInfo.isPartitionSplitEnabled() && !this.errorNotified) {
                    this.associatedChannel.writeAndFlush((Object)new RpcRequest(TransportClient.requestId(), (ManagedBuffer)new NioManagedBuffer(new TransportMessage(MessageType.BUFFER_STREAM_END, PbBufferStreamEnd.newBuilder().setStreamType(StreamType.CreditStream).setStreamId(this.streamId).build().toByteArray()).toByteBuffer())));
                }
                if (!this.buffersToSend.isEmpty()) {
                    this.numInUseBuffers.addAndGet(-1 * this.buffersToSend.size());
                    this.buffersToSend.forEach(RecyclableBuffer::recycle);
                    this.buffersToSend.clear();
                }
                this.isReleased = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isFinished() {
        Object object = this.lock;
        synchronized (object) {
            return this.numInUseBuffers.get() == 0 && this.isReleased;
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("DataPartitionReader{");
        sb.append("startPartitionIndex=").append(this.startPartitionIndex);
        sb.append(", endPartitionIndex=").append(this.endPartitionIndex);
        sb.append(", streamId=").append(this.streamId);
        sb.append('}');
        return sb.toString();
    }

    public long getStreamId() {
        return this.streamId;
    }

    @VisibleForTesting
    public AtomicInteger getNumInUseBuffers() {
        return this.numInUseBuffers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean shouldReadData() {
        Object object = this.lock;
        synchronized (object) {
            return !this.isReleased && !this.readFinished;
        }
    }
}

