/*
 * Decompiled with CFR 0.152.
 */
package org.apache.celeborn.client.read;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.LongAdder;
import org.apache.celeborn.client.ShuffleClient;
import org.apache.celeborn.client.compress.Decompressor;
import org.apache.celeborn.client.read.DfsPartitionReader;
import org.apache.celeborn.client.read.LocalPartitionReader;
import org.apache.celeborn.client.read.MetricsCallback;
import org.apache.celeborn.client.read.PartitionReader;
import org.apache.celeborn.client.read.WorkerPartitionReader;
import org.apache.celeborn.common.CelebornConf;
import org.apache.celeborn.common.exception.CelebornIOException;
import org.apache.celeborn.common.network.client.TransportClientFactory;
import org.apache.celeborn.common.network.util.TransportConf;
import org.apache.celeborn.common.protocol.CompressionCodec;
import org.apache.celeborn.common.protocol.PartitionLocation;
import org.apache.celeborn.common.protocol.StorageInfo;
import org.apache.celeborn.common.unsafe.Platform;
import org.apache.celeborn.common.util.Utils;
import org.apache.celeborn.shaded.com.google.common.util.concurrent.Uninterruptibles;
import org.apache.celeborn.shaded.io.netty.buffer.ByteBuf;
import org.apache.celeborn.shaded.org.roaringbitmap.RoaringBitmap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class CelebornInputStream
extends InputStream {
    private static final Logger logger = LoggerFactory.getLogger(CelebornInputStream.class);
    private static final CelebornInputStream emptyInputStream = new CelebornInputStream(){

        @Override
        public int read() throws IOException {
            return -1;
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            return -1;
        }

        @Override
        public int totalPartitionsToRead() {
            return 0;
        }

        @Override
        public int partitionsRead() {
            return 0;
        }
    };

    public static CelebornInputStream create(CelebornConf conf, TransportClientFactory clientFactory, String shuffleKey, PartitionLocation[] locations, int[] attempts, int attemptNumber, int startMapIndex, int endMapIndex, ConcurrentHashMap<String, Long> fetchExcludedWorkers, MetricsCallback metricsCallback) throws IOException {
        if (locations == null || locations.length == 0) {
            return emptyInputStream;
        }
        return new CelebornInputStreamImpl(conf, clientFactory, shuffleKey, locations, attempts, attemptNumber, startMapIndex, endMapIndex, fetchExcludedWorkers, metricsCallback);
    }

    public static CelebornInputStream empty() {
        return emptyInputStream;
    }

    public abstract int totalPartitionsToRead();

    public abstract int partitionsRead();

    private static final class CelebornInputStreamImpl
    extends CelebornInputStream {
        private static final Random RAND = new Random();
        private final CelebornConf conf;
        private final TransportClientFactory clientFactory;
        private final String shuffleKey;
        private final PartitionLocation[] locations;
        private final int[] attempts;
        private final int attemptNumber;
        private final int startMapIndex;
        private final int endMapIndex;
        private final Map<Integer, Set<Integer>> batchesRead = new HashMap<Integer, Set<Integer>>();
        private byte[] compressedBuf;
        private byte[] rawDataBuf;
        private Decompressor decompressor;
        private ByteBuf currentChunk;
        private PartitionReader currentReader;
        private final int fetchChunkMaxRetry;
        private int fetchChunkRetryCnt = 0;
        int retryWaitMs;
        private int fileIndex;
        private int position;
        private int limit;
        private MetricsCallback callback;
        private final int BATCH_HEADER_SIZE = 16;
        private final byte[] sizeBuf = new byte[16];
        private LongAdder skipCount = new LongAdder();
        private final boolean rangeReadFilter;
        private final boolean enabledReadLocalShuffle;
        private final String localHostAddress;
        private boolean pushReplicateEnabled;
        private boolean fetchExcludeWorkerOnFailureEnabled;
        private boolean shuffleCompressionEnabled;
        private long fetchExcludedWorkerExpireTimeout;
        private final ConcurrentHashMap<String, Long> fetchExcludedWorkers;
        private boolean containLocalRead = false;

        CelebornInputStreamImpl(CelebornConf conf, TransportClientFactory clientFactory, String shuffleKey, PartitionLocation[] locations, int[] attempts, int attemptNumber, int startMapIndex, int endMapIndex, ConcurrentHashMap<String, Long> fetchExcludedWorkers, MetricsCallback metricsCallback) throws IOException {
            this.conf = conf;
            this.clientFactory = clientFactory;
            this.shuffleKey = shuffleKey;
            this.locations = (PartitionLocation[])Utils.randomizeInPlace(locations, RAND);
            this.attempts = attempts;
            this.attemptNumber = attemptNumber;
            this.startMapIndex = startMapIndex;
            this.endMapIndex = endMapIndex;
            this.rangeReadFilter = conf.shuffleRangeReadFilterEnabled();
            this.enabledReadLocalShuffle = conf.enableReadLocalShuffleFile();
            this.localHostAddress = Utils.localHostName(conf);
            this.pushReplicateEnabled = conf.clientPushReplicateEnabled();
            this.fetchExcludeWorkerOnFailureEnabled = conf.clientFetchExcludeWorkerOnFailureEnabled();
            this.shuffleCompressionEnabled = !conf.shuffleCompressionCodec().equals((Object)CompressionCodec.NONE);
            this.fetchExcludedWorkerExpireTimeout = conf.clientFetchExcludedWorkerExpireTimeout();
            this.fetchExcludedWorkers = fetchExcludedWorkers;
            int bufferSize = conf.clientFetchBufferSize();
            if (this.shuffleCompressionEnabled) {
                int headerLen = Decompressor.getCompressionHeaderLength(conf);
                this.compressedBuf = new byte[bufferSize += headerLen];
                this.decompressor = Decompressor.getDecompressor(conf);
            }
            this.rawDataBuf = new byte[bufferSize];
            this.fetchChunkMaxRetry = conf.clientPushReplicateEnabled() ? conf.clientFetchMaxRetriesForEachReplica() * 2 : conf.clientFetchMaxRetriesForEachReplica();
            TransportConf transportConf = Utils.fromCelebornConf(conf, "data", 0);
            this.retryWaitMs = transportConf.ioRetryWaitTimeMs();
            this.callback = metricsCallback;
            this.moveToNextReader();
        }

        private boolean skipLocation(int startMapIndex, int endMapIndex, PartitionLocation location) {
            if (!this.rangeReadFilter) {
                return false;
            }
            if (endMapIndex == Integer.MAX_VALUE) {
                return false;
            }
            RoaringBitmap bitmap = location.getMapIdBitMap();
            if (bitmap == null && location.hasPeer()) {
                bitmap = location.getPeer().getMapIdBitMap();
            }
            for (int i = startMapIndex; i < endMapIndex; ++i) {
                if (!bitmap.contains(i)) continue;
                return false;
            }
            return true;
        }

        private PartitionLocation nextReadableLocation() {
            int locationCount = this.locations.length;
            if (this.fileIndex >= locationCount) {
                return null;
            }
            PartitionLocation currentLocation = this.locations[this.fileIndex];
            while (this.skipLocation(this.startMapIndex, this.endMapIndex, currentLocation)) {
                this.skipCount.increment();
                ++this.fileIndex;
                if (this.fileIndex == locationCount) {
                    return null;
                }
                currentLocation = this.locations[this.fileIndex];
            }
            this.fetchChunkRetryCnt = 0;
            return currentLocation;
        }

        private void moveToNextReader() throws IOException {
            PartitionLocation currentLocation;
            if (this.currentReader != null) {
                this.currentReader.close();
                this.currentReader = null;
            }
            if ((currentLocation = this.nextReadableLocation()) == null) {
                return;
            }
            this.currentReader = this.createReaderWithRetry(currentLocation);
            ++this.fileIndex;
            while (!this.currentReader.hasNext()) {
                this.currentReader.close();
                this.currentReader = null;
                currentLocation = this.nextReadableLocation();
                if (currentLocation == null) {
                    return;
                }
                this.currentReader = this.createReaderWithRetry(currentLocation);
                ++this.fileIndex;
            }
            this.currentChunk = this.getNextChunk();
        }

        private void excludeFailedLocation(PartitionLocation location, Exception e) {
            if (this.pushReplicateEnabled && this.fetchExcludeWorkerOnFailureEnabled && this.isCriticalCause(e)) {
                this.fetchExcludedWorkers.put(location.hostAndFetchPort(), System.currentTimeMillis());
            }
        }

        private boolean isExcluded(PartitionLocation location) {
            Long timestamp = this.fetchExcludedWorkers.get(location.hostAndFetchPort());
            if (timestamp == null) {
                return false;
            }
            if (System.currentTimeMillis() - timestamp > this.fetchExcludedWorkerExpireTimeout) {
                this.fetchExcludedWorkers.remove(location.hostAndFetchPort());
                return false;
            }
            if (location.getPeer() != null) {
                Long peerTimestamp = this.fetchExcludedWorkers.get(location.getPeer().hostAndFetchPort());
                return peerTimestamp == null || peerTimestamp < timestamp;
            }
            return true;
        }

        private boolean isCriticalCause(Exception e) {
            boolean rpcTimeout = e instanceof IOException && e.getCause() != null && e.getCause() instanceof TimeoutException;
            boolean connectException = e instanceof CelebornIOException && e.getMessage() != null && (e.getMessage().startsWith("Connecting to") || e.getMessage().startsWith("Failed to"));
            boolean fetchChunkTimeout = e instanceof CelebornIOException && e.getCause() != null && e.getCause() instanceof IOException;
            return connectException || rpcTimeout || fetchChunkTimeout;
        }

        private PartitionReader createReaderWithRetry(PartitionLocation location) throws IOException {
            Exception lastException = null;
            while (this.fetchChunkRetryCnt < this.fetchChunkMaxRetry) {
                try {
                    if (this.isExcluded(location)) {
                        throw new CelebornIOException("Fetch data from excluded worker! " + location);
                    }
                    return this.createReader(location, this.fetchChunkRetryCnt, this.fetchChunkMaxRetry);
                }
                catch (Exception e) {
                    lastException = e;
                    this.excludeFailedLocation(location, e);
                    ++this.fetchChunkRetryCnt;
                    if (location.hasPeer()) {
                        if (this.fetchChunkRetryCnt % 2 == 0) {
                            Uninterruptibles.sleepUninterruptibly(this.retryWaitMs, TimeUnit.MILLISECONDS);
                        }
                        logger.warn("CreatePartitionReader failed {}/{} times for location {}, change to peer", new Object[]{this.fetchChunkRetryCnt, this.fetchChunkMaxRetry, location, e});
                        location = location.getPeer();
                        continue;
                    }
                    logger.warn("CreatePartitionReader failed {}/{} times for location {}, retry the same location", new Object[]{this.fetchChunkRetryCnt, this.fetchChunkMaxRetry, location, e});
                    Uninterruptibles.sleepUninterruptibly(this.retryWaitMs, TimeUnit.MILLISECONDS);
                }
            }
            throw new CelebornIOException("createPartitionReader failed! " + location, (Throwable)lastException);
        }

        private ByteBuf getNextChunk() throws IOException {
            while (this.fetchChunkRetryCnt < this.fetchChunkMaxRetry) {
                try {
                    if (this.isExcluded(this.currentReader.getLocation())) {
                        throw new CelebornIOException("Fetch data from excluded worker! " + this.currentReader.getLocation());
                    }
                    return this.currentReader.next();
                }
                catch (Exception e) {
                    this.excludeFailedLocation(this.currentReader.getLocation(), e);
                    ++this.fetchChunkRetryCnt;
                    this.currentReader.close();
                    if (this.fetchChunkRetryCnt == this.fetchChunkMaxRetry) {
                        logger.warn("Fetch chunk fail exceeds max retry {}", (Object)this.fetchChunkRetryCnt, (Object)e);
                        throw new CelebornIOException("Fetch chunk failed for " + this.fetchChunkRetryCnt + " times for location " + this.currentReader.getLocation(), (Throwable)e);
                    }
                    if (this.currentReader.getLocation().hasPeer()) {
                        logger.warn("Fetch chunk failed {}/{} times for location {}, change to peer", new Object[]{this.fetchChunkRetryCnt, this.fetchChunkMaxRetry, this.currentReader.getLocation(), e});
                        if (this.fetchChunkRetryCnt % 2 == 0) {
                            Uninterruptibles.sleepUninterruptibly(this.retryWaitMs, TimeUnit.MILLISECONDS);
                        }
                        this.currentReader = this.createReaderWithRetry(this.currentReader.getLocation().getPeer());
                        continue;
                    }
                    logger.warn("Fetch chunk failed {}/{} times for location {}", new Object[]{this.fetchChunkRetryCnt, this.fetchChunkMaxRetry, this.currentReader.getLocation(), e});
                    Uninterruptibles.sleepUninterruptibly(this.retryWaitMs, TimeUnit.MILLISECONDS);
                    this.currentReader = this.createReaderWithRetry(this.currentReader.getLocation());
                }
            }
            throw new CelebornIOException("Fetch chunk failed! " + this.currentReader.getLocation());
        }

        private PartitionReader createReader(PartitionLocation location, int fetchChunkRetryCnt, int fetchChunkMaxRetry) throws IOException, InterruptedException {
            if (!location.hasPeer()) {
                logger.debug("Partition {} has only one partition replica.", (Object)location);
            } else if (this.attemptNumber % 2 == 1) {
                location = location.getPeer();
                logger.debug("Read peer {} for attempt {}.", (Object)location, (Object)this.attemptNumber);
            }
            logger.debug("Create reader for location {}", (Object)location);
            StorageInfo storageInfo = location.getStorageInfo();
            switch (storageInfo.getType()) {
                case HDD: 
                case SSD: {
                    if (this.enabledReadLocalShuffle && location.getWorker().host().equals(this.localHostAddress)) {
                        logger.debug("Read local shuffle file {}", (Object)this.localHostAddress);
                        this.containLocalRead = true;
                        return new LocalPartitionReader(this.conf, this.shuffleKey, location, this.clientFactory, this.startMapIndex, this.endMapIndex, this.callback);
                    }
                    return new WorkerPartitionReader(this.conf, this.shuffleKey, location, this.clientFactory, this.startMapIndex, this.endMapIndex, fetchChunkRetryCnt, fetchChunkMaxRetry, this.callback);
                }
                case HDFS: {
                    return new DfsPartitionReader(this.conf, this.shuffleKey, location, this.clientFactory, this.startMapIndex, this.endMapIndex, this.callback);
                }
            }
            throw new CelebornIOException(String.format("Unknown storage info %s to read location %s", storageInfo, location));
        }

        @Override
        public int read() throws IOException {
            if (this.position < this.limit) {
                byte b = this.rawDataBuf[this.position];
                ++this.position;
                return b & 0xFF;
            }
            if (!this.fillBuffer()) {
                return -1;
            }
            if (this.position >= this.limit) {
                return this.read();
            }
            byte b = this.rawDataBuf[this.position];
            ++this.position;
            return b & 0xFF;
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            int readBytes;
            int bytesToRead;
            if (b == null) {
                throw new NullPointerException();
            }
            if (off < 0 || len < 0 || len > b.length - off) {
                throw new IndexOutOfBoundsException();
            }
            if (len == 0) {
                return 0;
            }
            for (readBytes = 0; readBytes < len; readBytes += bytesToRead) {
                while (this.position >= this.limit) {
                    if (this.fillBuffer()) continue;
                    return readBytes > 0 ? readBytes : -1;
                }
                bytesToRead = Math.min(this.limit - this.position, len - readBytes);
                System.arraycopy(this.rawDataBuf, this.position, b, off + readBytes, bytesToRead);
                this.position += bytesToRead;
            }
            return readBytes;
        }

        @Override
        public void close() {
            int locationsCount = this.locations.length;
            logger.debug("total location count {} read {} skip {}", new Object[]{locationsCount, (long)locationsCount - this.skipCount.sum(), this.skipCount.sum()});
            if (this.currentChunk != null) {
                logger.debug("Release chunk {}", (Object)this.currentChunk);
                this.currentChunk.release();
                this.currentChunk = null;
            }
            if (this.currentReader != null) {
                logger.debug("Closing reader");
                this.currentReader.close();
                this.currentReader = null;
            }
            if (this.containLocalRead) {
                ShuffleClient.printReadStats(logger);
            }
        }

        private boolean moveToNextChunk() throws IOException {
            if (this.currentChunk != null) {
                this.currentChunk.release();
            }
            this.currentChunk = null;
            if (this.currentReader.hasNext()) {
                this.currentChunk = this.getNextChunk();
                return true;
            }
            if (this.fileIndex < this.locations.length) {
                this.moveToNextReader();
                return this.currentReader != null;
            }
            if (this.currentReader != null) {
                this.currentReader.close();
                this.currentReader = null;
            }
            return false;
        }

        private boolean fillBuffer() throws IOException {
            if (this.currentChunk == null) {
                return false;
            }
            boolean hasData = false;
            while (this.currentChunk.isReadable() || this.moveToNextChunk()) {
                Set<Object> batchSet;
                this.currentChunk.readBytes(this.sizeBuf);
                int mapId = Platform.getInt(this.sizeBuf, Platform.BYTE_ARRAY_OFFSET);
                int attemptId = Platform.getInt(this.sizeBuf, Platform.BYTE_ARRAY_OFFSET + 4);
                int batchId = Platform.getInt(this.sizeBuf, Platform.BYTE_ARRAY_OFFSET + 8);
                int size = Platform.getInt(this.sizeBuf, Platform.BYTE_ARRAY_OFFSET + 12);
                if (this.shuffleCompressionEnabled) {
                    if (size > this.compressedBuf.length) {
                        this.compressedBuf = new byte[size];
                    }
                    this.currentChunk.readBytes(this.compressedBuf, 0, size);
                } else {
                    if (size > this.rawDataBuf.length) {
                        this.rawDataBuf = new byte[size];
                    }
                    this.currentChunk.readBytes(this.rawDataBuf, 0, size);
                }
                if (attemptId != this.attempts[mapId]) continue;
                if (!this.batchesRead.containsKey(mapId)) {
                    batchSet = new HashSet();
                    this.batchesRead.put(mapId, batchSet);
                }
                if (!(batchSet = this.batchesRead.get(mapId)).contains(batchId)) {
                    batchSet.add(batchId);
                    this.callback.incBytesRead(16 + size);
                    if (this.shuffleCompressionEnabled) {
                        int originalLength = this.decompressor.getOriginalLen(this.compressedBuf);
                        if (this.rawDataBuf.length < originalLength) {
                            this.rawDataBuf = new byte[originalLength];
                        }
                        this.limit = this.decompressor.decompress(this.compressedBuf, this.rawDataBuf, 0);
                    } else {
                        this.limit = size;
                    }
                    this.position = 0;
                    hasData = true;
                    break;
                }
                logger.debug("Skip duplicated batch: mapId {}, attemptId {}, batchId {}.", new Object[]{mapId, attemptId, batchId});
            }
            return hasData;
        }

        @Override
        public int totalPartitionsToRead() {
            return this.locations.length;
        }

        @Override
        public int partitionsRead() {
            return this.fileIndex;
        }
    }
}

