# Licensed to the Apache Software Foundation (ASF) under one
# or more contributor license agreements.  See the NOTICE file
# distributed with this work for additional information
# regarding copyright ownership.  The ASF licenses this file
# to you under the Apache License, Version 2.0 (the
# "License"); you may not use this file except in compliance
# with the License.  You may obtain a copy of the License at
#
#   http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing,
# software distributed under the License is distributed on an
# "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
# KIND, either express or implied.  See the License for the
# specific language governing permissions and limitations
# under the License.

resource "google_storage_bucket_iam_member" "private_logs_bucket_iam_cd" {
  bucket = var.cloudbuild_bucket_private
  role = "roles/storage.objectAdmin"
  member = "serviceAccount:${data.google_service_account.playground_cd_sa.email}"
}

resource "google_storage_bucket_iam_member" "private_logs_bucket_iam_ci" {
  bucket = var.cloudbuild_bucket_private
  role = "roles/storage.objectAdmin"
  member = "serviceAccount:${data.google_service_account.playground_ci_sa.email}"
}

resource "google_storage_bucket_iam_member" "public_logs_bucket_iam_cd" {
  bucket = var.cloudbuild_bucket_public
  role = "roles/storage.objectAdmin"
  member = "serviceAccount:${data.google_service_account.playground_cd_sa.email}"
}

resource "google_storage_bucket_iam_member" "public_logs_bucket_iam_ci" {
  bucket = var.cloudbuild_bucket_public
  role = "roles/storage.objectAdmin"
  member = "serviceAccount:${data.google_service_account.playground_ci_sa.email}"
}

resource "google_storage_bucket_iam_member" "public_logs_bucket_iam_all" {
  bucket = var.cloudbuild_bucket_public
  role = "roles/storage.objectViewer"
  member = "allUsers"
}