/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.gef.policy.snapping;

import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.wb.core.model.IAbstractComponentInfo;
import org.eclipse.wb.internal.core.gef.policy.snapping.IVisualDataProvider;

public final class PlacementUtils {
    public static int getOppositeSide(int side) {
        switch (side) {
            case 1: {
                return 4;
            }
            case 4: {
                return 1;
            }
            case 8: {
                return 32;
            }
            case 32: {
                return 8;
            }
        }
        throw new IllegalArgumentException("Invalid side requested: " + side);
    }

    public static boolean isTrailingSide(int side) {
        return side == 4 || side == 32;
    }

    public static boolean isLeadingSide(int side) {
        return side == 1 || side == 8;
    }

    public static boolean isHorizontalSide(int side) {
        return side == 1 || side == 4;
    }

    public static int getSide(boolean isHorizontal, boolean isLeading) {
        if (isLeading) {
            return isHorizontal ? 1 : 8;
        }
        return isHorizontal ? 4 : 32;
    }

    public static int getSidePosition(int side) {
        return PlacementUtils.isTrailingSide(side) ? 1 : 0;
    }

    public static int extractResizingSide(boolean isHorizontal, int side) {
        if (isHorizontal) {
            if ((side & 8) != 0) {
                return 1;
            }
            if ((side & 0x10) != 0) {
                return 4;
            }
        } else {
            if ((side & 1) != 0) {
                return 8;
            }
            if ((side & 4) != 0) {
                return 32;
            }
        }
        throw new IllegalArgumentException("Wrong side value: " + side);
    }

    public static boolean hasHorizontalResizeSide(int resizeDirection) {
        return (resizeDirection & 8) != 0 || (resizeDirection & 0x10) != 0;
    }

    public static boolean hasVerticalResizeSide(int resizeDirection) {
        return (resizeDirection & 1) != 0 || (resizeDirection & 4) != 0;
    }

    public static int getSideSize(Dimension size, int side) {
        if (PlacementUtils.isHorizontalSide(side)) {
            return size.width;
        }
        return size.height;
    }

    public static Rectangle getTranslatedBounds(IVisualDataProvider visualDataProvider, IAbstractComponentInfo widget) {
        return PlacementUtils.getTranslatedBounds(visualDataProvider, widget.getModelBounds().getCopy());
    }

    public static Rectangle getTranslatedBounds(IVisualDataProvider visualDataProvider, Rectangle bounds) {
        return PlacementUtils.getTranslatedBounds(visualDataProvider.getClientAreaOffset(), bounds);
    }

    public static Rectangle getTranslatedBounds(Point clientAreaOffset, IAbstractComponentInfo widget) {
        return PlacementUtils.getTranslatedBounds(clientAreaOffset, widget.getModelBounds().getCopy());
    }

    public static Rectangle getTranslatedBounds(Point clientAreaOffset, Rectangle bounds) {
        return bounds.getTranslated(clientAreaOffset.getNegated());
    }

    public static int getSize(IAbstractComponentInfo component, boolean isHorizontal) {
        Rectangle bounds = component.getModelBounds();
        return isHorizontal ? bounds.width : bounds.height;
    }
}

